/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.e1pdb;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.DialogTraversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;

class OSSPanel
extends DialogTraversable {
    static final String[] SUPPORTED_KEYS = new String[]{"oss.enabled", "oss.identity_domain", "oss.service_name", "oss.username", "oss.password"};
    private JCheckBox mConfigEnabled = new JCheckBox();
    private JTextField mDomain = new JTextField();
    private JTextField mService = new JTextField();
    private JTextField mUser = new JTextField();
    private JPasswordField mPwd = new JPasswordField();

    OSSPanel() {
    }

    static Namespace createNamespace(Properties properties) {
        Namespace namespace = new Namespace();
        for (String string : SUPPORTED_KEYS) {
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            namespace.put(string, (Object)string2);
        }
        return namespace;
    }

    static Properties createProperties(Namespace namespace) {
        Properties properties = new Properties();
        for (String string : SUPPORTED_KEYS) {
            String string2 = (String)namespace.get(string);
            if (string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public String getHelpID() {
        return null;
    }

    protected Component createComponent() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        ResourceUtils.resButton((AbstractButton)this.mConfigEnabled, (String)CloudResources.getString("LABEL_OSS_INCLUDE"));
        this.mConfigEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OSSPanel.this.enableControls(itemEvent.getStateChange() == 1);
            }
        });
        this.enableControls(this.mConfigEnabled.isSelected());
        jPanel.add((Component)this.mConfigEnabled, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.FIRST_LINE_START));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mDomain, (String)CloudResources.getString("LABEL_OSS_IDENTITY_DOMAIN"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.mDomain, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mService, (String)CloudResources.getString("LABEL_OSS_SERVICE_NAME"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mService, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mUser, (String)CloudResources.getString("LABEL_OSS_USERNAME"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mUser, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mPwd, (String)CloudResources.getString("LABEL_OSS_PASSWORD"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.mPwd, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)LayoutControl.GBC.createSubPanel((Component)jPanel2), LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        return jPanel;
    }

    public Component getInitialFocusComponent() {
        return this.mDomain;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = this.mConfigEnabled.isSelected();
        String string = this.mDomain.getText();
        String string2 = this.mService.getText();
        String string3 = this.mUser.getText();
        if (bl) {
            if (!OSSPanel.isValid(string)) {
                throw new TraversalException(CloudResources.format("ERROR_INVALID_OSS_CONFIG", CloudResources.getString("ERROR_MISSING_IDENTITY_DOMAIN")));
            }
            if (!OSSPanel.isValid(string2)) {
                throw new TraversalException(CloudResources.format("ERROR_INVALID_OSS_CONFIG", CloudResources.getString("ERROR_MISSING_SERVICE_NAME")));
            }
            if (!OSSPanel.isValid(string3)) {
                throw new TraversalException(CloudResources.format("ERROR_INVALID_OSS_CONFIG", CloudResources.getString("ERROR_MISSING_USERNAME")));
            }
        }
        traversableContext.put("oss.enabled", (Object)Boolean.toString(bl));
        traversableContext.put("oss.identity_domain", (Object)string);
        traversableContext.put("oss.service_name", (Object)string2);
        traversableContext.put("oss.username", (Object)string3);
        char[] cArray = this.mPwd.getPassword();
        traversableContext.put("oss.password", (Object)(cArray != null ? new String(cArray) : new String()));
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = (String)traversableContext.get("oss.identity_domain");
        if (string != null) {
            this.mDomain.setText(string);
        }
        if ((string = (String)traversableContext.get("oss.service_name")) != null) {
            this.mService.setText(string);
        }
        if ((string = (String)traversableContext.get("oss.username")) != null) {
            this.mUser.setText(string);
        }
        if ((string = (String)traversableContext.get("oss.password")) != null) {
            this.mPwd.setText(string);
        }
        string = (String)traversableContext.get("oss.enabled");
        boolean bl = Boolean.parseBoolean(string);
        this.mConfigEnabled.setSelected(bl);
    }

    private void enableControls(boolean bl) {
        this.mDomain.setEnabled(bl);
        this.mService.setEnabled(bl);
        this.mUser.setEnabled(bl);
        this.mPwd.setEnabled(bl);
    }

    private static boolean isValid(String string) {
        return string != null && string.trim().length() > 0;
    }
}

