/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.e1pdb;

import java.awt.Component;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oracle.dbtools.raptor.cloud.CloudResources;
import oracle.dbtools.raptor.cloud.e1pdb.CloudConfigurationException;
import oracle.dbtools.raptor.cloud.e1pdb.CloudProcessor;
import oracle.dbtools.raptor.cloud.e1pdb.OSSPanel;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Logger;
import oracle.ide.util.ResourceUtils;

public class CloudPanel
implements OracleConnectionTypePanel {
    private static final OracleConnectionType CLOUD_TYPE = OracleConnectionType.findType((String)"CLOUD");
    private Component mPanel;
    private URLFileChooser.URLFileChooserPanel mChooser = URLFileChooser.createURLFileChooserPanel((int)0, (String)CloudResources.getString("LABEL_CONFIG_FILE"), (boolean)false);
    private JPasswordField mKeystorePassword = new JPasswordField();
    private JButton mOSSConfigBtn = new JButton();
    private Properties mOSSConfig = new Properties();

    public void generateProperties(Properties properties) {
        Object object;
        File file = this.mChooser.getSelectedFile();
        if (file != null) {
            properties.setProperty("sqldev.cloud.configfile", file.getAbsolutePath());
        }
        try {
            object = CloudProcessor.getCloudConfigForZip(file);
            if (object != null) {
                properties.setProperty("customUrl", ((CloudProcessor.CloudConfig)object).getConnectionName());
            }
        }
        catch (CloudConfigurationException cloudConfigurationException) {
            Logger.warn(CloudProcessor.class, (Throwable)cloudConfigurationException);
        }
        object = this.mKeystorePassword.getPassword();
        properties.setProperty("sqldev.cloud.keystore-password", new String((char[])object));
        properties.setProperty("OracleConnectionType", CLOUD_TYPE.name());
        properties.putAll((Map<?, ?>)this.mOSSConfig);
    }

    public void updatePrompts(Properties properties) {
        Object object;
        String string = properties.getProperty("sqldev.cloud.configfile");
        if (string != null) {
            object = new File(string);
            this.mChooser.setSelectedFile((File)object);
        }
        if ((object = properties.getProperty("sqldev.cloud.keystore-password")) != null) {
            this.mKeystorePassword.setText((String)object);
        }
        this.mOSSConfig.clear();
        for (String string2 : OSSPanel.SUPPORTED_KEYS) {
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            this.mOSSConfig.setProperty(string2, string3);
        }
    }

    public void clear() {
        this.mChooser.setSelectedURL(null);
        this.mKeystorePassword.setText("");
        this.mOSSConfig.clear();
    }

    public void setDefaultPrompts() {
        this.clear();
    }

    public Component getPanel() {
        if (this.mPanel == null) {
            this.mPanel = this.createUI();
        }
        return this.mPanel;
    }

    public OracleConnectionType getConnectionType() {
        return CLOUD_TYPE;
    }

    public void setOwner(OracleConnectionPanel oracleConnectionPanel) {
    }

    private Component createUI() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        this.mChooser.clearChooseableURLFilters();
        this.mChooser.addChooseableURLFilter(CloudProcessor.ZIPFILE_FILE);
        this.mChooser.setSelectionScope(0);
        this.mChooser.setSelectionMode(0);
        this.mChooser.setShowJarsAsDirs(false);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mChooser, (String)CloudResources.getString("LABEL_CONFIG_FILE"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.mChooser, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.mKeystorePassword, (String)CloudResources.getString("LABEL_KEYSTORE_PWD"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel.add((Component)this.mKeystorePassword, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jPanel.add(Box.createGlue(), LayoutControl.GBC.gbc((int)0, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.LINE_START));
        return jPanel;
    }
}

