/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver7;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CaptureObjectsOnlineCapturer;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CaptureQueries;

public class SQLServer7Capturer
extends AbstractOnlineCapturer {
    protected SQLServer7CaptureObjectsOnlineCapturer m_7CaptureObjectsOnlineCapturer = null;
    private String m_modelName;
    public static final String MY_LANGUAGE_ID = "MSTSQL";
    public static final String NEWID_FUNCTION = "(newid())";
    private static String s_sqlServerDatabaseToUse = null;
    private static SQLServer7CaptureQueries s_captureQueries;

    public SQLServer7Capturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
        this.m_7CaptureObjectsOnlineCapturer = new SQLServer7CaptureObjectsOnlineCapturer(migrationStorer, connection);
    }

    public static String getSqlServerDatabaseToUse() {
        return SQLServer7CaptureObjectsOnlineCapturer.getSqlServerDatabaseToUse();
    }

    public static void setSqlServerDatabaseToUse(String string) {
        SQLServer7CaptureObjectsOnlineCapturer.setSqlServerDatabaseToUse(string);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new SQLServer7CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_7CaptureObjectsOnlineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                this.m_modelName = "\\\\" + stringArray[2] + "\\" + this.m_sourceConnection.getCatalog() + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                throw new CaptureException((Throwable)sQLException);
            }
        }
        return this.m_modelName;
    }
}

