/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver2005;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.sqlserverofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005CaptureObjectsOfflineCapturer;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005CaptureQueries;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005DoOfflineCaptureLoad;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005Messages;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005OfflineCaptureTables;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7AbstractCapturer;
import oracle.dbtools.util.Resource;

public class SQLServer2005OfflineCapturer
extends AbstractOfflineCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    protected SQLServer2005CaptureObjectsOfflineCapturer m_captureObjectsOfflineCapturer = null;
    protected SQLServer2005DoOfflineCaptureLoad dsml = null;
    private String m_modelName;
    private static SQLServer2005CaptureQueries s_captureQueries;

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        return null;
    }

    protected SQLServer2005CaptureObjectsOfflineCapturer getOfflineCapturer(MigrationStorer migrationStorer, Connection connection) {
        return new SQLServer2005CaptureObjectsOfflineCapturer(migrationStorer, connection);
    }

    public String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        String[] stringArray;
        Object object;
        this.setRepositoryConnection(MigrationAddin.getPersistenceManager().getConn());
        this.m_captureObjectsOfflineCapturer = this.getOfflineCapturer(this.getStorer(), MigrationAddin.getPersistenceManager().getConn());
        HashMap<File, ObjectStatusList> hashMap = new HashMap<File, ObjectStatusList>();
        ObjectStatusList objectStatusList = null;
        ArrayList arrayList = this.getSelectedDatabaseList();
        Connection connection = this.getRepositoryConnection();
        Statement statement = null;
        try {
            try {
                object = new SQLServer2005OfflineCaptureTables();
                stringArray = ((SQLServer2005OfflineCaptureTables)object).getTruncateTmpStatements();
                statement = connection.createStatement();
                for (String string2 : stringArray) {
                    try {
                        statement.executeUpdate(string2);
                    }
                    catch (SQLException sQLException) {
                        throw new OfflineCaptureException((Exception)sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new OfflineCaptureException((Exception)sQLException);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
            }
            SQLServer2005DoOfflineCaptureLoad.sourceModelIndexCreate(connection);
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        object = new File(string);
        for (String string2 : stringArray = ((File)object).list()) {
            String[] stringArray2;
            if (!new File(string + File.separator + string2).isDirectory()) continue;
            if (arrayList.contains(string2)) {
                this.addDatabaseToCapture(string2);
            }
            File file = new File(string + File.separator + string2);
            objectStatusList = new ObjectStatusList();
            for (String string3 : stringArray2 = file.list()) {
                if (!string3.endsWith(".dat") && !string3.endsWith(".DAT")) continue;
                objectStatusList.add(new File(string + File.separator + string2 + File.separator + string3), SQLServer2005Messages.getString("SQLServer2005OfflineCapturer.2"));
            }
            hashMap.put(file, objectStatusList);
        }
        this.dsml = new SQLServer2005DoOfflineCaptureLoad(connection);
        SQLServer2005DoOfflineCaptureLoad.setEncoding(this.getEncoding());
        try {
            this.dsml.convertBcpDumpToXML(hashMap);
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
        return "SQLServer2005" + string;
    }

    public void captureStarting() {
        try {
            int n;
            File file = this.dsml.getDbFile("MASTER");
            Connection connection = this.getRepositoryConnection();
            this.dsml.populateSourceModel(connection, file, 1);
            String string = this.getNextDatabase();
            File file2 = this.dsml.getDbFile(string);
            SQLServer7AbstractCapturer.OfflineDbId = n = this.dsml.getDbId(connection, string);
            this.dsml.populateSourceModel(connection, file2, n);
            connection.commit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void cleanUp() throws OfflineCaptureException {
        Connection connection = this.getRepositoryConnection();
        Statement statement = null;
        try {
            SQLServer2005OfflineCaptureTables sQLServer2005OfflineCaptureTables = new SQLServer2005OfflineCaptureTables();
            String[] stringArray = sQLServer2005OfflineCaptureTables.getTruncateTmpStatements();
            statement = connection.createStatement();
            for (String string : stringArray) {
                try {
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        String string2 = "/oracle/dbtools/migration/workbench/plugin/sqlserver2005files";
        this.writeFile(string, string2, "OMWB_OFFLINE_CAPTURE.BAT");
        this.writeFile(string, string2, "SS2K5_BCP_SCRIPT.BAT");
        this.writeFile(string, string2, "properties.sql");
        this.writeFile(string, string2, "sqlserver2005.ocp");
        String[] stringArray = new String[]{"OMWB_OFFLINE_CAPTURE.BAT", "sqlserver2005.ocp", "properties.sql", "SS2K5_BCP_SCRIPT.BAT"};
        return stringArray;
    }

    public String writeFile(String string, String string2, String string3) throws OfflineCaptureException {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            inputStream = new BufferedInputStream(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(string2 + "/" + string3)));
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string4 = object;
            return string4;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OfflineCaptureException((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public SQLServer2005OfflineCapturer(MigrationStorer migrationStorer, Connection connection) {
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_captureObjectsOfflineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
    }

    public String getModelName() throws CaptureException {
        return "SQLServer2005";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver2005";
    }

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection connection) {
        this.m_repositoryConnection = connection;
    }

    public String getEnterpriseCaptureFileName() {
        return "SQLServerEnterpriseCapture.xml";
    }
}

