/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sqlserver2005;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.core.MigrationContext;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005Arb;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005CaptureQueries;
import oracle.dbtools.migration.workbench.sqlserver2005.SQLServer2005Messages;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CapturerColumnInfo;
import oracle.dbtools.migration.workbench.sqlserver7.SQLServer7CapturerColumnsBySelect;

public abstract class SQLServer2005AbstractCapturer {
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    public static final String MY_LANGUAGE_ID = "MSTSQL";
    public static final String NEWID_FUNCTION = "(newid())";
    private static String[] s_sqlServerDatabasesToSkip = new String[]{"master", "msdb", "tempdb", "model"};
    private static String s_sqlServerDatabaseToUse = null;
    private static SQLServer2005CaptureQueries s_captureQueries;
    private boolean m_privilegeWarningWritten = false;
    private static int s_chunkSize;
    protected boolean m_online = true;

    public SQLServer2005AbstractCapturer(MigrationStorer migrationStorer, Connection connection) {
    }

    public static String getSqlServerDatabaseToUse() {
        return s_sqlServerDatabaseToUse;
    }

    public static void setSqlServerDatabaseToUse(String string) {
        s_sqlServerDatabaseToUse = string;
    }

    protected String getXTypeWhere() {
        return " a2.type IN ('U', 'V', 'U ', 'V ') ";
    }

    protected String getXTypeWhereInIndex() {
        return " o.type IN ('U', 'V', 'U ', 'V ')  ";
    }

    protected String getForCaptureIndex() {
        return " i.name NOT LIKE '_WA_Sys%' ";
    }

    protected String getWhereForStoredPrograms() {
        return " ( a.type = 'P' OR a.type = 'FN' OR a.type = 'TF' OR a.type = 'IF') ";
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new SQLServer2005CaptureQueries();
        }
        return s_captureQueries;
    }

    protected abstract String andExistsTablesOrProcedures();

    protected abstract String getDatabasesString();

    protected abstract String getSchemasString(String var1);

    protected abstract String getSchemaOwnerString(String var1);

    protected abstract String getSchemaString(String var1);

    protected abstract String getTablesString(String var1);

    protected abstract String getColumnsString(String var1, int var2);

    protected abstract String getIdentityString(String var1, int var2, int var3);

    protected abstract String getBaseTypeString(String var1, int var2);

    protected abstract String getColumnDefaultString(String var1, int var2);

    protected abstract String getCaptureIndexString(String var1);

    protected abstract String getIndexString(String var1, int var2, int var3);

    protected abstract String captureUniqueAndPrimaryKeysString(String var1);

    protected abstract String captureForeignKeysStringString(String var1);

    protected abstract String captureTableLevelCheckConstraintString(String var1);

    protected abstract String captureColumnLevelCheckConstraintString(String var1);

    protected abstract String captureRulesString(String var1);

    protected abstract String captureRulesTextString(String var1);

    protected abstract String captureViewOuterString(String var1);

    protected abstract String captureViewInnerString(String var1);

    protected abstract String captureStoredProgramOuterString(String var1);

    protected abstract String captureStoredProgramInnerString(String var1, String var2);

    protected abstract String captureTriggersString(String var1);

    protected abstract String captureCommentsString();

    protected abstract String captureRolesString(String var1);

    protected abstract void capturePrivileges(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4, MdGroup var5, MdUser var6) throws SQLException, PersistenceException;

    protected abstract void captureRoleMembership(Connection var1, MigrationStorer var2, CaptureContext var3, ArrayList<MdGroup> var4) throws SQLException, PersistenceException;

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        try {
            int n = 0;
            if (string.equals("MD_CATALOGS")) {
                this.captureCatalog(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_SCHEMAS")) {
                this.captureSchema(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_USERS")) {
                this.captureUser(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_TABLES")) {
                this.captureTable(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_COLUMNS")) {
                ++n;
            } else if (string.equals("MD_INDEXES")) {
                this.captureIndex(captureContext);
            } else if (string.equals("MD_INDEX_DETAILS")) {
                ++n;
            } else if (string.equals("MD_CONSTRAINTS")) {
                this.captureUniqueAndPrimaryKeys(captureContext);
                this.captureForeignKeys(captureContext);
                this.captureTableLevelCheckConstraint(captureContext);
                this.captureColumnLevelCheckConstraint(captureContext);
                this.captureRules(captureContext);
            } else if (string.equals("MD_CONSTRAINT_DETAILS")) {
                ++n;
            } else if (string.equals("MD_VIEWS")) {
                this.captureView(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_STORED_PROGRAMS")) {
                this.captureStoredProgram(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_TRIGGERS")) {
                this.captureTriggers(captureContext);
            } else if (string.equals("MD_GROUPS")) {
                this.captureRoles(captureContext, migrationObjectFilter);
            }
        }
        catch (SQLException sQLException) {
            throw new CaptureException((Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureCatalog(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        this.m_privilegeWarningWritten = false;
        Statement statement = null;
        ResultSet resultSet = null;
        SQLServer7CapturerColumnsBySelect.clearHashSet();
        try {
            String string = this.getDatabasesString();
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_CATALOGS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string = string + " and d.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String mdCatalog : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(mdCatalog);
                }
            }
            String[] stringArray = (String[])captureContext.getContextVariable("CONNECTIONID");
            statement = this.getRepositoryConnection().createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string2;
                String string22 = null;
                string22 = resultSet.getString(1);
                int n = 0;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string2 = string22)) {
                    n = 1;
                }
                for (String string3 : s_sqlServerDatabasesToSkip) {
                    if (!string22.toLowerCase().equals(string3)) continue;
                    n = 1;
                    break;
                }
                if (SQLServer2005AbstractCapturer.getSqlServerDatabaseToUse() != null && !string22.toLowerCase().equals(SQLServer2005AbstractCapturer.getSqlServerDatabaseToUse().toLowerCase())) {
                    n = 1;
                }
                if (n != 0) continue;
                MdCatalog mdCatalog = new MdCatalog((DBObjectId)stringArray);
                mdCatalog.setCatalogName(string22);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), mdCatalog.getCatalogName());
                captureContext.getAudience().fireListeners(captureEvent);
                MdCatalog mdCatalog2 = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(statement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)statement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    protected void captureSchema(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        try {
            String string = mdCatalog.getCatalogName();
            String string2 = this.getSchemasString(string);
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_SCHEMAS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string2 = string2 + " and s.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string3 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string3);
                }
            }
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            if (!this.m_online) {
                preparedStatement.setString(1, this.getDatabase((MigrationContext)captureContext));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string3;
                Object object = resultSet.getString(1);
                int n = 1;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(object)) {
                    n = 0;
                }
                if (n == 0) continue;
                MdSchema mdSchema = new MdSchema(mdCatalog.getKey());
                mdSchema.setName((String)object);
                string3 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), (String)object);
                captureContext.getAudience().fireListeners((CaptureEvent)string3);
                mdSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)mdSchema);
                string3.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)string3);
            }
        }
        catch (SQLException sQLException) {
            CloseableResultSet.close(preparedStatement, resultSet);
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUser(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        MdSchema mdSchema = (MdSchema)captureContext.getContextVariable("SCHEMAOBJ");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = mdCatalog.getCatalogName();
        String string2 = "";
        String string3 = this.getSchemaOwnerString(string);
        try {
            preparedStatement = this.getRepositoryConnection().prepareStatement(string3);
            if (!this.m_online) {
                preparedStatement.setString(1, this.getDatabase((MigrationContext)captureContext));
                preparedStatement.setString(2, mdSchema.getName());
            } else {
                preparedStatement.setString(1, mdSchema.getName());
            }
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        try {
            String string4 = this.getSchemaString(string);
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_USERS")) {
                throw new IllegalArgumentException("Filter is of incorrect type " + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string4 = string4 + " AND d.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string5 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string5);
                }
            }
            preparedStatement = this.getRepositoryConnection().prepareStatement(string4);
            if (!this.m_online) {
                preparedStatement.setString(1, this.getDatabase((MigrationContext)captureContext));
                preparedStatement.setString(2, mdSchema.getName());
            } else {
                preparedStatement.setString(1, mdSchema.getName());
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string5;
                String string6 = resultSet.getString(1);
                int n = 1;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string6)) {
                    n = 0;
                }
                if (n == 0) continue;
                MdUser mdUser = new MdUser(mdSchema.getKey(), string6);
                string5 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), string6);
                captureContext.getAudience().fireListeners((CaptureEvent)string5);
                AdditionalProperty additionalProperty = new AdditionalProperty("Login", resultSet.getString(2));
                mdUser.addProperty(additionalProperty, mdCatalog.getConnectionId());
                if (string6.equals(string2)) {
                    mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
                    AdditionalProperty additionalProperty2 = new AdditionalProperty("Schema Owner", mdUser.getKey().toString());
                    mdSchema.addProperty(additionalProperty2, mdCatalog.getConnectionId());
                    mdSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)mdSchema);
                }
                string5.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)string5);
            }
        }
        finally {
            CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        }
    }

    protected void captureTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        MdSchema mdSchema = null;
        mdSchema = (MdSchema)captureContext.getContextVariable("SCHEMAOBJ");
        this.mapTable(mdSchema, captureContext, migrationObjectFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void mapTable(MdSchema mdSchema, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException {
        block72: {
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string = this.getDatabase((MigrationContext)captureContext);
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            ResultSet resultSet = null;
            ResultSet resultSet2 = null;
            try {
                String string2 = this.getTablesString(string);
                HashSet<String> hashSet = null;
                if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_TABLES")) {
                    throw new IllegalArgumentException("Filter is of incorrect type " + migrationObjectFilter.getObjectType());
                }
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                    string2 = string2 + " and a.name " + migrationObjectFilter.getWhereClause();
                }
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                    hashSet = new HashSet<String>();
                    for (String string3 : migrationObjectFilter.getObjectNames()) {
                        hashSet.add(string3);
                    }
                }
                preparedStatement2 = this.getRepositoryConnection().prepareStatement(string2);
                if (!this.m_online) {
                    preparedStatement2.setString(1, string);
                    preparedStatement2.setString(2, mdSchema.getName());
                } else {
                    preparedStatement2.setString(1, mdSchema.getName());
                }
                String string4 = "";
                int n = 0;
                resultSet = preparedStatement2.executeQuery();
                while (resultSet.next() && !captureContext.shouldCancel()) {
                    String string5 = resultSet.getString(1);
                    int n2 = 1;
                    if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string5)) {
                        n2 = 0;
                    }
                    if (n2 == 0) continue;
                    n = resultSet.getInt(2);
                    int n3 = 1;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    resultSet2 = null;
                    try {
                        Object object;
                        Object object2;
                        void var12_17;
                        boolean bl = false;
                        String string6 = this.getColumnsString(string, n);
                        preparedStatement = this.getRepositoryConnection().prepareStatement(string6);
                        if (!this.m_online) {
                            preparedStatement.setString(1, string);
                        }
                        resultSet2 = preparedStatement.executeQuery();
                        MdTable mdTable = null;
                        Hashtable<Integer, MdColumn> hashtable = new Hashtable<Integer, MdColumn>();
                        int n7 = 0;
                        while (resultSet2.next()) {
                            ResultSet resultSet3;
                            PreparedStatement preparedStatement3;
                            MdColumn mdColumn;
                            String string7;
                            SQLServer7CapturerColumnInfo sQLServer7CapturerColumnInfo;
                            block71: {
                                String string8;
                                String string9;
                                ++n7;
                                if (!bl) {
                                    String string10;
                                    string9 = "[" + string + "].[" + mdSchema.getName() + "].[" + (String)var12_17 + "]";
                                    mdTable = new MdTable(mdSchema.getKey(), (String)var12_17, string9);
                                    object2 = null;
                                    object = null;
                                    try {
                                        string10 = this.captureCommentsString();
                                        object2 = this.getRepositoryConnection().prepareStatement(string10);
                                        object2.setInt(1, n);
                                        object2.setInt(2, 0);
                                        object = object2.executeQuery();
                                        if (object.next()) {
                                            String string11 = object.getString(1);
                                            mdTable.setComments(string11);
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.106"), (Throwable)sQLException);
                                    }
                                    finally {
                                        CloseableResultSet.close((Statement)object2, (ResultSet)object);
                                    }
                                    string10 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), (String)var12_17);
                                    captureContext.getAudience().fireListeners((CaptureEvent)string10);
                                    mdTable = (MdTable)this.getStorer().storeObject((PersistableObject)mdTable);
                                    string10.setEventId(4);
                                    captureContext.getAudience().fireListeners((CaptureEvent)string10);
                                }
                                bl = true;
                                string9 = this.getIdentityString(string, n, resultSet2.getInt(4));
                                object2 = null;
                                object = null;
                                long l = 0L;
                                boolean bl2 = false;
                                long l2 = 0L;
                                boolean bl3 = false;
                                long l3 = 0L;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                try {
                                    object2 = this.getRepositoryConnection().prepareStatement(string9);
                                    if (!this.m_online) {
                                        object2.setString(1, string);
                                    }
                                    if ((object = object2.executeQuery()).next()) {
                                        bl5 = true;
                                        l = object.getLong(1);
                                        bl2 = object.wasNull();
                                        l2 = object.getLong(2);
                                        bl3 = object.wasNull();
                                        l3 = object.getLong(3);
                                        bl4 = object.wasNull();
                                    }
                                }
                                catch (SQLException sQLException) {
                                    MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
                                }
                                finally {
                                    CloseableResultSet.close((Statement)object2, (ResultSet)object);
                                }
                                sQLServer7CapturerColumnInfo = new SQLServer7CapturerColumnInfo();
                                String string12 = resultSet2.getString(1);
                                string7 = string8 = resultSet2.getString(5);
                                sQLServer7CapturerColumnInfo.setNativeColumnName(resultSet2.getString(3));
                                sQLServer7CapturerColumnInfo.setNativeColumnType(string8);
                                int n8 = resultSet2.getInt(6);
                                boolean bl6 = resultSet2.wasNull();
                                if (bl6) {
                                    sQLServer7CapturerColumnInfo.setNativeColumnLength(null);
                                } else {
                                    sQLServer7CapturerColumnInfo.setNativeColumnLength(n8);
                                }
                                int n9 = resultSet2.getInt(8);
                                if (resultSet2.wasNull()) {
                                    sQLServer7CapturerColumnInfo.setNativeColumnScale(null);
                                } else {
                                    sQLServer7CapturerColumnInfo.setNativeColumnScale(n9);
                                }
                                if (resultSet2.getInt(9) == 0) {
                                    sQLServer7CapturerColumnInfo.setStatus(0);
                                } else {
                                    sQLServer7CapturerColumnInfo.setStatus(resultSet2.getInt(9));
                                }
                                int n10 = resultSet2.getInt(7);
                                boolean bl7 = resultSet2.wasNull();
                                n4 = resultSet2.getInt(10);
                                n5 = resultSet2.getInt(11);
                                n6 = resultSet2.getInt(12);
                                String string13 = this.baseType(n5, string);
                                sQLServer7CapturerColumnInfo.setColumnDefaultText(this.columnDefault(n6, string, string13));
                                boolean bl8 = false;
                                if (n4 > 256) {
                                    if (this.baseTypeIsNotHandled(string13)) {
                                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").warning(SQLServer2005Arb.format("CLR_USER_DEFINED_TYPE", "[" + string + "].[" + mdSchema.getName() + "].[" + string12 + "]", sQLServer7CapturerColumnInfo.getNativeColumnName()));
                                        string13 = "varbinary";
                                        sQLServer7CapturerColumnInfo.setStatus(1);
                                        sQLServer7CapturerColumnInfo.setNativeColumnPrecision(8000);
                                        bl8 = true;
                                    }
                                    sQLServer7CapturerColumnInfo.setNativeColumnType(string13);
                                }
                                if (!bl8) {
                                    string8 = sQLServer7CapturerColumnInfo.getNativeColumnType();
                                    if (string8.equalsIgnoreCase("varchar") || string8.equalsIgnoreCase("nvarchar") || string8.equalsIgnoreCase("nchar") || string8.equalsIgnoreCase("char") || string8.equalsIgnoreCase("varbinary") || string8.equalsIgnoreCase("binary")) {
                                        if (bl6) {
                                            sQLServer7CapturerColumnInfo.setNativeColumnPrecision(null);
                                        } else if (string8.equalsIgnoreCase("nvarchar") || string8.equalsIgnoreCase("nchar")) {
                                            if (n8 != -1) {
                                                sQLServer7CapturerColumnInfo.setNativeColumnPrecision(n8 / 2);
                                            } else {
                                                sQLServer7CapturerColumnInfo.setNativeColumnPrecision(n8);
                                            }
                                        } else {
                                            sQLServer7CapturerColumnInfo.setNativeColumnPrecision(n8);
                                        }
                                    } else if (bl7) {
                                        sQLServer7CapturerColumnInfo.setNativeColumnPrecision(null);
                                    } else {
                                        sQLServer7CapturerColumnInfo.setNativeColumnPrecision(n10);
                                    }
                                }
                                Integer[] integerArray = this.getPrecisionScaleIdentity(sQLServer7CapturerColumnInfo.getNativeColumnType(), sQLServer7CapturerColumnInfo.getNativeColumnPrecision(), sQLServer7CapturerColumnInfo.getNativeColumnScale());
                                sQLServer7CapturerColumnInfo.setNativeColumnPrecision(integerArray[0]);
                                sQLServer7CapturerColumnInfo.setNativeColumnScale(integerArray[1]);
                                mdColumn = null;
                                if (bl5) {
                                    if (!(bl2 || bl3 || bl4)) {
                                        mdColumn = new MdIdentityColumn(mdTable.getKey(), sQLServer7CapturerColumnInfo.getNativeColumnName(), Integer.valueOf(n7), l, l2, l3, dBObjectId);
                                    } else if (!bl2 && !bl3) {
                                        mdColumn = new MdIdentityColumn(mdTable.getKey(), sQLServer7CapturerColumnInfo.getNativeColumnName(), Integer.valueOf(n7), l, l2, dBObjectId);
                                    } else {
                                        if (bl2) {
                                            // empty if block
                                        }
                                        mdColumn = new MdIdentityColumn(mdTable.getKey(), sQLServer7CapturerColumnInfo.getNativeColumnName(), Integer.valueOf(n7), l, dBObjectId);
                                    }
                                } else {
                                    mdColumn = new MdColumn(mdTable.getKey(), sQLServer7CapturerColumnInfo.getNativeColumnName(), Integer.valueOf(n3));
                                }
                                mdColumn.setColumnType(sQLServer7CapturerColumnInfo.getNativeColumnType());
                                mdColumn.setDefaultValue(sQLServer7CapturerColumnInfo.getColumnDefaultText());
                                if (sQLServer7CapturerColumnInfo.getColumnDefaultText().equalsIgnoreCase(NEWID_FUNCTION)) {
                                    mdColumn.addProperty(NEWID_FUNCTION, "Y", dBObjectId);
                                }
                                if (sQLServer7CapturerColumnInfo.getStatus() == 0) {
                                    mdColumn.setNullable("N");
                                } else {
                                    mdColumn.setNullable("Y");
                                }
                                String string14 = sQLServer7CapturerColumnInfo.getNativeColumnType().toLowerCase();
                                if (sQLServer7CapturerColumnInfo.getNativeColumnPrecision() != null && sQLServer7CapturerColumnInfo.getNativeColumnPrecision() == -1 && (string14.equals("varchar") || string14.equals("nvarchar") || string14.equals("varbinary"))) {
                                    mdColumn.setPrecision(Integer.valueOf(-999));
                                } else {
                                    mdColumn.setPrecision(sQLServer7CapturerColumnInfo.getNativeColumnPrecision());
                                }
                                mdColumn.setScale(sQLServer7CapturerColumnInfo.getNativeColumnScale());
                                preparedStatement3 = null;
                                resultSet3 = null;
                                try {
                                    String string15 = this.captureCommentsString();
                                    preparedStatement3 = this.getRepositoryConnection().prepareStatement(string15);
                                    preparedStatement3.setInt(1, n);
                                    preparedStatement3.setInt(2, n7);
                                    resultSet3 = preparedStatement3.executeQuery();
                                    if (!resultSet3.next()) break block71;
                                    String string16 = resultSet3.getString(1);
                                    mdColumn.setComments(string16);
                                }
                                catch (SQLException sQLException) {
                                    try {
                                        MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.106"), (Throwable)sQLException);
                                    }
                                    catch (Throwable throwable) {
                                        CloseableResultSet.close(preparedStatement3, resultSet3);
                                        throw throwable;
                                    }
                                    CloseableResultSet.close((Statement)preparedStatement3, resultSet3);
                                }
                            }
                            CloseableResultSet.close((Statement)preparedStatement3, (ResultSet)resultSet3);
                            hashtable.put(new Integer(n7), mdColumn);
                            if (n4 > 256) {
                                SQLServer7CapturerColumnsBySelect.registerUserDefinedType(this.getStorer(), string7, mdSchema, sQLServer7CapturerColumnInfo, mdColumn);
                            }
                            ++n3;
                        }
                        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
                        if (this.m_online) {
                            this.m_privilegeWarningWritten = SQLServer7CapturerColumnsBySelect.saveColumns(hashtable, "[" + string + "].[" + mdSchema.getName() + "].[" + (String)var12_17 + "]", this.getRepositoryConnection(), this.getStorer(), mdTable, dBObjectId, captureContext, string, mdSchema.getName(), (String)var12_17, this.m_privilegeWarningWritten);
                            continue;
                        }
                        for (int i = 1; i <= hashtable.size(); ++i) {
                            object2 = (MdColumn)hashtable.get(new Integer(i));
                            object = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), object2.getColumnName());
                            captureContext.getAudience().fireListeners((CaptureEvent)object);
                            object2 = (MdColumn)this.getStorer().storeObject((PersistableObject)object2);
                            object.setEventId(4);
                            captureContext.getAudience().fireListeners((CaptureEvent)object);
                        }
                    }
                    catch (SQLException sQLException) {
                        MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
                        CloseableResultSet.close(preparedStatement, resultSet2);
                    }
                }
                CloseableResultSet.close(preparedStatement, resultSet2);
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.106"), (Throwable)exception);
                break block72;
            }
            finally {
                CloseableResultSet.close(preparedStatement, resultSet2);
                CloseableResultSet.close(preparedStatement2, resultSet);
            }
            CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet);
        }
    }

    protected boolean baseTypeIsNotHandled(String string) {
        if (string == null) {
            return true;
        }
        String string2 = string.toUpperCase();
        boolean bl = true;
        if (string2.equals("BIGINT")) {
            bl = false;
        } else if (string2.equals("DECIMAL")) {
            bl = false;
        } else if (string2.equals("INT")) {
            bl = false;
        } else if (string2.equals("NUMERIC")) {
            bl = false;
        } else if (string2.equals("SMALLINT")) {
            bl = false;
        } else if (string2.equals("MONEY")) {
            bl = false;
        } else if (string2.equals("TINYINT")) {
            bl = false;
        } else if (string2.equals("SMALLMONEY")) {
            bl = false;
        } else if (string2.equals("BIT")) {
            bl = false;
        } else if (string2.equals("FLOAT")) {
            bl = false;
        } else if (string2.equals("REAL")) {
            bl = false;
        } else if (string2.equals("DATETIME")) {
            bl = false;
        } else if (string2.equals("SMALLDATETIME")) {
            bl = false;
        } else if (string2.equals("CHAR")) {
            bl = false;
        } else if (string2.equals("TEXT")) {
            bl = false;
        } else if (string2.equals("VARCHAR")) {
            bl = false;
        } else if (string2.equals("VARCHAR")) {
            bl = false;
        } else if (string2.equals("SYSNAME")) {
            bl = false;
        } else if (string2.equals("NCHAR")) {
            bl = false;
        } else if (string2.equals("NTEXT")) {
            bl = false;
        } else if (string2.equals("NVARCHAR")) {
            bl = false;
        } else if (string2.equals("NVARCHAR")) {
            bl = false;
        } else if (string2.equals("BINARY")) {
            bl = false;
        } else if (string2.equals("IMAGE")) {
            bl = false;
        } else if (string2.equals("VARBINARY")) {
            bl = false;
        } else if (string2.equals("VARBINARY")) {
            bl = false;
        } else if (string2.equals("CURSOR")) {
            bl = false;
        } else if (string2.equals("TIMESTAMP")) {
            bl = false;
        } else if (string2.equals("SQL_VARIANT")) {
            bl = false;
        } else if (string2.equals("UNIQUEIDENTIFIER")) {
            bl = false;
        } else if (string2.equals("TABLE")) {
            bl = false;
        } else if (string2.equals("XML")) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String baseType(int n, String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        String string2;
        block5: {
            string2 = null;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.getRepositoryConnection().prepareStatement(this.getBaseTypeString(string, n));
                if (!this.m_online) {
                    preparedStatement.setString(1, string);
                }
                if (!(resultSet = preparedStatement.executeQuery()).next()) break block5;
                string2 = resultSet.getString(1);
            }
            catch (SQLException sQLException) {
                try {
                    MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)preparedStatement, resultSet);
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        return string2;
    }

    /*
     * Exception decompiling
     */
    private String columnDefault(int var1_1, String var2_2, String var3_3) throws CaptureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureIndex(CaptureContext captureContext) throws SQLException, PersistenceException {
        String string = this.getDatabase((MigrationContext)captureContext);
        String string2 = this.getCaptureIndexString(string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            PreparedStatement preparedStatement = null;
            ResultSet resultSet2 = null;
            try {
                preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
                if (!this.m_online) {
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string4);
                    preparedStatement.setString(3, string3);
                } else {
                    preparedStatement.setString(1, string4);
                    preparedStatement.setString(2, string3);
                }
                resultSet2 = preparedStatement.executeQuery();
                while (resultSet2.next() && !captureContext.shouldCancel()) {
                    int n = resultSet2.getInt(2);
                    String string5 = resultSet2.getString(3);
                    int n2 = resultSet2.getInt(4);
                    int n3 = resultSet2.getInt(6);
                    MdIndexe mdIndexe = new MdIndexe((DBObjectId)captureContext.getContextVariable("TABLEID"));
                    mdIndexe.setIndexName(string5);
                    if (n2 == 1) {
                        mdIndexe.setIndexType("UNIQUE");
                    } else {
                        mdIndexe.setIndexType("NON_UNIQUE");
                    }
                    PreparedStatement preparedStatement2 = null;
                    ResultSet resultSet3 = null;
                    boolean bl = false;
                    try {
                        String string6 = this.getIndexString(string, n3, n);
                        preparedStatement2 = this.getRepositoryConnection().prepareStatement(string6);
                        if (!this.m_online) {
                            preparedStatement2.setString(1, string);
                        }
                        resultSet3 = preparedStatement2.executeQuery();
                        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                        boolean bl2 = true;
                        while (resultSet3.next()) {
                            MdIndexDetail mdIndexDetail;
                            CaptureEvent captureEvent;
                            block17: {
                                DBObjectId dBObjectId = null;
                                try {
                                    dBObjectId = persistenceUtility.getIdForColumn(mdIndexe.getTableId(), resultSet3.getString(2));
                                    if (!bl) {
                                        bl = true;
                                        captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), string5);
                                        captureContext.getAudience().fireListeners(captureEvent);
                                        mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                                        captureEvent.setEventId(4);
                                        captureContext.getAudience().fireListeners(captureEvent);
                                    }
                                    mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), dBObjectId, Integer.valueOf(resultSet3.getInt(1)));
                                    boolean bl3 = resultSet3.getBoolean(3);
                                    if (!bl3) break block17;
                                    mdIndexDetail.addProperty(new AdditionalProperty("IS_INDEXDETAIL_DESCENDING", "Y"), (DBObjectId)captureContext.getContextVariable("CONNECTIONID"));
                                }
                                catch (PersistenceException persistenceException) {
                                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "SQLSERVER.COLUMN_NOT_FOUND", mdIndexe.getIndexName());
                                    continue;
                                }
                            }
                            captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
                            captureContext.getAudience().fireListeners(captureEvent);
                            captureEvent.setEventId(4);
                            captureContext.getAudience().fireListeners(captureEvent);
                            mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                        }
                    }
                    catch (Throwable throwable) {
                        CloseableResultSet.close(preparedStatement2, resultSet3);
                        throw throwable;
                    }
                    CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet3);
                }
            }
            catch (Throwable throwable) {
                CloseableResultSet.close((Statement)preparedStatement, resultSet2);
                throw throwable;
            }
            CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
            return;
        }
        finally {
            CloseableResultSet.close(statement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUniqueAndPrimaryKeys(CaptureContext captureContext) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        string = this.getDatabase((MigrationContext)captureContext);
        boolean bl = true;
        long l = 0L;
        String string2 = this.captureUniqueAndPrimaryKeysString(string);
        try {
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            int n = 1;
            while (resultSet.next() && !captureContext.shouldCancel()) {
                MdConstraintDetail mdConstraintDetail;
                String string5;
                if (bl || resultSet.getLong(3) != l) {
                    bl = false;
                    l = resultSet.getLong(3);
                    string5 = resultSet.getString(8);
                    mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    if (string5.trim().equals("PK")) {
                        string5 = "PK";
                    } else if (string5.trim().equals("UQ")) {
                        string5 = "UNIQUE";
                    }
                    mdConstraint.setConstraintType(string5);
                    mdConstraint.setName(resultSet.getString(1));
                    mdConstraintDetail = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners((CaptureEvent)mdConstraintDetail);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    n = 1;
                    mdConstraintDetail.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)mdConstraintDetail);
                }
                string5 = resultSet.getString(5);
                mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n++));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureForeignKeys(CaptureContext captureContext) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        string = this.getDatabase((MigrationContext)captureContext);
        String string2 = this.captureForeignKeysStringString(string);
        preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
        String string3 = (String)captureContext.getContextVariable("SCHEMA");
        String string4 = (String)captureContext.getContextVariable("TABLE");
        if (!this.m_online) {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string3);
            preparedStatement.setString(3, string4);
        } else {
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string4);
        }
        resultSet = preparedStatement.executeQuery();
        MdConstraint mdConstraint = null;
        boolean bl = true;
        boolean bl2 = false;
        int n = -1;
        try {
            int n2 = 1;
            while (resultSet.next() && !captureContext.shouldCancel()) {
                DBObjectId dBObjectId;
                DBObjectId dBObjectId2;
                String string5;
                String string6;
                String string7;
                String string8;
                int n3 = resultSet.getInt(2);
                if (bl || n3 != n) {
                    bl2 = true;
                    bl = false;
                    n = n3;
                    mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    mdConstraint.setConstraintType("FOREIGN KEY");
                    mdConstraint.setName(resultSet.getString(1));
                    string8 = resultSet.getString(4);
                    string7 = resultSet.getString(5);
                    string6 = resultSet.getString(6);
                    string5 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string8);
                    if (string5 == null) continue;
                    try {
                        dBObjectId2 = persistenceUtility.getIdForTable((DBObjectId)string5, string7);
                        if (dBObjectId2 == null) {
                            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Capture.CONSTRAINTSKIPPED", new String[]{mdConstraint.getName(), string7});
                        }
                    }
                    catch (PersistenceException persistenceException) {}
                    continue;
                    mdConstraint.setReftableId(dBObjectId2);
                    dBObjectId = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    n2 = 1;
                    dBObjectId.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
                }
                string8 = resultSet.getString(4);
                string7 = resultSet.getString(5);
                string6 = resultSet.getString(6);
                string5 = resultSet.getString(3);
                dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string8);
                if (dBObjectId2 == null) continue;
                try {
                    dBObjectId = persistenceUtility.getIdForTable(dBObjectId2, string7);
                }
                catch (PersistenceException persistenceException) {
                    continue;
                }
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n2));
                try {
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                }
                catch (PersistenceException persistenceException) {
                    MigrationLogUtil.logThrowable((String)persistenceException.getLocalizedMessage(), (String)"Capture", (Throwable)persistenceException);
                    continue;
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n2++));
                try {
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(dBObjectId, string6));
                }
                catch (PersistenceException persistenceException) {
                    MigrationLogUtil.logThrowable((String)persistenceException.getLocalizedMessage(), (String)"Capture", (Throwable)persistenceException);
                    continue;
                }
                mdConstraintDetail.setRefFlag("Y");
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTableLevelCheckConstraint(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureTableLevelCheckConstraintString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            while (resultSet.next() && !captureContext.shouldCancel()) {
                Object object;
                String string5 = "CHECK";
                mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                mdConstraint.setConstraintType(string5);
                mdConstraint.setName(resultSet.getString(1));
                Reader reader = null;
                if (!this.m_online) {
                    object = resultSet.getClob(2);
                    if (object != null) {
                        reader = object.getCharacterStream();
                    }
                } else {
                    reader = resultSet.getCharacterStream(2);
                }
                object = new StringBuffer();
                String string6 = null;
                char[] cArray = new char[s_chunkSize];
                int n = 0;
                if (reader != null) {
                    try {
                        while ((n = reader.read(cArray)) != -1) {
                            ((StringBuffer)object).append(new String(cArray, 0, n));
                        }
                        string6 = ((StringBuffer)object).toString();
                    }
                    catch (IOException iOException) {
                        throw new CaptureException((Throwable)iOException);
                    }
                }
                mdConstraint.setConstraintText(string6);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureColumnLevelCheckConstraint(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureColumnLevelCheckConstraintString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            while (resultSet.next()) {
                Object object;
                String string5 = "CHECK";
                mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                mdConstraint.setConstraintType(string5);
                mdConstraint.setName(resultSet.getString(1));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(1));
                Reader reader = null;
                if (!this.m_online) {
                    object = resultSet.getClob(4);
                    if (object != null) {
                        reader = object.getCharacterStream();
                    }
                } else {
                    reader = resultSet.getCharacterStream(4);
                }
                object = new StringBuffer();
                String string6 = null;
                char[] cArray = new char[s_chunkSize];
                int n = 0;
                if (reader != null) {
                    try {
                        while ((n = reader.read(cArray)) != -1) {
                            ((StringBuffer)object).append(new String(cArray, 0, n));
                        }
                        string6 = ((StringBuffer)object).toString();
                    }
                    catch (IOException iOException) {
                        throw new CaptureException((Throwable)iOException);
                    }
                }
                mdConstraintDetail.setConstraintText(string6);
                String string7 = resultSet.getString(6);
                CloseableIterator closeableIterator = persistenceUtility.getColumnsForTableId((DBObjectId)captureContext.getContextVariable("TABLEID"));
                DBObjectId dBObjectId = null;
                while (closeableIterator.hasNext()) {
                    MdColumn mdColumn = (MdColumn)closeableIterator.next();
                    if (!mdColumn.getColumnName().equals(string7)) continue;
                    dBObjectId = mdColumn.getKey();
                }
                mdConstraintDetail.setColumnId(dBObjectId);
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void captureRules(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = this.captureRulesString(string);
            preparedStatement = this.getRepositoryConnection().prepareStatement(string2);
            String string3 = (String)captureContext.getContextVariable("TABLE");
            String string4 = (String)captureContext.getContextVariable("SCHEMA");
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            if (!this.m_online) {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string3);
                preparedStatement.setString(3, string4);
            } else {
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
            }
            resultSet = preparedStatement.executeQuery();
            MdConstraint mdConstraint = null;
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string5 = resultSet.getString(2);
                int n = resultSet.getInt(4);
                String string6 = "CHECK";
                if (n == 0) continue;
                String string7 = "rul_" + string3 + "_" + string5;
                PreparedStatement preparedStatement2 = null;
                ResultSet resultSet2 = null;
                String string8 = "";
                String string9 = this.captureRulesTextString(string);
                try {
                    Object object;
                    String string10;
                    StringBuffer stringBuffer;
                    Clob clob;
                    Reader reader;
                    preparedStatement2 = this.getRepositoryConnection().prepareStatement(string9);
                    if (!this.m_online) {
                        preparedStatement2.setString(1, string);
                        preparedStatement2.setInt(2, n);
                    } else {
                        preparedStatement2.setInt(1, n);
                    }
                    resultSet2 = preparedStatement2.executeQuery();
                    while (resultSet2.next()) {
                        reader = null;
                        clob = resultSet2.getClob(1);
                        if (clob != null) {
                            reader = clob.getCharacterStream();
                        }
                        stringBuffer = new StringBuffer();
                        string10 = null;
                        object = new char[s_chunkSize];
                        int n2 = 0;
                        if (reader != null) {
                            try {
                                while ((n2 = reader.read((char[])object)) != -1) {
                                    stringBuffer.append(new String((char[])object, 0, n2));
                                }
                                string10 = stringBuffer.toString();
                            }
                            catch (IOException iOException) {
                                throw new CaptureException((Throwable)iOException);
                            }
                        }
                        string8 = string10;
                    }
                    mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
                    mdConstraint.setConstraintType(string6);
                    mdConstraint.setName(string7);
                    mdConstraint.addProperty("TYPE", "RULE", dBObjectId);
                    reader = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners((CaptureEvent)reader);
                    mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                    reader.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)reader);
                    clob = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(1));
                    stringBuffer = persistenceUtility.getColumnsForTableId((DBObjectId)captureContext.getContextVariable("TABLEID"));
                    string10 = null;
                    while (stringBuffer.hasNext()) {
                        object = (MdColumn)stringBuffer.next();
                        if (!object.getColumnName().equals(string5)) continue;
                        string10 = object.getKey();
                    }
                    clob.setColumnId((DBObjectId)string10);
                    clob.setConstraintText(string8);
                    reader = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                    captureContext.getAudience().fireListeners((CaptureEvent)reader);
                    clob = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)clob);
                    reader.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)reader);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)preparedStatement2, resultSet2);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureView(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        String string = null;
        PrepareClobHelper prepareClobHelper = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = "";
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_VIEWS")) {
                throw new IllegalArgumentException(SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.92") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string2 = " AND a.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String n : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(n);
                }
            }
            String string3 = this.captureViewOuterString(string) + string2;
            String string4 = this.captureViewInnerString(string) + string2;
            preparedStatement2 = this.getRepositoryConnection().prepareStatement(string3);
            String string5 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, string5);
            } else {
                preparedStatement2.setString(1, string5);
            }
            resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next() && !captureContext.shouldCancel()) {
                Object sQLException;
                Object object;
                Object object2;
                Reader exception;
                int n = resultSet2.getInt(1);
                String string6 = resultSet2.getString(2);
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string6)) continue;
                preparedStatement = this.getRepositoryConnection().prepareStatement(string4);
                if (!this.m_online) {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                } else {
                    preparedStatement.setInt(1, n);
                }
                resultSet = preparedStatement.executeQuery();
                MdView mdView = null;
                string6 = null;
                prepareClobHelper = new PrepareClobHelper();
                while (resultSet.next()) {
                    string6 = resultSet.getString(1);
                    try {
                        exception = null;
                        if (!this.m_online) {
                            object2 = resultSet.getClob(3);
                            if (object2 != null) {
                                exception = object2.getCharacterStream();
                            }
                        } else {
                            exception = resultSet.getCharacterStream(3);
                        }
                        object2 = new StringBuffer();
                        object = null;
                        sQLException = new char[s_chunkSize];
                        int string7 = 0;
                        if (exception != null) {
                            while ((string7 = exception.read((char[])sQLException)) != -1) {
                                ((StringBuffer)object2).append(new String((char[])sQLException, 0, string7));
                            }
                            object = ((StringBuffer)object2).toString();
                        }
                        prepareClobHelper.append(object);
                    }
                    catch (Exception exception2) {
                        prepareClobHelper.append("");
                    }
                }
                if (string6 != null) {
                    mdView = new MdView((DBObjectId)captureContext.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                    mdView.setViewName(string6);
                    exception = prepareClobHelper.getClobHelper();
                    if (exception == null || exception.getLength() == 0L) {
                        prepareClobHelper = new PrepareClobHelper();
                        prepareClobHelper.append("/* ddl not accessible */");
                        exception = prepareClobHelper.getClobHelper();
                    }
                    mdView.setNativeSql((ClobHelper)exception);
                    object2 = null;
                    object = null;
                    try {
                        sQLException = this.captureCommentsString();
                        object2 = this.getRepositoryConnection().prepareStatement((String)sQLException);
                        object2.setInt(1, n);
                        object2.setInt(2, 0);
                        object = object2.executeQuery();
                        if (object.next()) {
                            String string7 = object.getString(1);
                            mdView.setComments(string7);
                        }
                    }
                    catch (SQLException sQLException2) {
                        MigrationLogUtil.logThrowable((String)sQLException2.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.95"), (Throwable)sQLException2);
                    }
                    finally {
                        CloseableResultSet.close((Statement)object2, (ResultSet)object);
                    }
                    sQLException = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), string6);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                    mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                    sQLException.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                }
                if (prepareClobHelper != null) {
                    prepareClobHelper.close();
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
            }
            CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        }
        catch (IOException iOException) {
            try {
                throw new CaptureException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                CloseableResultSet.close(preparedStatement2, resultSet2);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (Exception exception) {
                        MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.95"), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(preparedStatement, resultSet);
        CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.95"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureStoredProgram(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException, CaptureException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        String string = null;
        PrepareClobHelper prepareClobHelper = null;
        try {
            string = this.getDatabase((MigrationContext)captureContext);
            String string2 = "";
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_STORED_PROGRAMS")) {
                throw new IllegalArgumentException(SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.97") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string2 = " AND a.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String n : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(n);
                }
            }
            String string3 = this.captureStoredProgramOuterString(string) + string2;
            String string4 = this.captureStoredProgramInnerString(string, string2);
            preparedStatement2 = this.getRepositoryConnection().prepareStatement(string3);
            String string5 = (String)captureContext.getContextVariable("SCHEMA");
            if (!this.m_online) {
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, string5);
            } else {
                preparedStatement2.setString(1, string5);
            }
            resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next() && !captureContext.shouldCancel()) {
                Object object;
                Object object2;
                Object exception;
                Object object3;
                int n = resultSet2.getInt(1);
                String string6 = resultSet2.getString(2);
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string6)) continue;
                preparedStatement = this.getRepositoryConnection().prepareStatement(string4);
                if (!this.m_online) {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                } else {
                    preparedStatement.setInt(1, n);
                }
                resultSet = preparedStatement.executeQuery();
                MdStoredProgram mdStoredProgram = null;
                String string7 = "";
                String string8 = "";
                prepareClobHelper = new PrepareClobHelper();
                while (resultSet.next()) {
                    if (mdStoredProgram == null) {
                        string7 = resultSet.getString(1);
                        string8 = resultSet.getString(5);
                        mdStoredProgram = new MdStoredProgram((DBObjectId)captureContext.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                    }
                    object3 = null;
                    try {
                        exception = null;
                        if (!this.m_online) {
                            object2 = resultSet.getClob(4);
                            if (object2 != null) {
                                exception = object2.getCharacterStream();
                            }
                        } else {
                            exception = resultSet.getCharacterStream(4);
                        }
                        object2 = new StringBuffer();
                        object = new char[s_chunkSize];
                        int resultSet3 = 0;
                        if (exception != null) {
                            while ((resultSet3 = ((Reader)exception).read((char[])object)) != -1) {
                                ((StringBuffer)object2).append(new String((char[])object, 0, resultSet3));
                            }
                            object3 = ((StringBuffer)object2).toString();
                        }
                    }
                    catch (Exception exception2) {
                        object3 = "";
                    }
                    if (object3 == null) continue;
                    prepareClobHelper.append((String)object3);
                }
                if (mdStoredProgram != null) {
                    String sQLException;
                    mdStoredProgram.setName(string7);
                    object3 = prepareClobHelper.getClobHelper();
                    if (object3 == null || object3.getLength() == 0L) {
                        prepareClobHelper = new PrepareClobHelper();
                        prepareClobHelper.append("/* ddl not accessible */");
                        object3 = prepareClobHelper.getClobHelper();
                    }
                    mdStoredProgram.setNativeSql(object3);
                    exception = string8;
                    if (string8.trim().equals("P")) {
                        exception = "PROCEDURE";
                        string8 = "PROCEDURE";
                    } else if (string8.equals("FN")) {
                        exception = "SCALAR FUNCTION";
                        string8 = "FUNCTION";
                    } else if (string8.equals("TF")) {
                        exception = "TABLE FUNCTION";
                        string8 = "FUNCTION";
                    } else if (string8.equals("IF")) {
                        exception = "INLINED T. FUNCTION";
                        string8 = "FUNCTION";
                    } else {
                        string8 = "PROCEDURE";
                    }
                    object2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                    mdStoredProgram.addProperty("TYPE", (String)exception, (DBObjectId)object2);
                    mdStoredProgram.setProgramtype(string8);
                    object = null;
                    ResultSet resultSet3 = null;
                    try {
                        sQLException = this.captureCommentsString();
                        object = this.getRepositoryConnection().prepareStatement(sQLException);
                        object.setInt(1, n);
                        object.setInt(2, 0);
                        resultSet3 = object.executeQuery();
                        if (resultSet3.next()) {
                            String string9 = resultSet3.getString(1);
                            mdStoredProgram.setComments(string9);
                        }
                        CloseableResultSet.close((Statement)object, (ResultSet)resultSet3);
                    }
                    catch (SQLException sQLException2) {
                        MigrationLogUtil.logThrowable((String)sQLException2.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.106"), (Throwable)sQLException2);
                    }
                    finally {
                        CloseableResultSet.close((Statement)object, resultSet3);
                    }
                    sQLException = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), string7);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                    mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                    sQLException.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)sQLException);
                }
                if (prepareClobHelper != null) {
                    prepareClobHelper.close();
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
            }
            CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        }
        catch (IOException iOException) {
            try {
                throw new CaptureException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                CloseableResultSet.close(preparedStatement2, resultSet2);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (Exception exception) {
                        MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.106"), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close(preparedStatement, resultSet);
        CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.106"), (Throwable)exception);
            }
        }
    }

    protected void captureTriggers(CaptureContext captureContext) throws SQLException, PersistenceException, CaptureException {
        PrepareClobHelper prepareClobHelper;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block27: {
            DBObjectId dBObjectId;
            String string;
            preparedStatement = null;
            resultSet = null;
            String string2 = null;
            prepareClobHelper = null;
            String string3 = (String)captureContext.getContextVariable("PER_CONTEXT");
            String string4 = null;
            if (string3.equals("MD_TABLES")) {
                string = "T";
                dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                string4 = (String)captureContext.getContextVariable("TABLE");
            } else {
                string = "V";
                dBObjectId = (DBObjectId)captureContext.getContextVariable("VIEWID");
                string4 = (String)captureContext.getContextVariable("VIEW");
            }
            try {
                Reader reader;
                Object object;
                string2 = this.getDatabase((MigrationContext)captureContext);
                String string5 = this.captureTriggersString(string2);
                preparedStatement = this.getRepositoryConnection().prepareStatement(string5);
                String string6 = (String)captureContext.getContextVariable("SCHEMA");
                if (!this.m_online) {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string6);
                    preparedStatement.setString(3, string4);
                } else {
                    preparedStatement.setString(1, string6);
                    preparedStatement.setString(2, string4);
                }
                resultSet = preparedStatement.executeQuery();
                MdTrigger mdTrigger = null;
                boolean bl = true;
                String string7 = "";
                while (resultSet.next() && !captureContext.shouldCancel()) {
                    if (bl || !string7.equals(resultSet.getString(1))) {
                        if (!bl) {
                            mdTrigger.setTriggerName(string7);
                            object = prepareClobHelper.getClobHelper();
                            if (object == null || object.getLength() == 0L) {
                                prepareClobHelper = new PrepareClobHelper();
                                prepareClobHelper.append("/* ddl not accessible */");
                                object = prepareClobHelper.getClobHelper();
                            }
                            mdTrigger.setNativeSql(object);
                            reader = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string7);
                            captureContext.getAudience().fireListeners((CaptureEvent)reader);
                            mdTrigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)mdTrigger);
                            reader.setEventId(4);
                            captureContext.getAudience().fireListeners((CaptureEvent)reader);
                        }
                        if (prepareClobHelper != null) {
                            prepareClobHelper.close();
                        }
                        prepareClobHelper = new PrepareClobHelper();
                        string7 = resultSet.getString(1);
                        bl = false;
                        mdTrigger = new MdTrigger(dBObjectId, string, MY_LANGUAGE_ID);
                    }
                    object = null;
                    try {
                        Object object2;
                        reader = null;
                        if (!this.m_online) {
                            object2 = resultSet.getClob(4);
                            if (object2 != null) {
                                reader = object2.getCharacterStream();
                            }
                        } else {
                            reader = resultSet.getCharacterStream(4);
                        }
                        object2 = new StringBuffer();
                        char[] cArray = new char[s_chunkSize];
                        int n = 0;
                        if (reader != null) {
                            while ((n = reader.read(cArray)) != -1) {
                                ((StringBuffer)object2).append(new String(cArray, 0, n));
                            }
                            object = ((StringBuffer)object2).toString();
                        }
                    }
                    catch (Exception exception) {
                        object = "";
                    }
                    if (object == null) continue;
                    prepareClobHelper.append((String)object);
                }
                if (mdTrigger == null) break block27;
                mdTrigger.setTriggerName(string7);
                object = prepareClobHelper.getClobHelper();
                if (object == null || object.getLength() == 0L) {
                    prepareClobHelper = new PrepareClobHelper();
                    prepareClobHelper.append("/* ddl not accessible */");
                    object = prepareClobHelper.getClobHelper();
                }
                mdTrigger.setNativeSql(object);
                reader = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string7);
                captureContext.getAudience().fireListeners((CaptureEvent)reader);
                mdTrigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)mdTrigger);
                reader.setEventId(4);
                captureContext.getAudience().fireListeners((CaptureEvent)reader);
            }
            catch (IOException iOException) {
                try {
                    throw new CaptureException((Throwable)iOException);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet);
                    if (prepareClobHelper != null) {
                        try {
                            prepareClobHelper.close();
                        }
                        catch (Exception exception) {
                            MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.109"), (Throwable)exception);
                        }
                    }
                    throw throwable;
                }
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.109"), (Throwable)exception);
            }
        }
    }

    protected void captureRoles(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException, CaptureException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PrepareClobHelper prepareClobHelper = null;
        ArrayList<MdGroup> arrayList = new ArrayList<MdGroup>();
        try {
            String string4;
            String string2 = this.getDatabase((MigrationContext)captureContext);
            String string3 = this.captureRolesString(string2);
            HashSet<String> hashSet = null;
            if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals("MD_GROUPS")) {
                throw new IllegalArgumentException(SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.110") + migrationObjectFilter.getObjectType());
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
                string3 = string3 + " where b.name " + migrationObjectFilter.getWhereClause();
            }
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
                hashSet = new HashSet<String>();
                for (String string4 : migrationObjectFilter.getObjectNames()) {
                    hashSet.add(string4);
                }
            }
            preparedStatement = this.getRepositoryConnection().prepareStatement(string3);
            if (!this.m_online) {
                preparedStatement.setString(1, this.getDatabase((MigrationContext)captureContext));
            }
            resultSet = preparedStatement.executeQuery();
            MdGroup mdGroup = null;
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string5;
                String string6;
                block22: {
                    string6 = resultSet.getString(1);
                    if (hashSet != null && hashSet.contains(string6)) continue;
                    string5 = resultSet.getString(2);
                    if (resultSet.wasNull()) {
                        string5 = "dbo";
                    }
                    prepareClobHelper = new PrepareClobHelper();
                    try {
                        string4 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string5);
                        if (string4 != null) break block22;
                        string5 = "dbo";
                        string4 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string5);
                        if (string4 == null) {
                        }
                    }
                    catch (PersistenceException persistenceException) {}
                    continue;
                }
                prepareClobHelper.append("sp_addrole " + string6 + ", " + string5);
                mdGroup = new MdGroup((DBObjectId)string4);
                mdGroup.setGroupFlag("R");
                mdGroup.setGroupName(string6);
                mdGroup.setNativeSql(prepareClobHelper.getClobHelper());
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_GROUP"), string6);
                captureContext.getAudience().fireListeners(captureEvent);
                mdGroup = (MdGroup)this.getStorer().storeObject((PersistableObject)mdGroup);
                captureEvent.setEventId(4);
                this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList, mdGroup, null);
                arrayList.add(mdGroup);
                captureContext.getAudience().fireListeners(captureEvent);
                prepareClobHelper.close();
            }
            this.captureRoleMembership(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList);
            CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId((DBObjectId)captureContext.getContextVariable("CATALOGID"));
            while (closeableIterator.hasNext()) {
                CloseableIterator closeableIterator2 = persistenceUtility.getUsersforSchemaId(((MdSchema)closeableIterator.next()).getKey());
                while (closeableIterator2.hasNext()) {
                    string4 = (MdUser)closeableIterator2.next();
                    this.capturePrivileges(this.getRepositoryConnection(), this.getStorer(), captureContext, arrayList, null, (MdUser)string4);
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw new CaptureException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(preparedStatement, resultSet);
                if (prepareClobHelper != null) {
                    try {
                        prepareClobHelper.close();
                    }
                    catch (Exception exception) {
                        MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.116"), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        if (prepareClobHelper != null) {
            try {
                prepareClobHelper.close();
            }
            catch (Exception exception) {
                MigrationLogUtil.logThrowable((String)exception.getLocalizedMessage(), (String)SQLServer2005Messages.getString("SQLServer2005AbstractCapturer.116"), (Throwable)exception);
            }
        }
    }

    protected Integer[] getPrecisionScaleIdentity(String string, Integer n, Integer n2) {
        return SQLServer7CapturerColumnsBySelect.getPrecisionScaleIdentity(string, n, n2);
    }

    protected String getDatabase(MigrationContext migrationContext) throws SQLException {
        String string = null;
        MdCatalog mdCatalog = (MdCatalog)migrationContext.getContextVariable("CATALOG");
        string = mdCatalog.getCatalogName();
        return string;
    }

    public boolean isPrivilegeWarningWritten() {
        return this.m_privilegeWarningWritten;
    }

    public void setPrivilegeWarningWritten(boolean bl) {
        this.m_privilegeWarningWritten = bl;
    }

    public String getModelName() throws CaptureException {
        return null;
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sqlserver7";
    }

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection connection) {
        this.m_repositoryConnection = connection;
    }

    static {
        s_chunkSize = 4096;
    }
}

