/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.SQLServer7Plugin;
import oracle.dbtools.migration.workbench.sqlserver2000.SQLServer2000DbProvider;
import oracle.dbtools.migration.workbench.sqlserver2000.SQLServer2000OfflineCapturer;

public class SQLServer2000Plugin
extends SQLServer7Plugin {
    @Override
    public String getVersionNumber() {
        return "8.0.0";
    }

    @Override
    public String getPublishedVersion() {
        return "2000";
    }

    @Override
    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            SQLServer2000Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new SQLServer2000DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    @Override
    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        SQLServer2000Plugin.loadDriver();
        try {
            SQLServer2000Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new SQLServer2000DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    @Override
    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new SQLServer2000DbProvider(connection);
    }

    @Override
    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            SQLServer2000Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return new SQLServer2000DbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName("net.sourceforge.jtds.jdbc.Driver").newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    @Override
    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    @Override
    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.equals(this.getPlatformName()) && n == 8) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    @Override
    public int getPlatformMask() {
        return 32;
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return new SQLServer2000OfflineCapturer(null, null);
    }
}

