/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.extension.OnDemandElementVisitor;
import javax.ide.extension.OnDemandElementVisitorListener;
import javax.ide.menu.spi.ActionsVisitor;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.MenusVisitor;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.ToolbarVisitorListener;
import javax.ide.menu.spi.ToolbarsVisitor;
import javax.ide.util.MetaClass;

public final class MenuHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menu-hook");
    private static final ElementName ACTIONS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "actions");
    private static final ElementName MENUS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menus");
    private static final ElementName TOOLBARS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "toolbars");
    private static final ElementName ITEM_FACTORIES = new ElementName("http://jcp.org/jsr/198/extension-manifest", "item-factories");
    private static final ElementName ITEM_FACTORY_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "item-factory-class");
    static final String KEY_MENU_MODEL = "menuModel";
    static final String KEY_SECTION_CONTAINER = "sectionContainer";
    private ElementVisitor _actionsVisitor = new ActionsVisitor();
    private ElementVisitor _toolbarsVisitor = new ToolbarsVisitor();
    private ElementVisitor _menusVisitor = new MenusVisitor();
    private ElementVisitor _itemFactoriesVisitor = new ItemFactoriesVisitor();
    private final MenuModel _menuModel = this.createInitialMenuModel();

    @Override
    public void start(ElementStartContext context) {
        context.getScopeData().put(KEY_MENU_MODEL, this._menuModel);
        context.registerChildVisitor(TOOLBARS, this._toolbarsVisitor);
        context.registerChildVisitor(ACTIONS, this._actionsVisitor);
        context.registerChildVisitor(MENUS, this._menusVisitor);
        context.registerChildVisitor(ITEM_FACTORIES, this._itemFactoriesVisitor);
    }

    public MenuModel getModel() {
        return this._menuModel;
    }

    public void addMenuRegListener(OnDemandElementVisitorListener listener) {
        ((MenusVisitor)this._menusVisitor).addRegListener(listener);
    }

    public void removeMenuRegListener(OnDemandElementVisitorListener listener) {
        ((MenusVisitor)this._menusVisitor).removeRegListener(listener);
    }

    public void addToolbarRegListener(ToolbarVisitorListener listener) {
        ((ToolbarsVisitor)this._toolbarsVisitor).addToolbarVistorListener(listener);
    }

    public void removeToolbarRegListener(ToolbarVisitorListener listener) {
        ((ToolbarsVisitor)this._toolbarsVisitor).addToolbarVistorListener(listener);
    }

    protected MenuModel createInitialMenuModel() {
        MenuModel model = new MenuModel();
        MenuBar mbMain = model.findOrCreatePullDownMenu("javax.ide.view.MAIN_WINDOW_MENUBAR_ID");
        Menu menu = new Menu("javax.ide.FILE_MENU_ID");
        Section section = new Section("javax.ide.NEW_SECTION_ID");
        menu.addSection(section);
        section = new Section("javax.ide.OPEN_SECTION_ID");
        Item item = new Item("javax.ide.OPEN_ACTION_ID");
        section.addItem(item);
        menu.addSection(section);
        section = new Section("javax.ide.CLOSE_SECTION_ID");
        menu.addSection(section);
        section = new Section("javax.ide.PRINT_SECTION_ID");
        menu.addSection(section);
        mbMain.addMenu(menu);
        menu = new Menu("javax.ide.EDIT_MENU_ID");
        section = new Section("javax.ide.COPY_PASTE_SECTION_ID");
        section.addItem(new Item("javax.ide.CUT_ACTION_ID"));
        section.addItem(new Item("javax.ide.COPY_ACTION_ID"));
        section.addItem(new Item("javax.ide.PASTE_ACTION_ID"));
        menu.addSection(section);
        mbMain.addMenu(menu);
        menu = new Menu("javax.ide.VIEW_MENU_ID");
        mbMain.addMenu(menu);
        menu = new Menu("javax.ide.HELP_MENU_ID");
        mbMain.addMenu(menu);
        return model;
    }

    private class ItemFactoryClassVisitor
    extends MetaClassVisitor {
        private ItemFactoryClassVisitor() {
        }

        @Override
        protected void metaClass(ElementContext context, MetaClass mc) {
            MenuHook.this.getModel().addItemFactory(mc);
        }
    }

    private class ItemFactoriesVisitor
    extends OnDemandElementVisitor {
        private final ElementVisitor _itemFactoryClassVisitor;

        private ItemFactoriesVisitor() {
            this._itemFactoryClassVisitor = new ItemFactoryClassVisitor();
        }

        @Override
        public void startImpl(ElementStartContext context) {
            context.registerChildVisitor(ITEM_FACTORY_CLASS, this._itemFactoryClassVisitor);
        }
    }
}

