/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.MacroExpander;
import javax.ide.util.MetaResourceString;

public abstract class ExtensionVisitor
extends BaseExtensionVisitor {
    private static final ElementName CLASSPATHS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "classpaths");
    private ElementVisitor _nameVisitor = this.createNameVisitor();
    private ElementVisitor _ownerVisitor = this.createOwnerVisitor();
    private ElementVisitor _classpathsVisitor = this.createClasspathsVisitor();
    private ElementVisitor _dependenciesVisitor = this.createDependenciesVisitor();
    public static final String KEY_CLASSLOADER = "classLoader";
    private static final String KEY_LAST_RSKEY = "lastRSKey";
    private Map<String, Extension> _extensionsById = new LinkedHashMap<String, Extension>();

    protected ExtensionVisitor(ElementVisitorFactory hookFactory) {
        this.setHookVisitorFactory(hookFactory);
    }

    public final Extension findExtension(String id) {
        return this._extensionsById.get(id);
    }

    public final Collection<Extension> getExtensions() {
        return this._extensionsById.values();
    }

    @Override
    public final void start(ElementStartContext context) {
        DefaultExtension ext = this.processExtension(context);
        if (ext == null) {
            return;
        }
        this._extensionsById.put(ext.getID(), ext);
        context.getScopeData().put(KEY_CLASSLOADER, this.getClassLoader(ext));
        String rsbundleClass = this.getAttributeHelper(context, "rsbundle-class", true, false);
        if (rsbundleClass != null) {
            context.getScopeData().put("rsbundleclass", rsbundleClass);
        }
        context.registerChildVisitor(NAME_ELEMENT, this._nameVisitor);
        context.registerChildVisitor(OWNER_ELEMENT, this._ownerVisitor);
        if (this._classpathsVisitor != null) {
            context.registerChildVisitor(CLASSPATHS, this._classpathsVisitor);
        }
        if (this._dependenciesVisitor != null) {
            context.registerChildVisitor(DependenciesVisitor.ELEMENT, this._dependenciesVisitor);
        }
    }

    protected ElementVisitor createClasspathsVisitor() {
        return new BaseExtensionVisitor.ClasspathsVisitor();
    }

    protected ElementVisitor createDependenciesVisitor() {
        return new DependenciesVisitor();
    }

    protected ElementVisitor createNameVisitor() {
        return new ElementVisitor(){

            @Override
            public void start(ElementStartContext context) {
                String rsKey = context.getAttributeValue("rskey");
                if (rsKey == "") {
                    rsKey = null;
                }
                context.getScopeData().put(ExtensionVisitor.KEY_LAST_RSKEY, rsKey);
            }

            @Override
            public void end(ElementEndContext context) {
                DefaultExtension extension = BaseExtensionVisitor.getExtension(context);
                String rsKey = (String)context.getScopeData().get(ExtensionVisitor.KEY_LAST_RSKEY);
                if (rsKey != null) {
                    extension.setRawName("${" + rsKey + "}");
                } else {
                    DefaultElementContext dec = (DefaultElementContext)context;
                    extension.setRawName(dec.getRawText());
                }
                String rawName = extension.getRawName();
                if (MacroExpander.containsMacro(rawName)) {
                    extension.setName(new MetaResourceString(1.getResourceBundle(context), MacroExpander.stripOffBrackets(rawName)));
                } else {
                    extension.setName(rawName);
                }
            }
        };
    }

    protected ElementVisitor createOwnerVisitor() {
        return new ElementVisitor(){

            @Override
            public void start(ElementStartContext context) {
                String rsKey = context.getAttributeValue("rskey");
                if (rsKey == "") {
                    rsKey = null;
                }
                context.getScopeData().put(ExtensionVisitor.KEY_LAST_RSKEY, rsKey);
            }

            @Override
            public void end(ElementEndContext context) {
                DefaultExtension extension = BaseExtensionVisitor.getExtension(context);
                String rsKey = (String)context.getScopeData().get(ExtensionVisitor.KEY_LAST_RSKEY);
                if (rsKey != null) {
                    extension.setRawOwner("${" + rsKey + "}");
                } else {
                    DefaultElementContext dec = (DefaultElementContext)context;
                    extension.setRawOwner(dec.getRawText());
                }
                String rawOwner = extension.getRawOwner();
                if (MacroExpander.containsMacro(rawOwner)) {
                    extension.setOwner(new MetaResourceString(2.getResourceBundle(context), MacroExpander.stripOffBrackets(rawOwner)));
                } else {
                    extension.setOwner(rawOwner);
                }
            }
        };
    }

    protected ClassLoader getClassLoader(Extension extension) {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    protected void addExtensionSourceToClasspath(ElementContext context) {
    }
}

