/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.ArrayList;
import java.util.Collection;

public final class PlatformInfo {
    public static final String SWING = "swing";
    public static final String SWT = "swt";
    private final Collection _toolkits;

    public PlatformInfo(Collection toolkits) {
        if (toolkits == null) {
            throw new NullPointerException("Null toolkits");
        }
        if (toolkits.isEmpty()) {
            throw new IllegalArgumentException("Empty toolkits");
        }
        this._toolkits = new ArrayList(toolkits);
    }

    public String getPreferredToolkit() {
        return (String)this._toolkits.iterator().next();
    }

    public boolean isToolkitSupported(String toolkit) {
        return this._toolkits.contains(toolkit);
    }
}

