/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.ParameterizedExtensionHook;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DeferredElementVisitorHelper;

public class MultiDeferredElementVisitorHook
extends ParameterizedExtensionHook {
    private static final String _MAX_VISITOR_HOOK_HANDLER_PARAM = "max-visitors";
    private final DeferredElementVisitorHelper _helper = new DeferredElementVisitorHelper();
    private List<ElementVisitor> _attachedElementVisitorList = new CopyOnWriteArrayList<ElementVisitor>();
    private Object _attachmentLock = new Object();
    private volatile int _maxVisitors = 1;

    @Override
    public void setHookHandlerParameters(Map<String, String> parameterMap) {
        String maxVisitorsParam = parameterMap.get(_MAX_VISITOR_HOOK_HANDLER_PARAM);
        if (maxVisitorsParam != null) {
            try {
                int intValue = Integer.parseInt(maxVisitorsParam);
                if (intValue > 1) {
                    this.setMaximumNumberOfVisitors(intValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumNumberOfVisitors(int maxVisitors) {
        Object object = this._attachmentLock;
        synchronized (object) {
            if (maxVisitors == this._maxVisitors) {
                return;
            }
            if (this._maxVisitors > maxVisitors) {
                throw new IllegalArgumentException("Illegal argument: maxVisitors is already set to " + this._maxVisitors + " it cannot be set lower to " + maxVisitors);
            }
            if (this._attachedElementVisitorList.size() == this._maxVisitors) {
                throw new IllegalStateException("Illegal attempt to setMaximumNumberOfVisitors after maximum has already been reached");
            }
            this._maxVisitors = maxVisitors;
        }
    }

    public int getMaximumNumberOfVisitors() {
        return this._maxVisitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ElementStartContext context) {
        Object object = this._attachmentLock;
        synchronized (object) {
            this._helper.recordTopLevelElementStart(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(ElementEndContext context) {
        Object object = this._attachmentLock;
        synchronized (object) {
            this._helper.recordTopLevelElementEnd(context);
            for (ElementVisitor visitor : this._attachedElementVisitorList) {
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                DefaultElementContext freshContext = (DefaultElementContext)extensionRegistry.createInitialContext();
                this._helper.visitNewlyRecordedData(freshContext, visitor);
            }
            if (this._attachedElementVisitorList.size() == this._maxVisitors) {
                this._helper.clearRecordedData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachElementVisitor(ElementVisitor elementVisitor) {
        if (elementVisitor == null) {
            throw new IllegalArgumentException("attachElementVisitor passed a null element visitor");
        }
        Object object = this._attachmentLock;
        synchronized (object) {
            if (this._attachedElementVisitorList.contains(elementVisitor)) {
                return;
            }
            if (this._attachedElementVisitorList.size() == this._maxVisitors) {
                throw new IllegalStateException("attachElementVisitor called after maximum number of visitors have already been attached");
            }
            if (elementVisitor instanceof ExtensionHook) {
                if (this.getProvider() != null) {
                    ((ExtensionHook)elementVisitor).setProvider(this.getProvider());
                }
                if (this.getSchemaLocation() != null) {
                    ((ExtensionHook)elementVisitor).setSchemaLocation(this.getSchemaLocation());
                }
            }
            this._attachedElementVisitorList.add(elementVisitor);
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            DefaultElementContext context = (DefaultElementContext)extensionRegistry.createInitialContext();
            this._helper.visitRecordedData(context, elementVisitor);
            if (this._attachedElementVisitorList.size() == this._maxVisitors) {
                this._helper.clearRecordedData();
            }
        }
    }

    public int getNumberOfAttachedVisitors() {
        return this._attachedElementVisitorList.size();
    }

    public List<ElementVisitor> getAttachedVisitors() {
        ArrayList<ElementVisitor> copy = new ArrayList<ElementVisitor>(this._attachedElementVisitorList);
        return copy;
    }
}

