/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.editor.AsynchronousEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdevimpl.help.StartPageBuilder;
import oracle.jdevimpl.help.StartPageHook;

final class StartPageEditor
extends AsynchronousEditor {
    private JPanel _mainPanel;
    private boolean pauseContentCreation;
    private boolean contentLoaded;

    StartPageEditor() {
        this.setEditorAttribute("vertical_unit_increment", 100);
        this.setEditorAttribute("horizontal_unit_increment", 100);
    }

    public HelpInfo getHelpInfo() {
        String helpId = StartPageHook.getStartPageDefinition().getHelpId();
        if (helpId != null) {
            return new HelpInfo(helpId);
        }
        return HelpInfo.getDefaultHelpInfo();
    }

    protected void closeImpl(boolean contentAvailable) {
        if (!contentAvailable) {
            return;
        }
        StartPageHook.releaseStartPageDefinition();
    }

    protected Context delayContextSet(Context newContext) {
        Context delayedContext = super.delayContextSet(newContext);
        this.pauseContentCreation();
        return delayedContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetContext(Context context) {
        if (this.isContentCreationPaused()) {
            return;
        }
        if (context == null) {
            return;
        }
        if (this._mainPanel == null) {
            StartPageBuilder builder = new StartPageBuilder();
            this._mainPanel = new JPanel(new BorderLayout());
            JPanel panel = builder.buildStartPage();
            this._mainPanel.add((Component)panel, "Center");
        }
        StartPageEditor startPageEditor = this;
        synchronized (startPageEditor) {
            this.contentLoaded = true;
        }
    }

    protected void getEditorContent(Context newContext) {
        this.resumeContentCreation();
        this.doSetContext(newContext);
    }

    protected Component getGUIComponent() {
        if (this.isContentModelLoaded()) {
            return this._mainPanel;
        }
        return null;
    }

    public synchronized Context getContext(EventObject event) {
        return this.getAdjustedContext(super.getContext(event));
    }

    private Context getAdjustedContext(Context context) {
        Context ideContext;
        if (context != null && !this.hasRealWorkspace(context) && !this.hasRealProject(context) && (this.hasRealWorkspace(ideContext = Context.newIdeContext()) || this.hasRealProject(ideContext))) {
            Context adjustedContext = new Context(context);
            adjustedContext.setWorkspace(ideContext.getWorkspace());
            adjustedContext.setProject(ideContext.getProject());
            return adjustedContext;
        }
        return context;
    }

    private boolean hasRealProject(Context context) {
        return context.getProject() instanceof Project;
    }

    private boolean hasRealWorkspace(Context context) {
        return context.getWorkspace() instanceof Workspace;
    }

    private synchronized boolean isContentCreationPaused() {
        return this.pauseContentCreation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isContentModelLoaded() {
        StartPageEditor startPageEditor = this;
        synchronized (startPageEditor) {
            return this.contentLoaded;
        }
    }

    protected void openImpl(boolean contentAvailable) {
    }

    private synchronized void pauseContentCreation() {
        this.pauseContentCreation = true;
    }

    private synchronized void resumeContentCreation() {
        this.pauseContentCreation = false;
    }
}

