/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.CellComponent;
import oracle.jdevimpl.help.ColorUtils;

public class MenuButton
extends MenuToolButton
implements CellComponent,
PopupMenuListener {
    private Cell _cell;
    private String[] _actions;

    public MenuButton() {
        super((ToggleAction)null);
        this.setFont(this.getFont().deriveFont(1, 11.0f));
        this.setForeground(ColorUtils.buttonTextColor);
        this.setBorderPainted(true);
        this.setRolloverEnabled(true);
        this.setHorizontalAlignment(10);
        this.addPopupMenuListener(this);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width, 24);
    }

    public Insets getInsets() {
        return new Insets(0, 8, 0, 8);
    }

    @Override
    public void setCell(Cell cell) {
        this._cell = cell;
        ResourceUtils.resButton((AbstractButton)((Object)this), (String)cell.getName());
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        RoundRectangle2D fillRectangle = this.getRoundedRectangle();
        if (this.getModel().isRollover()) {
            ColorUtils.buttonRolloverFill.paint(g2, (Shape)fillRectangle);
        }
        if (this.getModel().isPressed()) {
            ColorUtils.buttonPressedFill.paint(g2, (Shape)fillRectangle);
        } else {
            ColorUtils.buttonNormalFill.paint(g2, (Shape)fillRectangle);
        }
        super.paintComponent((Graphics)g2);
    }

    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.setRenderingHints(g2);
        RoundRectangle2D fillRectangle = this.getRoundedRectangle();
        if (this.getModel().isRollover()) {
            ColorUtils.buttonRolloverFill.draw(g2, (Shape)fillRectangle);
        }
        if (this.getModel().isPressed()) {
            ColorUtils.buttonPressedFill.draw(g2, (Shape)fillRectangle);
        } else {
            ColorUtils.buttonNormalFill.draw(g2, (Shape)fillRectangle);
        }
    }

    private void setRenderingHints(Graphics2D g2) {
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            rhints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.addRenderingHints(rhints);
        }
    }

    private RoundRectangle2D getRoundedRectangle() {
        return new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, 5.0, 5.0);
    }

    private String[] getActionRefs() {
        if (this._actions == null) {
            int i;
            String actionRefs = null;
            actionRefs = this._cell.getParameter("resolvedActions") != null ? this._cell.getParameterValue("resolvedActions") : this._cell.getParameterValue("action-refs");
            String[] actions = actionRefs.split(";");
            Object[] actionPairs = new Pair[actions.length];
            float f = 0.0f;
            for (i = 0; i < actions.length; ++i) {
                String actionRef = actions[i];
                int leftBracketPos = actionRef.indexOf(91);
                if (leftBracketPos != -1) {
                    String actionWeight = actionRef.substring(leftBracketPos + 1, actionRef.indexOf(93));
                    actionRef = actionRef.substring(0, leftBracketPos);
                    f = Float.valueOf(actionWeight).floatValue();
                    Pair actionPair = new Pair((Object)Float.valueOf(f), (Object)actionRef);
                    actionPairs[i] = actionPair;
                    continue;
                }
                f = Math.nextUp(f);
                actionPairs[i] = new Pair((Object)Float.valueOf(f), (Object)actionRef);
            }
            Arrays.sort(actionPairs);
            for (i = 0; i < actionPairs.length; ++i) {
                actions[i] = (String)actionPairs[i].getSecond();
            }
            this._actions = actions;
        }
        return this._actions;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        String hideIfDisabledString = this._cell.getParameterValue("hideIfDisabled");
        String[] actions = this.getActionRefs();
        for (int i = 0; i < actions.length; ++i) {
            String actionRef = actions[i];
            if (actionRef.equals("separator")) {
                if (this.getPopupMenu().getComponentCount() <= 0 || this.getPopupMenu().getComponent(this.getPopupMenu().getComponentCount() - 1) instanceof JSeparator || i >= actions.length - 1) continue;
                this.add(new JSeparator());
                continue;
            }
            IdeAction ideAction = IdeAction.find((String)actionRef);
            if (ideAction == null) continue;
            ideAction.updateAction(Context.newIdeContext());
            if (!ideAction.isEnabled() && Boolean.valueOf(hideIfDisabledString).booleanValue()) continue;
            JMenuItem mi = new JMenuItem((Action)ideAction);
            this.add(mi);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.getPopupMenu().removeAll();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

