/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.panels.ConnectionComponentCache;
import oracle.jdevimpl.db.resource.ConnBundle;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class SSHTunnelConfigurationPanel
extends ConnectionComponentCache
implements Traversable {
    private final JPanel m_panel = new JPanel();
    private final JCheckBox m_chkSSH = new JCheckBox();
    private final JTextField m_fldHost = new JTextField();
    private final JTextField m_fldPort = SSHTunnelConfigurationPanel.newPortField();
    private final JLabel m_lblUser = new JLabel();
    private final JTextField m_fldUser = new JTextField();
    private final JCheckBox m_chkCurrUser = new JCheckBox();
    private final JLabel m_lblAuth = new JLabel();
    private final JRadioButton m_rdbPassword = new JRadioButton();
    private final JRadioButton m_rdbKey = new JRadioButton();
    private final URLTextField m_fldKeyFile = new URLTextField();
    private final JButton m_btnBrowse = new JButton();
    private final JCheckBox m_chkSavePass = new JCheckBox();
    private final JLabel m_lblPassword = new JLabel();
    private final JTextField m_fldPassword = new JPasswordField();

    public SSHTunnelConfigurationPanel(String subType) {
        super(subType, "SSHTunnelConfigurationPanel");
        DBUIResourceHelper reshelp = this.getResourceHelper();
        reshelp.resButton((AbstractButton)this.m_chkSSH, ConnBundle.get("SSH_USE"), "UseSSH");
        reshelp.resButton((AbstractButton)this.m_btnBrowse, ConnBundle.get("SSH_BROWSE"), "KeyBrowse");
        reshelp.resButton((AbstractButton)this.m_chkCurrUser, ConnBundle.get("SSH_CURRENT_USER"), "CurrentUser");
        reshelp.resButton((AbstractButton)this.m_rdbKey, ConnBundle.get("SSH_AUTH_KEY"), "AuthKey");
        reshelp.resButton((AbstractButton)this.m_rdbPassword, ConnBundle.get("SSH_AUTH_PASS"), "AuthPass");
        reshelp.resButton((AbstractButton)this.m_chkSavePass, ConnBundle.format("SSH_SAVE_PASS", ConnBundle.get("SSH_AUTH_PASS")), "SavePass");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHTunnelConfigurationPanel.this.checkComponents();
                if (e.getSource() == SSHTunnelConfigurationPanel.this.m_rdbKey) {
                    SSHTunnelConfigurationPanel.this.m_fldKeyFile.requestFocusInWindow();
                } else if (e.getSource() == SSHTunnelConfigurationPanel.this.m_rdbPassword) {
                    SSHTunnelConfigurationPanel.this.m_fldPassword.requestFocusInWindow();
                }
            }
        };
        this.m_chkSSH.addActionListener(al);
        this.m_chkSavePass.addActionListener(al);
        this.m_chkCurrUser.addActionListener(al);
        this.m_chkCurrUser.setSelected(true);
        this.m_lblAuth.setText(ConnBundle.get("SSH_AUTH"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbPassword);
        bg.add(this.m_rdbKey);
        this.m_rdbPassword.setSelected(true);
        this.m_rdbPassword.addActionListener(al);
        this.m_rdbKey.addActionListener(al);
        URL userHome = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        URL sshHome = URLFactory.newDirURL((URL)userHome, (String)".ssh");
        this.m_fldKeyFile.setDefaultChooserURL(URLFileSystem.exists((URL)sshHome) ? sshHome : userHome);
        this.m_fldKeyFile.setDirectoryOnly(false);
        this.m_btnBrowse.addActionListener((ActionListener)this.m_fldKeyFile);
        JLabel lblHost = new JLabel();
        this.registerTextComponent("SSH.Host", lblHost, this.m_fldHost, "Host");
        JLabel lblPort = new JLabel();
        this.registerTextComponent("SSH.Port", lblPort, this.m_fldPort, "Port");
        this.registerTextComponent("SSH.User", this.m_lblUser, this.m_fldUser, "User");
        this.registerTextComponent("SSH.Password", this.m_lblPassword, this.m_fldPassword, "Password");
        JLabel lblKey = new JLabel();
        this.registerTextComponent("SSH.LocalFile", lblKey, (JTextComponent)this.m_fldKeyFile, "KeyFile");
        this.m_panel.setPreferredSize(new Dimension(450, 250));
        DBUILayoutHelper topLayout = new DBUILayoutHelper(this.m_panel);
        DBUILayoutHelper layout = topLayout.newTitledHelper((JComponent)this.m_chkSSH, 1, 1, true, true);
        layout.add((Component)lblHost);
        layout.add((Component)this.m_fldHost);
        layout.add((Component)lblPort);
        layout.add((Component)this.m_fldPort, 1, 1, false, false);
        layout.nextRowWithGap();
        layout.add((Component)this.m_lblUser);
        layout.add((Component)this.m_fldUser);
        layout.add((Component)this.m_chkCurrUser, 2, 1);
        layout.nextRowWithGap();
        layout.add((Component)this.m_lblAuth);
        DBUILayoutHelper authLayout = layout.newChildHelper(3, 1, true, false);
        authLayout.add((Component)this.m_rdbPassword);
        authLayout.add((Component)this.m_rdbKey);
        authLayout.pushLeft();
        layout.nextRow();
        DBUILayoutHelper authOptionsLayout = layout.newChildHelper(4, 1, true, false);
        authOptionsLayout.setMarginLeft(16);
        authOptionsLayout.add((Component)lblKey);
        authOptionsLayout.add((Component)this.m_fldKeyFile);
        authOptionsLayout.add((Component)this.m_btnBrowse);
        authOptionsLayout.nextRow();
        authOptionsLayout.add((Component)this.m_chkSavePass, 2, 1, false, false);
        authOptionsLayout.nextRow();
        authOptionsLayout.add((Component)this.m_lblPassword);
        authOptionsLayout.add((Component)this.m_fldPassword);
        layout.pushUp();
        topLayout.layout();
        new DBUIMnemonicBuilder(this.m_panel).build();
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return "f1_dbconnectionssh_html";
    }

    public void onEntry(TraversableContext dataContext) {
        Properties connectionProps = (Properties)dataContext.get("NewObject");
        boolean ssh = Boolean.parseBoolean(connectionProps.getProperty("SSH.Enabled"));
        this.m_chkSSH.setSelected(ssh);
        this.populateConnectionDetails(connectionProps);
        if (!ModelUtil.hasLength((String)this.m_fldPort.getText())) {
            this.m_fldPort.setText(String.valueOf(22));
        }
        if (ModelUtil.hasLength((String)connectionProps.getProperty("SSH.LocalFile"))) {
            this.m_rdbKey.setSelected(true);
        } else {
            this.m_rdbPassword.setSelected(true);
        }
        this.m_chkCurrUser.setSelected(!ModelUtil.hasLength((String)connectionProps.getProperty("SSH.User")));
        this.m_chkSavePass.setSelected(ModelUtil.hasLength((String)connectionProps.getProperty("SSH.Password")));
        this.checkComponents();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Properties connectionProps = (Properties)dataContext.get("NewObject");
        if (this.m_chkSSH.isSelected()) {
            MissingDBConnValueException.check(this.m_fldHost.getText(), this.getPropertyLabelText("SSH.Host"));
            connectionProps.setProperty("SSH.Enabled", Boolean.TRUE.toString());
            this.commitConnectionDetails(connectionProps);
            if (this.m_chkCurrUser.isSelected()) {
                connectionProps.remove("SSH.User");
            }
            if (!this.m_chkSavePass.isSelected()) {
                connectionProps.remove("SSH.Password");
            }
            if (!this.m_rdbKey.isSelected()) {
                connectionProps.remove("SSH.LocalFile");
            }
        } else {
            connectionProps.remove("SSH.Enabled");
            for (String prop : this.getRegisteredProperties()) {
                connectionProps.remove(prop);
            }
        }
    }

    private void checkComponents() {
        boolean ssh = this.m_chkSSH.isSelected();
        this.m_btnBrowse.setEnabled(ssh);
        this.m_chkCurrUser.setEnabled(ssh);
        this.m_rdbKey.setEnabled(ssh);
        this.m_rdbPassword.setEnabled(ssh);
        this.m_chkSavePass.setEnabled(ssh);
        this.m_lblAuth.setEnabled(ssh);
        for (String prop : this.getRegisteredProperties()) {
            this.setEnabled(prop, ssh);
        }
        boolean identity = this.m_rdbKey.isSelected();
        this.setVisible("SSH.LocalFile", identity);
        this.m_btnBrowse.setVisible(identity);
        this.m_lblPassword.setText(identity ? ConnBundle.get("SSH_PASSPHRASE") : StringUtils.stripMnemonic((String)ConnPropsBundle.get("SSH.Password")) + ':');
        this.m_chkSavePass.setText(StringUtils.stripMnemonic((String)ConnBundle.format("SSH_SAVE_PASS", ConnBundle.get(identity ? "SSH_PASSPHRASE" : "SSH_AUTH_PASS"))));
        if (ssh) {
            if (this.m_chkCurrUser.isSelected()) {
                this.m_fldUser.setText(null);
                this.m_fldUser.setEnabled(false);
                this.m_lblUser.setEnabled(true);
            }
            boolean savePass = this.m_chkSavePass.isSelected();
            this.setEnabled("SSH.Password", savePass);
            if (!savePass) {
                this.m_fldPassword.setText(null);
            }
        }
    }

    public static void editSSHConfig(Component parent, String subType, Properties connectionProps) {
        try {
            SSHTunnelConfigurationPanel panel = new SSHTunnelConfigurationPanel(subType);
            Namespace data = new Namespace();
            data.put("NewObject", (Object)connectionProps);
            TDialogLauncher launcher = new TDialogLauncher(parent, ConnBundle.get("SSH_TITLE"), (Traversable)panel, data);
            launcher.setPackDialog(true);
            launcher.initDialog().setName("SSHTunnelConfigurationDialog");
            launcher.showDialog();
        }
        catch (Exception e) {
            DBLog.getLogger(SSHTunnelConfigurationPanel.class).log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

