/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class CAConnectionCreatorFactory
extends DatabaseFactory.ConnectionCreatorFactory {
    private static final Map<String, DatabaseFactory.ConnectionCreator> s_stores = new HashMap<String, DatabaseFactory.ConnectionCreator>();

    public DatabaseFactory.ConnectionCreator getCreator(String storeName) {
        DatabaseConnectionStores.getInstance().getStore(storeName);
        return CAConnectionCreatorFactory.findCreator(storeName);
    }

    public Collection<DatabaseFactory.ConnectionCreator> listCreators() {
        return s_stores.values();
    }

    public static DatabaseFactory.ConnectionCreator findCreator(String storeName) {
        return s_stores.get(storeName);
    }

    public static void cacheCreator(String storeName, DatabaseFactory.ConnectionCreator cc) {
        DatabaseFactory.ConnectionCreator exists = s_stores.get(storeName);
        if (exists != null) {
            if (exists != cc) {
                throw new IllegalStateException(storeName + " already exists");
            }
        } else {
            s_stores.put(storeName, cc);
        }
    }

    public static void uncacheCreator(String storeName, DatabaseFactory.ConnectionCreator cc) {
        DatabaseFactory.ConnectionCreator gone = s_stores.remove(storeName);
        if (gone != cc) {
            DBLog.getLogger(CAConnectionCreatorFactory.class).log(Level.WARNING, "ConnectionCreator removed but it didn't match for " + storeName);
        }
    }
}

