/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.StoreListener;
import oracle.jdeveloper.db.StoreProvider;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.StoreContext;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;
import oracle.jdevimpl.db.resource.ConnBundle;

public final class DatabaseConnectionStores {
    public static final String CENTRAL_STORE = "IdeConnections";
    private static DatabaseConnectionStores s_instance;
    private final List<StoreProvider> m_providers = new ArrayList<StoreProvider>();
    private boolean m_providersInit;
    private final Collection<StoreListener> m_listeners = new HashSet<StoreListener>();
    private boolean m_listenersInit;

    public static final DatabaseConnectionStores getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseConnectionStores();
        }
        return s_instance;
    }

    private DatabaseConnectionStores() {
    }

    private synchronized Collection<StoreListener> getListeners() {
        if (!this.m_listenersInit) {
            this.m_listenersInit = true;
            DatabaseConnectionHook hook = DatabaseConnectionHook.getHook();
            if (hook != null) {
                for (StoreListener l : hook.getStoreListeners()) {
                    this.addStoreListener(l);
                }
            }
        }
        return Collections.unmodifiableCollection(new HashSet<StoreListener>(this.m_listeners));
    }

    private synchronized List<StoreProvider> getProviders() {
        if (!this.m_providersInit) {
            this.m_providersInit = true;
            this.registerStoreProviderImpl(new CentralStoreProvider());
            DatabaseConnectionHook hook = DatabaseConnectionHook.getHook();
            if (hook != null) {
                for (StoreProvider provider : hook.getStoreProviders()) {
                    this.registerStoreProviderImpl(provider);
                }
            }
        }
        return this.m_providers;
    }

    void fireStoreAdded(String storeName) {
        for (StoreListener l : this.getListeners()) {
            try {
                l.storeAdded(storeName);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", e);
            }
        }
        this.printStores();
    }

    void fireStoreRemoved(String storeName, DatabaseConnections gone) {
        for (StoreListener l : this.getListeners()) {
            try {
                l.storeRemoved(storeName);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "DatabaseConnectionStores listener error", e);
            }
        }
        if (gone != null) {
            gone.closeStore();
        }
        this.printStores();
    }

    public void addStoreListener(StoreListener l) {
        this.m_listeners.add(l);
    }

    public void removeStoreListener(StoreListener l) {
        this.m_listeners.remove(l);
    }

    public Collection<String> listStores() {
        ArrayList<String> retval = new ArrayList<String>();
        for (StoreProvider provider : this.getProviders()) {
            retval.addAll(provider.listStores());
        }
        return retval;
    }

    public Collection<String> listStores(Context ideContext) {
        if (ideContext == null) {
            return this.listStores();
        }
        return StoreContext.getContext().listStores(ideContext);
    }

    public DatabaseConnections getCurrentStore() {
        if (Ide.isRunning()) {
            return this.getCurrentStore(Context.newIdeContext());
        }
        return DatabaseConnections.getInstance();
    }

    public DatabaseConnections getCurrentStore(Context ideContext) {
        String storeName = this.getCurrentStoreName(ideContext);
        return this.getStore(storeName);
    }

    public String getCurrentStoreName(Context ideContext) {
        String retval = null;
        if (ideContext != null) {
            for (StoreProvider provider : this.getProviders()) {
                String storeName = provider.getCurrentStore(ideContext);
                if (!ModelUtil.hasLength((String)storeName)) continue;
                retval = storeName;
                break;
            }
            if (retval == null) {
                Element elem = ideContext.getElement();
                retval = DBObjectNodeUtil.getStoreName((Object)elem);
            }
        }
        if (retval == null) {
            if (StoreContext.getContext().isCentralStoreAvailable()) {
                retval = CENTRAL_STORE;
            } else {
                Collection<String> all = this.listStores();
                if (all.size() == 1) {
                    retval = all.iterator().next();
                }
            }
        }
        return retval;
    }

    public String getCurrentConnection(Context ideContext) {
        ConnectionInfo ci = this.getCurrentConnectionInfo(ideContext);
        return ci == null ? null : ci.getConnectionName();
    }

    public ConnectionInfo getCurrentConnectionInfo(Context ideContext) {
        ConnectionInfo retval = null;
        if (ideContext != null) {
            String storeName = this.getCurrentStoreName(ideContext);
            StoreProvider provider = this.findProvider(storeName);
            String connName = null;
            connName = provider == null ? DBObjectNodeUtil.getConnectionName((Object)ideContext.getElement()) : provider.getCurrentConnection(ideContext);
            retval = new ConnectionInfo(storeName, connName);
        }
        return retval != null && retval.isValid() ? retval : null;
    }

    public Database getCurrentDatabase(Context ideContext) {
        Database retval = null;
        ConnectionInfo info = this.getCurrentConnectionInfo(ideContext);
        if (info.isValid()) {
            try {
                retval = info.getDatabase();
            }
            catch (DBException dbe) {
                this.getLogger().warning(info.getConnectionName() + ": " + dbe.getMessage());
            }
        }
        return retval;
    }

    public DatabaseConnections getStore(String storeName) {
        if (storeName == null) {
            return null;
        }
        for (StoreProvider provider : this.getProviders()) {
            DatabaseConnections store = provider.getStore(storeName);
            if (store == null) continue;
            return store;
        }
        return null;
    }

    private StoreProvider findProvider(String storeName) {
        StoreProvider retval = null;
        if (storeName != null) {
            for (StoreProvider provider : this.getProviders()) {
                Collection<String> names = provider.listStores();
                if (names == null || !names.contains(storeName)) continue;
                retval = provider;
                break;
            }
        }
        return retval;
    }

    public String getShortLabel(String storeName) {
        String shortLabel = null;
        StoreProvider provider = this.findProvider(storeName);
        if (provider != null) {
            shortLabel = provider.getShortLabel(storeName);
        }
        return shortLabel;
    }

    public Icon getIcon(String storeName) {
        Icon icon = null;
        StoreProvider provider = this.findProvider(storeName);
        if (provider != null) {
            icon = provider.getIcon(storeName);
        }
        return icon;
    }

    public String getToolTipText(String storeName) {
        String ttt = null;
        StoreProvider provider = this.findProvider(storeName);
        if (provider != null) {
            ttt = provider.getToolTipText(storeName);
        }
        return ttt;
    }

    @Deprecated
    public void registerStoreProvider(StoreProvider provider) {
        this.getLogger().log(Level.INFO, "Programatic StoreProvider registration deprecated, use extension.xml to register: " + provider.getClass().getName());
        this.registerStoreProviderImpl(provider);
    }

    private void registerStoreProviderImpl(StoreProvider provider) {
        this.m_providers.add(0, provider);
        for (String store : provider.listStores()) {
            this.fireStoreAdded(store);
        }
        this.getLogger().log(Level.FINE, "Registered new database connection store provider: " + provider.getClass().getName());
    }

    private Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    private void printStores() {
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            Collection<String> stores = this.listStores();
            if (stores.size() > 0) {
                StringBuilder buff = new StringBuilder();
                buff.append("Available database connection stores: \n");
                for (String name : stores) {
                    buff.append(name).append("\n");
                }
                logger.log(Level.FINE, buff.toString());
            } else {
                logger.log(Level.FINE, "There are no available database connection stores.");
            }
        }
    }

    public static DatabaseProvider getReferenceable(String storeName, String connName) {
        DatabaseConnections chosen;
        if (storeName != null && (chosen = DatabaseConnectionStores.getInstance().getStore(storeName)) != null) {
            try {
                return chosen.getReferenceable(connName);
            }
            catch (ConnectionException ce) {
                DBLog.getLogger(DatabaseConnectionStores.class).log(Level.WARNING, "Cannot get connection " + connName + " from store " + storeName, ce);
            }
        }
        return null;
    }

    private class CentralStoreProvider
    extends StoreProvider {
        private CentralStoreProvider() {
        }

        @Override
        public DatabaseConnections getStore(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return DatabaseConnections.getInstance();
            }
            return null;
        }

        @Override
        public String getShortLabel(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return ConnBundle.get("CENTRAL_STORE_NAME");
            }
            return null;
        }

        @Override
        public Icon getIcon(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return OracleIcons.getIcon((String)"dbconn.png");
            }
            return null;
        }

        @Override
        public String getToolTipText(String storeName) {
            if (storeName.equals(DatabaseConnectionStores.CENTRAL_STORE)) {
                return ConnBundle.get("CENTRAL_STORE_TTT");
            }
            return null;
        }

        @Override
        public Collection<String> listStores() {
            Collection<Object> retval = StoreContext.getContext().isCentralStoreAvailable() ? Collections.singleton(DatabaseConnectionStores.CENTRAL_STORE) : Collections.emptyList();
            return retval;
        }

        @Override
        protected String getCurrentStore(Context ideContext) {
            return null;
        }
    }
}

