/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.xml.bind.DatatypeConverter;

public class Encryption {
    public static byte[] generateSalt(String ... seedValues) {
        if (seedValues == null || seedValues.length == 0) {
            throw new IllegalArgumentException("Null or empty seed values");
        }
        assert (seedValues != null);
        byte[] salt = new byte[]{-116, 77, 101, -88, -97, 80, 82, 51};
        int SALT_LEN = salt.length;
        for (String seed : seedValues) {
            if (seed != null) {
                int i = 0;
                for (byte b : seed.getBytes()) {
                    salt[i % SALT_LEN] = (byte)(b ^ salt[i % SALT_LEN]);
                    ++i;
                }
                continue;
            }
            throw new IllegalArgumentException("Null seed value");
        }
        return salt;
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String encrypt(char[] value, String key, byte[] salt) {
        if (value == null || value.length == 0 || Encryption.isNullOrEmpty(key) || salt == null || salt.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Wrapper wrapper = Wrapper.newInstance(key, salt);
            return wrapper.encrypt(value);
        }
        catch (Throwable t) {
            throw Encryption.asRuntimeException(t);
        }
    }

    public static char[] decrypt(String encryptedValue, String key, byte[] salt) {
        if (Encryption.isNullOrEmpty(encryptedValue) || Encryption.isNullOrEmpty(key) || salt == null || salt.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Wrapper wrapper = Wrapper.newInstance(key, salt);
            return wrapper.decrypt(encryptedValue);
        }
        catch (Throwable t) {
            throw Encryption.asRuntimeException(t);
        }
    }

    private static boolean isNullOrEmpty(String val) {
        return val == null || val.isEmpty();
    }

    private static RuntimeException asRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    static final class Wrapper {
        private static final int ITERATION_COUNT = 42;
        private Cipher m_encoder;
        private Cipher m_decoder;
        private AlgorithmParameterSpec m_paramSpec;
        private SecretKey m_key;
        private CharsetEncoder m_charEnc;
        private CharsetDecoder m_charDec;

        public static Wrapper newInstance(String key, byte[] salt) throws InvalidKeySpecException, NoSuchAlgorithmException {
            if (null == key || null == salt) {
                throw new IllegalArgumentException("null arguments");
            }
            return new Wrapper(key, salt);
        }

        private Wrapper(String passPhrase, byte[] salt) throws InvalidKeySpecException, NoSuchAlgorithmException {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, 42);
            this.m_key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.m_paramSpec = new PBEParameterSpec(salt, 42);
        }

        public String encrypt(char[] raw) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, CharacterCodingException, IllegalBlockSizeException, BadPaddingException {
            if (null == raw || raw.length == 0) {
                throw new IllegalArgumentException("null input value");
            }
            byte[] enc = null;
            if (this.m_encoder == null) {
                this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
            }
            if (this.m_charEnc == null) {
                this.m_charEnc = StandardCharsets.UTF_8.newEncoder();
            }
            ByteBuffer bb = this.m_charEnc.encode(CharBuffer.wrap(raw));
            byte[] utf8 = new byte[bb.limit()];
            bb.get(utf8);
            enc = this.m_encoder.doFinal(utf8);
            return DatatypeConverter.printBase64Binary((byte[])enc);
        }

        public char[] decrypt(String str) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CharacterCodingException {
            if (Encryption.isNullOrEmpty(str)) {
                throw new IllegalArgumentException("null input string");
            }
            if (this.m_decoder == null) {
                this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
            }
            byte[] dec = DatatypeConverter.parseBase64Binary((String)str);
            byte[] utf8 = this.m_decoder.doFinal(dec);
            if (this.m_charDec == null) {
                this.m_charDec = StandardCharsets.UTF_8.newDecoder();
            }
            CharBuffer charbuf = this.m_charDec.decode(ByteBuffer.wrap(utf8));
            char[] ca = new char[charbuf.limit()];
            charbuf.get(ca);
            return ca;
        }
    }
}

