/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthKeepAliveStrategy;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.ReAuthOnResponseStatus;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.jaxrs.JaxrsSessionBuilder;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.validation.DataFileScriptGenerator;
import oracle.dbtools.util.Logger;

public class OracleStorageCloudService
extends Location {
    public static final String INCLUDE_OSS = "oss.enabled";
    public static final String SERVICE_NAME_KEY = "oss.service_name";
    public static final String IDENTITY_DOMAIN_KEY = "oss.identity_domain";
    public static final String USERNAME_KEY = "oss.username";
    public static final String PASSWORD_KEY = "oss.password";
    private String serviceName;
    private String identityDomain;
    private String userName;
    private char[] userData;
    private String serviceUrl;
    private ISession session;

    public OracleStorageCloudService(String aServiceName, String anIdentityDomain, String aUserName, char[] aPassword, String aServiceUrl) {
        assert (aServiceName != null);
        assert (aUserName != null);
        assert (aPassword != null);
        assert (aServiceUrl != null);
        this.serviceName = aServiceName;
        this.identityDomain = anIdentityDomain;
        this.userName = aUserName;
        this.userData = aPassword;
        this.serviceUrl = aServiceUrl;
    }

    @Override
    public OracleStorageCloudService clone() {
        return new OracleStorageCloudService(this.serviceName, this.identityDomain, this.userName, this.userData, this.serviceUrl);
    }

    @Override
    public void connect() throws IOException {
        if (null == this.session) {
            this.session = new JaxrsSessionBuilder().session();
            IAuthReply authReply = null;
            try {
                authReply = this.session.auth().keepAlive((IAuthKeepAliveStrategy)new ReAuthOnResponseStatus(Status.UNAUTHORIZED, new Status[0])).url(this.serviceUrl).user(this.serviceName, this.identityDomain, this.userName).password(String.valueOf(this.userData)).send();
                if (!authReply.isSuccessful()) {
                    throw new IOException(authReply.getMessage());
                }
            }
            catch (InterruptedException | RetryException e) {
                Logger.severe(this.getClass(), String.valueOf(authReply), e);
                throw new IOException(e);
            }
            Logger.info(this.getClass(), String.valueOf(this));
        }
    }

    public ISession getSession() {
        return this.session;
    }

    @Override
    public void disconnect() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        Logger.info(this.getClass(), String.valueOf(this));
    }

    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor progressMonitor, CopyOption ... options) throws IOException {
        long len = in.available();
        double size = (double)len / 1048576.0;
        Logger.info(this.getClass(), in + ", " + target + ", " + Arrays.toString(options) + ", len=" + size + " MiB");
        String[] path = target.split("/");
        String container = path[0];
        String name = path[1];
        IPutObjectReply putObjectReply = null;
        try {
            InputStreamProgressWrapper inw = new InputStreamProgressWrapper(in, progressMonitor, len);
            putObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)this.session.put().container(container)).object(name)).data((InputStream)inw).send();
        }
        catch (Throwable t) {
            Logger.severe(this.getClass(), String.valueOf(putObjectReply), t);
            throw this.asIOException(t);
        }
        return len;
    }

    @Override
    public String toString() {
        return this.userName + '@' + this.serviceName + ' ' + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        block15: {
            IPutContainerReply reply = null;
            try {
                String container = targetDir;
                if (container.endsWith("/")) {
                    container = container.substring(0, container.length() - 1);
                }
                reply = ((IPutRequestBuilder.Container)this.session.put().container(container)).send();
                reply = ((IGetRequestBuilder.Container)this.session.get().container(container)).send();
                if (!reply.isSuccessful()) {
                    throw new IOException(TransferMessages.format("TransferControlTask.doPreprocessingOnTarget.noTgtDir", targetDir));
                }
                Set fileNames = ((IGetContainerReply)reply).getObjectIds();
                if (fileNames != null && !fileNames.isEmpty()) {
                    Map<String, FileInfo> fileMap = DataFileScriptGenerator.getMappedFileList(fileInfos);
                    Map<String, FileChunk> chunkMap = DataFileScriptGenerator.getMappedChunkList(fileInfos);
                    for (String file : fileNames) {
                        FileChunk fileChunk;
                        FileInfo fileInfo = fileMap.get(file);
                        if (fileInfo != null) {
                            reply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)this.session.head().container(container)).object(file)).send();
                            if (!reply.isSuccessful()) continue;
                            String md5 = reply.getHeader(Header.eTag);
                            if (ModelUtil.areEqual(md5, fileInfo.getMd5())) {
                                fileInfo.setTransferred(true);
                                for (FileChunk fileChunk2 : fileInfo.getFileChunks()) {
                                    fileChunk2.setTransferred(true);
                                    chunkMap.remove(fileChunk2.getName());
                                }
                            }
                        }
                        if ((fileChunk = chunkMap.get(file)) == null || !(reply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)this.session.head().container(container)).object(file)).send()).isSuccessful()) continue;
                        String rmd5 = reply.getHeader(Header.eTag);
                        fileChunk.calculateMd5();
                        String fmd5 = fileChunk.getMd5();
                        if (!ModelUtil.areEqual(rmd5, fmd5)) continue;
                        fileChunk.setTransferred(true);
                    }
                }
                long sizeRequired = 0L;
                for (FileInfo fileInfo : fileInfos) {
                    if (!fileInfo.isTransferred()) {
                        sizeRequired += fileInfo.getLength();
                    }
                    if (fileInfo.getFileChunks().size() <= 1) continue;
                    for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                        if (!fileChunk.isTransferred()) continue;
                        sizeRequired -= fileChunk.getSize();
                    }
                }
                reply = this.session.head().send();
                if (!reply.isSuccessful()) break block15;
                try {
                    String aquota = reply.getHeader("x-account-meta-quota-bytes");
                    String aused = reply.getHeader("x-account-bytes-used");
                    long quota = Long.valueOf(aquota);
                    long used = Long.valueOf(aused);
                    long available = quota - used;
                    if (sizeRequired > available) {
                        throw new IOException(TransferMessages.format("TransferControlTask.doPreprocessingOnTarget.noSpaceDetail", sizeRequired, available));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (Throwable t) {
                throw this.asIOException(t);
            }
        }
        return true;
    }

    @Override
    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
        IHeadObjectReply reply = null;
        boolean restartRequired = false;
        try {
            String container = targetDir;
            if (container.endsWith("/")) {
                container = container.substring(0, container.length() - 1);
            }
            for (FileInfo fileInfo : fileInfos) {
                HashMap<String, FileChunk> chunkMap = new HashMap<String, FileChunk>();
                for (FileChunk chunk : fileInfo.getFileChunks()) {
                    chunkMap.put(chunk.getName(), chunk);
                }
                for (FileChunk fileChunk : fileInfo.getFileChunks()) {
                    reply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)this.session.head().container(container)).object(fileChunk.getName())).send();
                    if (!reply.isSuccessful()) continue;
                    String rmd5 = reply.getHeader(Header.eTag);
                    fileChunk.calculateMd5();
                    String fmd5 = fileChunk.getMd5();
                    if (!ModelUtil.areEqual(rmd5, fmd5)) continue;
                    fileChunk.setTransferred(true);
                    chunkMap.remove(fileChunk.getName());
                }
                if (chunkMap.isEmpty()) {
                    if (fileInfo.getFileChunks().size() <= 1) continue;
                    String name = fileInfo.getPath().getFileName().toString();
                    String manifestValue = container + '/' + name + '-';
                    String md5 = fileInfo.getMd5();
                    IPutObjectReply manifestReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Header)((IPutRequestBuilder.Header)this.session.put().header((Iterable)Header.dynamicLargeObjectManifest.provide((Object)manifestValue))).header((Iterable)Header.dynamicLargeObjectMd5.provide((Object)md5))).container(container)).object(name)).encrypt(false).data((InputStream)null).send();
                    if (!manifestReply.isSuccessful()) {
                        restartRequired = true;
                    }
                    fileInfo.setTransferred(true);
                    continue;
                }
                restartRequired = true;
            }
        }
        catch (Throwable t) {
            throw this.asIOException(t);
        }
        if (restartRequired) {
            throw new TransferRestartRequest();
        }
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        InputStream in = null;
        String name = path.getFileName().toString();
        String container = path.getParent().getFileName().toString();
        try {
            IGetObjectReply greply = ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)this.session.get().container(container)).object(name)).send();
            in = greply.getData();
        }
        catch (Throwable t) {
            throw this.asIOException(t);
        }
        return in;
    }

    @Override
    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        return null;
    }

    private IOException asIOException(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class FileInfoList {
        List<FileInfo> fileInfos;

        public FileInfoList() {
        }

        public FileInfoList(List<FileInfo> fileInfosIn) {
            this.fileInfos = fileInfosIn;
        }

        public List<FileInfo> getFileInfos() {
            return this.fileInfos;
        }
    }

    class InputStreamProgressWrapper
    extends FilterInputStream {
        protected volatile TransferTaskProgressMonitor progressMonitor;
        private int mark;

        InputStreamProgressWrapper(InputStream in, TransferTaskProgressMonitor aProgressMonitor, long max) {
            super(in);
            assert (aProgressMonitor != null);
            this.progressMonitor = aProgressMonitor;
            this.progressMonitor.init(0, null, null, max);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.progressMonitor.end();
        }

        @Override
        public int read() throws IOException {
            int b = super.read();
            return b;
        }

        @Override
        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            int b = super.read(arg0, arg1, arg2);
            this.progressMonitor.count(b);
            return b;
        }

        @Override
        public int read(byte[] arg0) throws IOException {
            int b = super.read(arg0);
            return b;
        }

        @Override
        public long skip(long arg0) throws IOException {
            long b = super.skip(arg0);
            this.progressMonitor.count(b);
            return b;
        }

        @Override
        public synchronized void mark(int arg0) {
            this.mark = arg0;
            Logger.info(this.getClass(), "" + arg0);
            super.mark(arg0);
        }

        @Override
        public boolean markSupported() {
            Logger.info(this.getClass(), "=" + super.markSupported());
            return super.markSupported();
        }

        @Override
        public synchronized void reset() throws IOException {
            long diff = this.progressMonitor.getCount() - (long)this.mark;
            this.progressMonitor.count(-diff);
            Logger.info(this.getClass(), "" + -diff);
            super.reset();
        }
    }
}

