/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;

public class Location {
    private static Location LOCAL;
    private static DecimalFormat df;
    private static ByteBuffer CHUNK_SIZE_BYTE_BUF;

    protected Location() {
    }

    public static Location getLocal() {
        if (null == LOCAL) {
            LOCAL = new Location();
        }
        return LOCAL;
    }

    public boolean isCloneable() {
        return true;
    }

    public Location clone() {
        return new Location();
    }

    public void connect() throws IOException {
        Logger.info(this.getClass(), String.valueOf(this));
    }

    public void disconnect() {
        Logger.info(this.getClass(), String.valueOf(this));
    }

    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        Logger.fine(this.getClass(), path + ", pos=" + position + ", size=" + size);
        assert (size < Integer.MAX_VALUE);
        byte[] buf = new byte[(int)size];
        ByteArrayInputStream stream = null;
        int read = Location.readBytes(path, position, size, buf);
        stream = new ByteArrayInputStream(buf, 0, read);
        Logger.fine(this.getClass(), read + " bytes available in " + stream);
        return stream;
    }

    public long copy(InputStream in, String target, TransferTaskProgressMonitor progressMonitor, CopyOption ... options) throws IOException {
        Logger.fine(this.getClass(), in + ", " + target + ", " + Arrays.toString(options));
        if (progressMonitor != null) {
            progressMonitor.init(0, null, target, in.available());
        }
        long written = Files.copy(in, Paths.get(target, new String[0]), options);
        if (progressMonitor != null) {
            progressMonitor.count(written);
            progressMonitor.end();
        }
        Logger.fine(this.getClass(), written + " bytes written");
        return written;
    }

    public boolean verifySize(String path, long size) {
        Logger.fine(this.getClass(), path + ", size=" + size);
        boolean verified = size == new File(path).length();
        Logger.fine(this.getClass(), String.valueOf(verified));
        return verified;
    }

    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        long start = System.nanoTime();
        ScriptOutput output = this.executeScript(executeScriptStr, scriptName, targetDir);
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        Logger.info(this.getClass(), tagName + " r/c: " + output.rc + " in " + df.format(elapsed) + " seconds");
        if (output.rc != 0 && output.rc != 7) {
            Logger.warn(this.getClass(), tagName + " stderr:\n" + output.stderr + "\n stdout:\n" + output.stdout);
        }
        return output;
    }

    public ScriptOutput executeScript(String executeScriptStr, String scriptName, String targetDir) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MD5 getMd5(Path path, long offset, long size) {
        assert (size < Integer.MAX_VALUE);
        MD5 md5 = new MD5();
        ByteBuffer byteBuffer = CHUNK_SIZE_BYTE_BUF;
        synchronized (byteBuffer) {
            ByteBuffer buf = CHUNK_SIZE_BYTE_BUF;
            if (size != (long)buf.capacity()) {
                buf = ByteBuffer.allocate((int)size);
            }
            try (FileInputStream fis = new FileInputStream(path.toString());
                 FileChannel fc = fis.getChannel();){
                fc.read(buf, offset);
                buf.flip();
                md5.calculate(buf);
                buf.clear();
            }
            catch (IOException e) {
                Logger.severe(this.getClass(), e);
                return null;
            }
        }
        return md5;
    }

    private static int readBytes(Path path, long position, long size, byte[] buf) throws IOException {
        assert (size == (long)buf.length);
        int read = 0;
        try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(path.toString()));){
            fileStream.skip(position);
            read = fileStream.read(buf, 0, (int)size);
            Logger.fine(Location.class, read + " bytes available in " + buf);
        }
        return read;
    }

    public String toString() {
        if (LOCAL == this) {
            String host = System.getProperty("HOSTNAME");
            return host + ": " + super.toString();
        }
        return super.toString();
    }

    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        return true;
    }

    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
    }

    static {
        df = new DecimalFormat("#0.0000");
        CHUNK_SIZE_BYTE_BUF = ByteBuffer.allocateDirect((int)FileInfo.CHUNK_SIZE);
    }
}

