/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TCPTNSEntry {
    private static final Logger LOGGER = Logger.getLogger(TCPTNSEntry.class.getName());
    public static int SPEC_SHORT_FORMAT = 1;
    public static int SPEC_LONG_FORMAT = 2;
    private int spec_format = 0;
    private String name = null;
    private String hostname = null;
    private String portno = null;
    private String sid = null;
    private String servicename = null;
    private String desc = null;
    private static final Pattern PORT_PATTERN = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern HOST_PATTERN = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern SID_PATTERN = Pattern.compile("\\(\\s*SID\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern SVCNAME_PATTERN = Pattern.compile("\\(\\s*SERVICE_NAME\\s*=\\s*([^\\s)]+)\\s*\\)");

    public TCPTNSEntry(String tnsName, String descriptor) {
        this.spec_format = SPEC_LONG_FORMAT;
        this.name = tnsName;
        this.desc = descriptor;
        this.parseDescriptor();
    }

    TCPTNSEntry(String item, int specFormat) {
        this.spec_format = specFormat;
        this.populate(item);
    }

    protected void populate(String item) {
        int end = item.indexOf("=");
        this.name = item.substring(0, end);
        this.desc = item.substring(end + 1);
        this.parseDescriptor();
    }

    private void parseDescriptor() {
        String copy = this.desc.toUpperCase();
        Matcher match = PORT_PATTERN.matcher(copy);
        if (match.find()) {
            this.portno = this.desc.substring(match.start(1), match.end(1));
        }
        if ((match = HOST_PATTERN.matcher(copy)).find()) {
            this.hostname = this.desc.substring(match.start(1), match.end(1));
        }
        if ((match = SID_PATTERN.matcher(copy)).find()) {
            this.sid = this.desc.substring(match.start(1), match.end(1));
        }
        if ((match = SVCNAME_PATTERN.matcher(copy)).find()) {
            this.servicename = this.desc.substring(match.start(1), match.end(1));
        }
    }

    public String getJDBCUrl() {
        String url = null;
        if (this.spec_format == SPEC_SHORT_FORMAT) {
            if (this.servicename != null) {
                url = "jdbc:oracle:thin:@\\\\" + this.hostname + ":" + this.portno + "\\" + this.servicename;
            } else if (this.sid != null) {
                url = "jdbc:oracle:thin:@" + this.hostname + ":" + this.portno + ":" + this.sid;
            }
        } else if (this.spec_format == SPEC_LONG_FORMAT) {
            url = "jdbc:oracle:thin:@" + this.desc;
        }
        return url;
    }

    public String getSpecUrl() {
        String specUrl = null;
        if (this.spec_format == SPEC_SHORT_FORMAT) {
            if (this.servicename != null) {
                specUrl = "\\\\" + this.hostname + ":" + this.portno + "\\" + this.servicename;
            } else if (this.sid != null) {
                specUrl = this.hostname + ":" + this.portno + ":" + this.sid;
            }
        } else if (this.spec_format == SPEC_LONG_FORMAT) {
            specUrl = this.desc;
        }
        return specUrl;
    }

    public static void printUrl(String[] items) {
        for (int i = 0; i < items.length; ++i) {
            TCPTNSEntry te = new TCPTNSEntry(items[i].replaceAll("\\s", ""), SPEC_LONG_FORMAT);
            LOGGER.info(te.getJDBCUrl());
        }
    }

    public static void main(String[] args) {
        String[] items = new String[]{"ORCL=(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=localhost)(PORT=1521))(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=orcl)))", "spx2tcp  = (description= (address_list=(address=(protocol=spx)(service=orasrvc1))(address=(protocol=tcp)(port=1580)(host=spcstn)))(connect_data=(sid=cman))(source_route=yes))", "tcp_mv713 =\n  (DESCRIPTION =\n    (ADDRESS=      (PROTOCOL=TCP) (HOST=hostname) (PORT=1521))\n    (CONNECT_DATA= (SID=MV713))\n  )", "mv713 = \n  (DESCRIPTION =\n    (ADDRESS=      (PROTOCOL=IPC) (KEY=700))\n    (CONNECT_DATA= (SID=MV713)) \n  )", "EXTPROC_CONNECTION_DATA=(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=IPC)(KEY=EXTPROC1)))"};
        try {
            TCPTNSEntry.printUrl(items);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPortno() {
        return this.portno;
    }

    public String getSid() {
        return this.sid;
    }

    public String getServicename() {
        return this.servicename;
    }

    public String toString() {
        return this.name + "=" + this.getJDBCUrl();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.desc;
    }
}

