/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Image;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.LazyIcon;
import oracle.dbtools.raptor.utils.RaptorResourceBundleControl;

public abstract class MessagesBase {
    private static Map<IconKey, ImageIcon> s_icons = new HashMap<IconKey, ImageIcon>();
    private final ResourceBundle m_bundle;

    protected MessagesBase(String bundleName, ClassLoader cl) {
        this.m_bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), cl, RaptorResourceBundleControl.INSTANCE);
    }

    protected ResourceBundle getResourceBundle() {
        return this.m_bundle;
    }

    protected String getStringImpl(String key) {
        try {
            return this.m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    protected Image getImageImpl(String key) {
        ImageIcon imageIcon = this.getImageIconImpl(key);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon getImageIconImpl(String key) {
        ImageIcon icon;
        String path = this.m_bundle.getString(key);
        if (path == null || path.length() == 0) {
            return null;
        }
        Class<?> cls = this.getClass();
        IconKey cacheKey = new IconKey(cls.getName(), key);
        Map<IconKey, ImageIcon> map = s_icons;
        synchronized (map) {
            icon = s_icons.get(cacheKey);
            if (icon != null) {
                return icon;
            }
        }
        URL url = cls.getResource(path);
        icon = null;
        if (url != null) {
            icon = new LazyIcon(url);
            Map<IconKey, ImageIcon> map2 = s_icons;
            synchronized (map2) {
                s_icons.put(cacheKey, icon);
            }
        }
        return icon;
    }

    protected Icon getIconImpl(String key) {
        return this.getImageIconImpl(key);
    }

    protected String formatImpl(String key, Object ... arguments) {
        try {
            return MessageFormat.format(this.m_bundle.getString(key), arguments);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public final Integer getIntegerImpl(String key) {
        String s = this.getStringImpl(key);
        if (s.length() == 1 && Character.isLetter(s.charAt(0))) {
            return new Integer(s.charAt(0));
        }
        return Integer.valueOf(s);
    }

    private static class IconKey {
        private String m_cls;
        private String m_key;

        private IconKey(String cls, String key) {
            this.m_cls = cls;
            this.m_key = key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof IconKey) {
                return ModelUtil.areEqual(((IconKey)obj).m_cls, this.m_cls) && ModelUtil.areEqual(((IconKey)obj).m_key, this.m_key);
            }
            return false;
        }

        public int hashCode() {
            return this.m_cls.hashCode() + this.m_key.hashCode();
        }

        public String toString() {
            return this.m_cls + ":" + this.m_key;
        }
    }
}

