/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.MessageFormat;
import java.util.Locale;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPLTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OraMessageFormat
extends MessageFormat {
    public OraMessageFormat(String pattern) {
        super(pattern);
    }

    public OraMessageFormat(String pattern, Locale locale) {
        super(pattern, locale);
    }

    public static String format(String pattern, Object ... arguments) {
        return OraMessageFormat.format(pattern, null, arguments);
    }

    public static String format(String pattern, DefaultNLSProvider nlsProvider, Object ... arguments) {
        OraMessageFormat temp = new OraMessageFormat(pattern);
        for (int i = 0; i < arguments.length; ++i) {
            try {
                if (arguments[i] instanceof NUMBER) {
                    arguments[i] = ((NUMBER)arguments[i]).bigDecimalValue();
                    continue;
                }
                if (arguments[i] instanceof DATE) {
                    arguments[i] = OraDATE.getInstance((DATE)arguments[i]).getTime();
                    continue;
                }
                if (arguments[i] instanceof TIMESTAMP) {
                    arguments[i] = OraTIMESTAMP.getInstance((TIMESTAMP)arguments[i]).getTime();
                    continue;
                }
                if (arguments[i] instanceof TIMESTAMPTZ) {
                    arguments[i] = OraTIMESTAMPTZ.getInstance((TIMESTAMPTZ)arguments[i]).getTime();
                    continue;
                }
                if (!(arguments[i] instanceof TIMESTAMPLTZ)) continue;
                if (nlsProvider != null) {
                    arguments[i] = OraTIMESTAMPLTZ.getInstance((TIMESTAMPLTZ)arguments[i], nlsProvider.getSessionTimeZone(), nlsProvider.getDatabaseTimeZone()).getTime();
                    continue;
                }
                arguments[i] = OraTIMESTAMPLTZ.getInstance((TIMESTAMPLTZ)arguments[i]).getTime();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return temp.format(arguments);
    }
}

