/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraTemporalDatumFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;

public class OraDATEFormat
extends OraTemporalDatumFormat {
    public OraDATEFormat(String pattern, OraLocaleInfo localeInfo) throws ParseException {
        this(pattern, localeInfo, null);
    }

    public OraDATEFormat(String pattern, OraLocaleInfo localeInfo, TimeZone sessionTimeZone) throws ParseException {
        super(pattern, localeInfo, sessionTimeZone);
    }

    @Override
    public void applyPattern(String pattern) throws ParseException {
        int cnt;
        int i;
        String uc = pattern.toUpperCase(Locale.US);
        StringBuffer pat = new StringBuffer(pattern);
        int pos = -1;
        pos = -1;
        while ((pos = uc.indexOf("FF", pos + 1)) >= 0) {
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraDATEFormat.7"), pos);
        }
        pos = -1;
        while ((pos = uc.indexOf("TZ", pos + 1)) >= 0 && pos <= uc.length() - 3) {
            char c = uc.charAt(pos + 2);
            if (c != 'R' && c != 'D' && c != 'H' && c != 'M') continue;
            i = -1;
            cnt = 0;
            while ((i = uc.indexOf(34, i + 1)) < pos && i != -1) {
                ++cnt;
            }
            if (cnt % 2 != 0) continue;
            throw new ParseException(Messages.getString("OraDATEFormat.9"), pos);
        }
        super.applyPattern(pat.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof OraDATEFormat && super.equals(object);
    }

    public String format(DATE date) {
        return this.format(date, new StringBuffer(), new FieldPosition(1000)).toString();
    }

    public StringBuffer format(DATE date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.formatTemporalDatum(OraDATE.getInstance(date), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null || obj instanceof DATE) {
            return this.format((DATE)obj, toAppendTo, pos);
        }
        throw new IllegalArgumentException(Messages.getString("OraDATEFormat.13"));
    }

    public DATE parse(String text, ParsePosition pos) {
        OraDATE temporalDatum = (OraDATE)this.parseTemporalDatum(text, pos, UTC);
        return temporalDatum != null ? temporalDatum.getDatum() : null;
    }

    @Override
    protected OraTemporalDatum getTemporalDatum(Calendar calendar, int nanos) {
        OraDATE ret = OraDATE.getInstance(calendar);
        ret.setSessionTimeZone(this.getSessionTimeZone());
        return ret;
    }
}

