/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowXquery
implements IShowCommand {
    private static final String[] SHOWXQUERY = new String[]{"xquery"};

    @Override
    public String[] getShowAliases() {
        return SHOWXQUERY;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowXquery(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowXquery(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn)).compareTo(new Version("10.2")) < 0) {
            ctx.write(Messages.getString("SERVER_VERSION_TOO_LOW"));
            return true;
        }
        String baseuri = (String)ctx.getProperty("xquery.baseuri");
        String order = (String)ctx.getProperty("xquery.ordering");
        String node = (String)ctx.getProperty("xquery.node");
        String context = (String)ctx.getProperty("xquery.context");
        if (baseuri == null) {
            baseuri = "";
        }
        if (!baseuri.startsWith("\"") || !baseuri.endsWith("\"")) {
            baseuri = "\"" + baseuri + "\"";
        }
        if (context == null || context.equals("''")) {
            context = "";
        }
        if (!context.startsWith("\"") || !context.endsWith("\"")) {
            context = "\"" + context + "\"";
        }
        if (order == null) {
            order = "DEFAULT";
        }
        if (node == null) {
            node = "DEFAULT";
        }
        ctx.write("xquery BASEURI " + baseuri + " CONTEXT " + context + " NODE " + node.toUpperCase() + " ORDERING " + order.toUpperCase() + "\n");
        return true;
    }
}

