/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowVerify
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWVERIFY = new String[]{"ver", "veri", "verif", "verify"};

    @Override
    public String[] getShowAliases() {
        return SHOWVERIFY;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowVerify(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowVerify(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isVerifyOn()) {
            ctx.write("verify ON\n");
        } else {
            ctx.write("verify OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String onoff = "OFF";
        if (ctx.isVerifyOn()) {
            onoff = "ON";
        }
        return StoreRegistry.getCommand("verify", onoff);
    }
}

