/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowUsercmd
implements IShowCommand {
    private static final String[] SHOWUSERCMD = new String[]{"user"};

    @Override
    public String[] getShowAliases() {
        return SHOWUSERCMD;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowUsercmd(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowUsercmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx != null && ctx.getProperty("script.runner.PRELIM_AUTH") != null && Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE)).booleanValue()) {
                ctx.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", "SYS")));
            } else if (conn == null) {
                ctx.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", "")));
            } else {
                ctx.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(MessageFormat.format(Messages.getString("SHOWUSER"), "USER", DBUtil.getInstance(conn).executeOracleReturnOneCol("select USER from dual", new HashMap()))));
            }
            ctx.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner("\n"));
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }
}

