/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowTermout
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWTERMOUT = new String[]{"term", "termo", "termou", "termout"};

    @Override
    public String[] getShowAliases() {
        return SHOWTERMOUT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowTermout(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowTermout(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean ctxSetting = ctx.isOutputSupressed();
        if (ctxSetting) {
            ctx.write("termout OFF\n");
        } else {
            ctx.write("termout ON\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Boolean isTimingOn = (Boolean)ctx.getProperty("script.runner.context.timing");
        if (isTimingOn != null && isTimingOn.equals(Boolean.TRUE)) {
            return StoreRegistry.getCommand("termout", "ON");
        }
        return StoreRegistry.getCommand("termout", "OFF");
    }
}

