/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowShowMode
implements IShowCommand {
    private static final String[] SHOWMODE = new String[]{"SHOWMODE", "showmode", "SHOW", "show"};

    @Override
    public String[] getShowAliases() {
        return SHOWMODE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowMode(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    public boolean doShowMode(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String onoroff = (String)ctx.getProperty("script.runner.setshowmode");
        String str = "";
        if (onoroff != null && onoroff.matches("(?i:on|off|both)")) {
            if (onoroff.equalsIgnoreCase("ON") || onoroff.equalsIgnoreCase("BOTH")) {
                str = Messages.getString("SHOWMODE_BOTH") + Show.m_lineSeparator;
            } else if (onoroff.equalsIgnoreCase("OFF")) {
                str = Messages.getString("SHOWMODE_OFF") + Show.m_lineSeparator;
            }
            ctx.write(str);
        } else {
            str = Messages.getString("SHOWMODE_OFF") + Show.m_lineSeparator;
            ctx.write(str);
        }
        return true;
    }
}

