/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class ShowNewPage
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWNEWPAGE = new String[]{"newpage"};

    @Override
    public String[] getShowAliases() {
        return SHOWNEWPAGE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty("script.runner.newpage") != null) {
            try {
                int np = Integer.parseInt(ctx.getProperty("script.runner.newpage").toString());
                ctx.write(MessageFormat.format("newpage {0}\n", np));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("newpage", String.valueOf(ctx.getProperty("script.runner.newpage")));
    }
}

