/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.jdbc.OracleConnection;

public class ShowDefine
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWDEFINE = new String[]{"def", "defi", "defin", "define"};

    @Override
    public String[] getShowAliases() {
        return SHOWDEFINE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowDefine(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowDefine(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getSubstitutionOn()) {
            String message = "define \"{0}\" (hex {1})\n";
            ctx.write(MessageFormat.format(message, Character.valueOf(ctx.getSubstitutionChar()), String.format("%x", ctx.getSubstitutionChar())));
        } else {
            ctx.write("define OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx.getSubstitutionOn()) {
            return StoreRegistry.getCommand("define", MessageFormat.format("\"{0}\"", Character.valueOf(ctx.getSubstitutionChar())));
        }
        return StoreRegistry.getCommand("define", "OFF");
    }
}

