/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.net;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.net.Net;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetParser;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;

public class NetEntries {
    public static final String CONFIGFILE = File.separator + "netEntries.xml";
    public static final String CONFIGBACK = File.separator + "netEntries.xml~";
    public static Object LOCK = new Object();
    private HashMap<String, Net> netEntries = new HashMap();
    private static NetEntries _INSTANCE;
    private Set<String> netEntriesUpper = new HashSet<String>();

    public static String getBase() {
        String storage = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            storage = appData != null ? appData + File.separator + "sdsql" : null;
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetEntries getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_INSTANCE == null) {
                _INSTANCE = new NetEntries();
                _INSTANCE.load();
            }
        }
        return _INSTANCE;
    }

    private NetEntries() {
        URL u = this.getClass().getClassLoader().getResource("oracle/dbtools/raptor/newscriptrunner/commands/net/netEntries.xml");
        NetParser parser = new NetParser();
        try {
            ArrayList<Net> filenetEntries = parser.processXML(u);
            for (Net a : filenetEntries) {
                this.netEntries.put(a.getName(), a);
                this.netEntriesUpper.add(a.getName().toUpperCase());
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public static ArrayList<String> getMatching(String stub) {
        return NetEntries.getMatching(stub, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getMatching(String stub, boolean withNetXml) {
        ArrayList<String> gold = new ArrayList<String>();
        boolean all = false;
        if (stub == null || stub.equals("")) {
            all = true;
        } else {
            stub = stub.toUpperCase();
        }
        Object object = LOCK;
        synchronized (object) {
            ArrayList<String> allNe;
            NetEntries ne = NetEntries.getInstance();
            HashSet<String> upper = new HashSet<String>();
            ArrayList<TCPTNSEntry> myTCPEntry = TNSHelper.getTNSEntries();
            if (myTCPEntry != null) {
                for (int i = 0; i < myTCPEntry.size(); ++i) {
                    String local = myTCPEntry.get(i).getName();
                    String localUpper = local.toUpperCase();
                    if (!all && !localUpper.startsWith(stub) || upper.contains(localUpper)) continue;
                    upper.add(localUpper);
                    gold.add(local);
                }
            }
            if (withNetXml && (allNe = ne.getNetEntries()) != null) {
                for (String local : allNe) {
                    String localUpper = local.toUpperCase();
                    if (!all && !localUpper.startsWith(stub) || upper.contains(localUpper)) continue;
                    upper.add(localUpper);
                    gold.add(local);
                }
            }
            Collections.sort(gold, String.CASE_INSENSITIVE_ORDER);
        }
        return gold;
    }

    public void add() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, String query, String desc) {
        Object object = LOCK;
        synchronized (object) {
            if (this.netEntriesUpper.contains(name.toUpperCase())) {
                this.removeIgnoreCase(name);
                this.netEntriesUpper.remove(name.toUpperCase());
            }
            Net net = new Net(name, query, desc);
            this.netEntries.put(name, net);
            this.netEntriesUpper.add(name.toUpperCase());
            this.save();
        }
    }

    public void removeIgnoreCase(String key) {
        ArrayList<String> al = new ArrayList<String>();
        for (String entry : this.netEntries.keySet()) {
            if (!entry.equalsIgnoreCase(key)) continue;
            al.add(entry);
        }
        for (String remove : al) {
            this.netEntries.remove(remove);
        }
    }

    public String getKeyIgnoreCase(String key) {
        for (String entry : this.netEntries.keySet()) {
            if (!entry.equalsIgnoreCase(key)) continue;
            return entry;
        }
        return null;
    }

    public void add(String name, String query) {
        this.add(name, query, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(String name) {
        Object object = LOCK;
        synchronized (object) {
            if (this.netEntriesUpper.contains(name.toUpperCase())) {
                this.removeIgnoreCase(name);
                this.netEntriesUpper.remove(name.toUpperCase());
                this.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getNetEntries() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = LOCK;
        synchronized (object) {
            for (String net : this.netEntries.keySet()) {
                list.add(net);
            }
        }
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Object object = LOCK;
        synchronized (object) {
            return this.netEntriesUpper.contains(key.toUpperCase());
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Object object = LOCK;
        synchronized (object) {
            Net net = this.netEntries.get(key);
            if (net != null) {
                return net.getQuery();
            }
            Set<String> sset = this.netEntries.keySet();
            for (String s : sset) {
                Net n2;
                if (!s.equalsIgnoreCase(key) || (n2 = this.netEntries.get(s)) == null) continue;
                return n2.getQuery();
            }
            return null;
        }
    }

    public String save() {
        return this.save(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(String filename) {
        ArrayList<Net> netEntriesAL = new ArrayList<Net>();
        String exceptionRet = null;
        Object object = LOCK;
        synchronized (object) {
            NetParser parser = new NetParser();
            try {
                String base = NetEntries.getBase();
                if (base == null) {
                    throw new Exception("NET-013 APPDATA is null");
                }
                if (base != null && !new File(base).exists() && !new File(base).mkdirs()) {
                    throw new Exception("NET-009 " + base + " Directory did not create");
                }
                File file = null;
                if (filename != null) {
                    file = new File(filename);
                } else {
                    filename = base + CONFIGFILE;
                    file = new File(filename);
                    if (base != null && new File(base + CONFIGFILE).exists()) {
                        if (new File(base + CONFIGBACK).exists() && !new File(base + CONFIGBACK).delete()) {
                            throw new Exception("NET-011 " + base + CONFIGBACK + " could not be deleted ");
                        }
                        try {
                            Files.move(Paths.get(base + CONFIGFILE, new String[0]), Paths.get(base + CONFIGBACK, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Exception e) {
                            throw new Exception("NET-010 " + base + CONFIGFILE + " could not be renamed to " + base + CONFIGBACK + " " + e.getMessage());
                        }
                    }
                }
                for (Map.Entry<String, Net> a : this.netEntries.entrySet()) {
                    Net al = a.getValue();
                    netEntriesAL.add(al);
                }
                if (base != null) {
                    parser.putXML(file, netEntriesAL);
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
                exceptionRet = e.getLocalizedMessage() + "\n";
            }
        }
        if (exceptionRet == null) {
            return MessageFormat.format("Net-007 - Net Entries saved to {0}\n", filename);
        }
        return exceptionRet;
    }

    public String load() {
        return this.load(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String load(String filename) {
        Object object = LOCK;
        synchronized (object) {
            block11: {
                File file = null;
                if (filename != null) {
                    file = new File(filename);
                } else {
                    String base = NetEntries.getBase();
                    if (base == null) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "NET-013 APPDATA is null\n");
                    }
                    filename = base + CONFIGFILE;
                    file = new File(filename);
                }
                NetParser parser = new NetParser();
                try {
                    if (file != null && file.exists()) {
                        URL u = file.toURI().toURL();
                        if (file.canRead()) {
                            ArrayList<Net> filenetes = parser.processXML(u);
                            for (Net a : filenetes) {
                                this.removeIgnoreCase(a.getName());
                                this.netEntries.put(a.getName(), a);
                                this.netEntriesUpper.add(a.getName().toUpperCase());
                            }
                            break block11;
                        }
                        return MessageFormat.format("NET-012 {0} could not be read.\n", filename);
                    }
                    return MessageFormat.format("NET-012 {0} could not be read.\n", filename);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                }
            }
        }
        return "";
    }
}

