/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.bridge;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeParser;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableCreationInfo;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeTableDef;
import oracle.dbtools.raptor.scriptrunner.Restricted;

@Restricted(level=Restricted.Level.REST)
public class BridgeCmd
extends CommandListener
implements IHelp {
    BridgeParser _bridgeParser = null;
    boolean _statusOK = true;

    @Override
    public String getCommand() {
        return "BRIDGE";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            this._statusOK = true;
            String str = cmd.getModifiedSQL();
            this._bridgeParser = null;
            this._bridgeParser = new BridgeParser(str);
            for (BridgeTableDef tableDef : this._bridgeParser.getTableDefs()) {
                tableDef.setDefaultConn(conn);
                tableDef.setScriptRunnerContext(ctx);
                this.saveInfo(tableDef.createTable(), ctx);
            }
        }
        catch (Exception e) {
            this.handleException(e, ctx);
            this._statusOK = false;
        }
    }

    private void saveInfo(BridgeTableCreationInfo info, ScriptRunnerContext ctx) {
        ctx.write(info.getReport());
        ArrayList<BridgeTableCreationInfo> scriptResults = (ArrayList<BridgeTableCreationInfo>)ctx.getProperty("script.runner.results");
        if (scriptResults == null) {
            scriptResults = new ArrayList<BridgeTableCreationInfo>();
            ctx.putProperty("script.runner.results", scriptResults);
        }
        scriptResults.add(info);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this._statusOK) {
            if (this._bridgeParser.getQuery() != null) {
                cmd.setSql(this._bridgeParser.getQuery());
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this._bridgeParser != null && this._bridgeParser.getQuery() != null) {
            for (BridgeTableDef tableDef : this._bridgeParser.getTableDefs()) {
                if (tableDef._isAppend) continue;
                tableDef.drop();
            }
        }
    }

    private void handleException(Exception e, ScriptRunnerContext ctx) {
        ctx.write("\n" + e.getMessage() + "\n");
        ctx.putProperty("sqldev.error", Boolean.TRUE);
        ctx.putProperty("sqldev.error.any.in", Boolean.TRUE);
        ctx.putProperty("sqldev.last.err.message", e.getMessage());
    }
}

