/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class XQuery
extends CommandListener {
    private static final String XQUERY_STUB = "{0}select column_value from xmltable({1})";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String baseuri = (String)ctx.getProperty("xquery.baseuri");
        String order = (String)ctx.getProperty("xquery.ordering");
        String node = (String)ctx.getProperty("xquery.node");
        String context = (String)ctx.getProperty("xquery.context");
        StringBuilder sb = new StringBuilder();
        if (baseuri != null) {
            sb.append("declare base-uri " + baseuri + ";");
        }
        if (context != null) {
            sb.append("declare CONTEXT " + context + ";");
        }
        if (node != null) {
            sb.append("declare node " + node + ";");
        }
        if (order != null) {
            sb.append("declare  ordering " + order + "; ");
        }
        cmd.setStmtClass(SQLCommand.StmtType.G_C_SQL);
        String cmdSQL = cmd.getSql();
        Pattern p = Pattern.compile("(?i)\\s*xquery\\s*;?\\s*");
        Matcher m = p.matcher(cmdSQL);
        int position = m.find() ? m.end() : 0;
        String selectSQL = cmdSQL.substring(position).trim();
        String newSQL = MessageFormat.format(XQUERY_STUB, sb.toString(), "'" + this.cleanString(selectSQL) + "'");
        cmd.setResultsType(SQLCommand.StmtResultType.G_R_QUERY);
        cmd.setSql(newSQL);
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    private String cleanString(String str) {
        StringBuilder newStr = new StringBuilder("");
        Character qt = Character.valueOf('\'');
        for (int i = 0; i < str.length(); ++i) {
            Character ch = Character.valueOf(str.charAt(i));
            newStr = ch.equals(qt) ? newStr.append("''") : newStr.append(ch);
        }
        return newStr.toString();
    }
}

