/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.sql.NUMBER;

public class Title
extends CommandListener
implements IStoreCommand {
    protected static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String LEFTPTRN = "(?i:\\bl(?:e|ef|eft)\\b)";
    private static final String LEFTCMDPTRN = "(?i:(?i:\\bl(?:e|ef|eft)\\b)\\s+(?:'[^']+'\\s+(?i:sql.pno)|'[^']+'|(?i:sql.pno)))";
    private static final String RIGHTPTRN = "(?i:\\br(?:|i|ig|igh|ight)\\b)";
    private static final String RIGHTCMDPTRN = "(?i:(?i:\\br(?:|i|ig|igh|ight)\\b)\\s+(?:\\'[^\\']+\\'\\s+(?i:sql.pno)|\\'[^\\']+\\'|(?i:sql.pno)))";
    private static final String CENTERPTRN = "(?i:\\bc(?:e|en|ent|ente|enter)\\b)";
    private static final String CENTERCMDPTRN = "(?i:(?i:\\bc(?:e|en|ent|ente|enter)\\b)\\s+(?:\\'[^\\']+\\'\\s+(?i:sql.pno)|\\'[^\\']+\\'|(?i:sql.pno)))";
    private static final String SKIPPTRN = "(?i:\\bs(?:|k|ki|kip)\\b)";
    private static final String SKIPPTRN_HAS_NUM = "(?i:\\bs(?:|k|ki|kip)\\d{1,2}\\b)";
    private static final String SKIPCMDPTRN = "(?i:(?i:\\bs(?:|k|ki|kip)\\b)(?:|\\s+)(?:\\d+|\\z))";
    private static final String FORMATPTRN = "(?i:\\bformat\\b)";
    private static final String COLPTRN = "(?i:\\bcol\\b)";
    private static final String COLCMDPTRN = "(?:(?i:\\bcol\\b)\\s+(?:|(?i:\\bformat\\b)\\s+)(?:'[^']+'|'[^']+'\\s+(?i:sql.pno)|.+))";
    private static final String FONTPTRN = "(?i:\\bfont\\b)";
    private static final String TABPTRN = "(?i:\\btab\\b)";
    private static final String JUSTIFY = "justify";
    private static final String COL = "col";
    private static final String TAB = "tab";
    private static final String FORMAT = "format";
    private static final String SKIP = "skip";
    private static final String SQLPNO = "SQL.PNO";
    private static final String SQLSCAN = "SQL.SCAN";
    private static final int SKIP_COLUMN_HEADER_LINES = 3;
    private static final String SQLPAGESIZE = "SQL.PAGESIZE";
    private static final String SQLUSER = "SQL.USER";
    private static final String SQLCASE = "SQL.CASE";
    private static final String SQLSQLCASE = "SQL.SQLCASE";
    private static final String SQLDEFINE = "SQL.DEFINE";
    private static final String SQLCMDSEP = "SQL.CMDSEP";
    private static final String SQLSQLPREFIX = "SQL.SQLPREFIX";
    private static final String SQLLINESIZE = "SQL.LINESIZE";
    private static final String SQLSQLCODE = "SQL.SQLCODE";
    private static final String SQLOSCODE = "SQL.OSCODE";
    private static final String SQLSPACE = "SQL.SPACE";
    private static final String SQLNUMFORMAT = "SQL.NUMFORMAT";
    private static final String SQLNUMWIDTH = "SQL.NUMWIDTH";
    private static final String SQLSUFFIX = "SQL.SUFFIX";
    private static final String SQLPREFIX = "SQL.PREFIX";
    private static final String SQLLNO = "SQL.LNO";
    private static final String SQLLOGSOURCE = "SQL.LOGSOURCE";
    private static final String SQLSPOOL = "SQL.SPOOL";
    private static final String SQLHEADING = "SQL.HEADING";
    private static final String SQLVERIFY = "SQL.VERIFY";
    private static final String SQLLONG = "SQL.LONG";
    private static final String SQLRELEASE = "SQL.RELEASE";
    private static final String SQLSQLPROMPT = "SQL.SQLPROMPT";
    private static final String SQLNULL = "SQL.NULL";
    private static final String SQLFEEDBACK = "SQL.FEEDBACK";
    private static final String SQLTERMOUT = "SQL.TERMOUT";
    private static final String SQLTIMING = "SQL.TIMING";
    private static final String SQLTRIMOUT = "SQL.TRIMOUT";
    private static final String SQLAUTORECOVERY = "SQL.AUTORECOVERY";
    private static final String SQLECHO = "SQL.ECHO";
    private static final String SQLHEADSEP = "SQL.HEADSEP";
    private static final String SQLWRAP = "SQL.WRAP";
    private static final String SQLESCAPE = "SQL.ESCAPE";
    private static final String SQLAUTOCOMMIT = "SQL.AUTOCOMMIT";
    private static final String SQLPAUSE = "SQL.PAUSE";
    private static final String EMPTYSTRING = "";
    private static final String ORA_SUBSTITUTION_MARKUP = "[ORA_SUB_MARKUP]";
    private static final String JUSTIFYPTRN = "(?:(?i:\\bl(?:e|ef|eft)\\b)|(?i:\\bc(?:e|en|ent|ente|enter)\\b)|(?i:\\br(?:|i|ig|igh|ight)\\b))";
    private static final String SCAN_ON = "ON";
    private static final String SCAN_OFF = "OFF";
    private static final String CURRPAGENO = "(?i:sql.pno)";
    private static final int LINESIZE = 80;
    private static final CharSequence SQL_DOT_SQL = "SQL.SQL";
    private static final CharSequence SQL_DOT_COMMAND = "SQL.COMMAND";
    protected String titleType = "GENERIC_TITLE";
    protected int m_linesize = -1;
    protected String m_titleCmd = "";
    protected String CMD = "";
    protected ArrayList<String> m_parsedList = null;
    protected Connection m_connection = null;
    protected String m_headsepchar = "";
    protected String m_scan = "";
    private int m_pagesize = -1;
    private String m_colsep = "";
    private String m_headsep = "";
    private String m_heading = "";
    private String m_wrap = "";
    private int m_numwidth = -1;
    private String m_numformat = "";
    private int m_long = -1;
    private String m_null = "";
    private int m_lno = -1;
    private String m_suffix = "";
    private Long m_autoCommit = -1L;
    private Boolean m_pause = Boolean.FALSE;

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    public StringBuffer getTitle(ScriptRunnerContext ctx, Integer pageNo, Map<String, String> subNewValueMap, Map<String, String> subOldValueMap, ArrayList<StringBuffer> row, String[] columns, String currentSql) {
        StringBuffer titleStr = new StringBuffer(EMPTYSTRING);
        LinkedHashMap<String, String> cmd_to_val = new LinkedHashMap<String, String>();
        this.m_parsedList = new ArrayList();
        this.m_headsepchar = (String)ctx.getProperty("script.runner.setheadsepchar");
        this.m_linesize = (Integer)ctx.getProperty("script.runner.setlinesize") + m_lineSeparator.length();
        this.m_scan = ctx.getScanOn() ? SCAN_ON : SCAN_OFF;
        this.m_lno = (Integer)ctx.getProperty("script.runner.lno");
        this.m_pagesize = (Integer)ctx.getProperty("script.runner.setpagesize");
        this.m_linesize = (Integer)ctx.getProperty("script.runner.setlinesize");
        this.m_scan = (String)ctx.getProperty("sql.scan");
        this.m_colsep = (String)ctx.getProperty("script.runner.setcolsep");
        this.m_headsep = (String)ctx.getProperty("script.runner.setheadsep");
        this.m_headsepchar = (String)ctx.getProperty("script.runner.setheadsepchar");
        this.m_heading = (String)ctx.getProperty("script.runner.setheading");
        this.m_wrap = (String)ctx.getProperty("script.runner.setwrap");
        this.m_long = (Integer)ctx.getProperty("script.runner.setlong");
        this.m_numwidth = (Integer)ctx.getProperty("script.runner.setnumwidth");
        this.m_numformat = (String)ctx.getProperty("script.runner.setnumformat");
        this.m_null = (String)ctx.getProperty("script.runner.setnull");
        this.m_autoCommit = (Long)ctx.getProperty("script.runner.autocommit.setting");
        this.m_pause = (Boolean)ctx.getProperty("script.runner.set_pause");
        if (this.m_linesize < 10) {
            this.m_linesize = 80 + m_lineSeparator.length();
        }
        if (this.m_linesize > 1) {
            String val;
            int i;
            titleStr.append(this.addLine());
            String titlCmd = this.m_titleCmd;
            if (titlCmd.length() > 0 && subNewValueMap != null && !subNewValueMap.isEmpty() && row != null && row.size() > 0 && columns != null) {
                for (i = 1; i < columns.length; ++i) {
                    val = subNewValueMap.get(columns[i]);
                    titlCmd = this.substituteColumnValues(val, row.get(i).toString(), titlCmd);
                }
            }
            if (titlCmd.length() > 0 && subOldValueMap != null && !subOldValueMap.isEmpty() && row != null && row.size() > 0 && columns != null) {
                for (i = 1; i < columns.length; ++i) {
                    val = subOldValueMap.get(columns[i]);
                    titlCmd = this.substituteColumnValues(val, row.get(i).toString(), titlCmd);
                }
            }
            if (titlCmd.length() == 0 && ctx.getTTitleFlag()) {
                titlCmd = "ttitle left _date right page sql.pno skip 1 center '" + currentSql + "'";
            }
            while (titlCmd.split("\\s+").length > 0 && titlCmd.length() > 0) {
                String[] cols;
                String n;
                String val2;
                String ptrn;
                String[] strs = this.splitStr(titlCmd);
                String str = strs[0];
                if (str.matches(JUSTIFYPTRN)) {
                    cmd_to_val.put(JUSTIFY, str);
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.matches(SKIPPTRN) || str.matches(SKIPPTRN_HAS_NUM)) {
                    ptrn = null;
                    val2 = null;
                    if (str.matches(SKIPPTRN_HAS_NUM)) {
                        ptrn = SKIPPTRN_HAS_NUM;
                        val2 = this.extractFirst(titlCmd, ptrn);
                        if (!val2.isEmpty()) {
                            String[] skipWord = val2.split("\\d+");
                            String skipNum = val2.substring(skipWord[0].length());
                            String n2 = skipNum.trim();
                            cmd_to_val.put(SKIP, n2);
                        }
                    } else {
                        ptrn = "(?i:\\bs(?:|k|ki|kip)\\b)\\s*(-?\\d)*";
                        val2 = this.extractFirst(titlCmd, ptrn);
                        if (!val2.isEmpty()) {
                            String[] skip = val2.split("\\s+");
                            if (skip.length == 2) {
                                n = skip[1];
                                cmd_to_val.put(SKIP, n);
                            } else {
                                cmd_to_val.put(SKIP, "0");
                            }
                        }
                    }
                    this.applyPrintSpec(titleStr, cmd_to_val, EMPTYSTRING);
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    if (val2.isEmpty()) {
                        titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                        continue;
                    }
                    titlCmd = titlCmd.substring(val2.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.matches(COLPTRN)) {
                    ptrn = "(?i:\\bcol\\b)\\s+\\d+";
                    val2 = this.extractFirst(titlCmd, ptrn);
                    if (!val2.isEmpty() && (cols = val2.split("\\s+")).length == 2) {
                        n = cols[1];
                        cmd_to_val.put(COL, n);
                    }
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    if (val2.isEmpty()) {
                        titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                        continue;
                    }
                    titlCmd = titlCmd.substring(val2.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.matches(FORMATPTRN)) {
                    String ptrn1 = "(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)";
                    String ptrn2 = "(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+.+\\s+(?i:sql.pno)";
                    String ptrn3 = ".+\\s+(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)";
                    String val3 = EMPTYSTRING;
                    String[] fmts = null;
                    String fmtstr = EMPTYSTRING;
                    String text = EMPTYSTRING;
                    if (titlCmd.matches(ptrn1)) {
                        val3 = this.extractFirst(titlCmd, ptrn1);
                        if (!val3.isEmpty()) {
                            fmts = val3.split("\\s+");
                            fmtstr = fmts[1];
                            text = this.getFormattedStr(pageNo.toString(), fmtstr);
                        }
                    } else if (titlCmd.matches(ptrn2)) {
                        val3 = this.extractFirst(titlCmd, ptrn2);
                        if (!val3.isEmpty()) {
                            text = titlCmd.replaceAll("(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+", EMPTYSTRING).trim();
                            text = text.replaceAll("\\s+(?i:sql.pno)", EMPTYSTRING).trim();
                            text = text.replaceAll("['\"]", EMPTYSTRING).trim();
                            fmts = val3.split("\\s+");
                            fmtstr = fmts[1];
                            text = text + this.getFormattedStr(pageNo.toString(), fmtstr);
                        }
                    } else if (titlCmd.matches(ptrn3) && !(val3 = this.extractFirst(titlCmd, ptrn3)).isEmpty()) {
                        text = titlCmd.replaceAll("\\s+(?i:\\bformat\\b)\\s+[\\w.,$\\d]+\\s+(?i:sql.pno)", EMPTYSTRING).trim();
                        text = text.replaceAll("['\"]", EMPTYSTRING).trim();
                        fmts = val3.split("\\s+");
                        fmtstr = fmts[2];
                        text = text + this.getFormattedStr(pageNo.toString(), fmtstr);
                    }
                    if (cmd_to_val.size() == 0) {
                        cmd_to_val.put(JUSTIFY, text);
                    }
                    this.applyPrintSpec(titleStr, cmd_to_val, text);
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    if (val3.isEmpty()) {
                        titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                        continue;
                    }
                    titlCmd = titlCmd.substring(val3.length(), titlCmd.length()).trim();
                    continue;
                }
                if (this.CheckForUnsuppottedCmds(str)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, EMPTYSTRING);
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLLNO)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_lno));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLPNO)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, pageNo.toString());
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLSCAN)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, this.m_scan);
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLPAGESIZE)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, new Integer(this.m_pagesize).toString());
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLNUMFORMAT)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, this.m_numformat);
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLNUMWIDTH)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_numwidth));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLLINESIZE)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_linesize));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLLONG)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_long));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLNULL)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_null));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLSUFFIX)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_suffix));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLHEADING)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_heading));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLHEADSEP)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_headsep));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLWRAP)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_wrap));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLAUTOCOMMIT)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_autoCommit));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.equalsIgnoreCase(SQLPAUSE)) {
                    this.applyPrintSpec(titleStr, cmd_to_val, String.valueOf(this.m_pause));
                    cmd_to_val.clear();
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.matches(FONTPTRN)) {
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                    continue;
                }
                if (str.matches(TABPTRN)) {
                    ptrn = "(?i:\\btab\\b)\\s+\\d+";
                    val2 = this.extractFirst(titlCmd, ptrn);
                    if (!val2.isEmpty() && (cols = val2.split("\\s+")).length == 2) {
                        n = cols[1];
                        cmd_to_val.put(TAB, n);
                    }
                    if (str.equals(titlCmd)) {
                        titlCmd = EMPTYSTRING;
                        continue;
                    }
                    if (val2.isEmpty()) {
                        titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                        continue;
                    }
                    titlCmd = titlCmd.substring(val2.length(), titlCmd.length()).trim();
                    continue;
                }
                String text = EMPTYSTRING;
                if (str.equalsIgnoreCase("_date")) {
                    text = ctx.getDate(str);
                } else if (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
                    String[] modifiedStrings;
                    if (str.contains("\"\"")) {
                        modifiedStrings = this.appendLookahead(titlCmd, ctx);
                        text = modifiedStrings[0];
                        text = text.replaceAll("\"\"", "\"");
                        titlCmd = modifiedStrings[1];
                        str = EMPTYSTRING;
                    } else if (str.contains("''")) {
                        modifiedStrings = this.appendLookahead(titlCmd, ctx);
                        text = modifiedStrings[0];
                        text = text.replaceAll("''", "'");
                        titlCmd = modifiedStrings[1];
                        str = EMPTYSTRING;
                    } else {
                        modifiedStrings = this.appendLookahead(titlCmd, ctx);
                        text = modifiedStrings[0];
                        text = text.contains("''") ? text.replaceAll("''", "'") : text.replaceAll("'", EMPTYSTRING);
                        text = text.contains("\"") ? text.replaceAll("\"\"", "\"") : text.replaceAll("\"", EMPTYSTRING);
                        titlCmd = modifiedStrings[1];
                        str = EMPTYSTRING;
                    }
                } else {
                    Map<String, String> map = ctx.getMap();
                    text = map.get(str);
                    if (text == null || text.isEmpty()) {
                        String[] modifiedStrings = this.appendLookahead(titlCmd, ctx);
                        text = modifiedStrings[0];
                        titlCmd = modifiedStrings[1];
                        str = EMPTYSTRING;
                    }
                }
                String[] tcmds = this.splitStr(titlCmd);
                if (tcmds != null && tcmds.length > 0) {
                    String[] fmts;
                    String val4;
                    String regexp;
                    String currentCommand = tcmds[0];
                    if (this.CheckForUnsuppottedCmds(currentCommand)) {
                        text = text + EMPTYSTRING;
                        if (currentCommand.equals(titlCmd)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLLNO)) {
                        regexp = str + "\\s+(?i:sql.lno)";
                        text = text + "          " + pageNo.toString();
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLPNO)) {
                        regexp = str + "\\s+(?i:sql.pno)";
                        text = text + "          " + pageNo.toString();
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLSCAN)) {
                        regexp = str + "\\s+(?i:sql.scan)";
                        text = text + "  " + this.m_scan;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLPAGESIZE)) {
                        regexp = str + "\\s+(?i:sql.pagesize)";
                        text = text + "  " + this.m_pagesize;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLNUMFORMAT)) {
                        regexp = str + "\\s+(?i:sql.numformat)";
                        text = text + "  " + this.m_numformat;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLNUMWIDTH)) {
                        regexp = str + "\\s+(?i:sql.numwidth)";
                        text = text + "  " + this.m_numwidth;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLLINESIZE)) {
                        regexp = str + "\\s+(?i:sql.linesize)";
                        text = text + "  " + this.m_linesize;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLLONG)) {
                        regexp = str + "\\s+(?i:sql.long)";
                        text = text + "  " + this.m_long;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLNULL)) {
                        regexp = str + "\\s+(?i:sql.null)";
                        text = text + "  " + this.m_null;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLSUFFIX)) {
                        regexp = str + "\\s+(?i:sql.suffix)";
                        text = text + "  " + this.m_suffix;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLHEADING)) {
                        regexp = str + "\\s+(?i:sql.heading)";
                        text = text + "  " + this.m_heading;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLHEADSEP)) {
                        regexp = str + "\\s+(?i:sql.headsep)";
                        text = text + "  " + this.m_headsep;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLWRAP)) {
                        regexp = str + "\\s+(?i:sql.wrap)";
                        text = text + "  " + this.m_wrap;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLAUTOCOMMIT)) {
                        regexp = str + "\\s+(?i:sql.autocommit)";
                        text = text + "  " + this.m_autoCommit;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(SQLPAUSE)) {
                        regexp = str + "\\s+(?i:sql.pause)";
                        text = text + "  " + this.m_pause;
                        if (currentCommand.equals(titlCmd) || titlCmd.matches(regexp)) {
                            titlCmd = EMPTYSTRING;
                        } else {
                            str = EMPTYSTRING;
                            titlCmd = titlCmd.substring(currentCommand.length(), titlCmd.length()).trim();
                        }
                    } else if (currentCommand.equalsIgnoreCase(FORMAT) && !(val4 = this.extractFirst(titlCmd, regexp = "(?i:\\bformat\\b)\\s+[\\w.,$]+\\s+(?i:sql.pno)")).isEmpty() && (fmts = val4.split("\\s+")).length == 3) {
                        String fmtstr = fmts[1];
                        String pageno = pageNo.toString();
                        String txt = this.getFormattedStr(pageno, fmtstr);
                        text = text + txt;
                        titlCmd = val4.equals(titlCmd) ? EMPTYSTRING : (val4.isEmpty() ? titlCmd.substring(currentCommand.length(), titlCmd.length()).trim() : titlCmd.substring(val4.length(), titlCmd.length()).trim());
                    }
                }
                if (cmd_to_val.size() == 0) {
                    cmd_to_val.put(JUSTIFY, text);
                }
                if (str.equals(titlCmd)) {
                    titlCmd = EMPTYSTRING;
                } else if (titlCmd.length() > 0) {
                    titlCmd = titlCmd.substring(str.length(), titlCmd.length()).trim();
                }
                if (cmd_to_val.isEmpty() && text.length() > 0) {
                    titleStr.append(text);
                    continue;
                }
                this.applyPrintSpec(titleStr, cmd_to_val, text);
                cmd_to_val.clear();
            }
        }
        if (!titleStr.toString().endsWith(m_lineSeparator)) {
            titleStr.append(m_lineSeparator);
        }
        return titleStr;
    }

    private String[] appendLookahead(String titleCommand, ScriptRunnerContext ctx) {
        String truncatedTitleCommand = titleCommand;
        String[] modifiedStrings = new String[2];
        StringBuffer sb = new StringBuffer();
        String[] lookAheadTokens = this.splitStr(titleCommand);
        boolean tokenMarkedUp = false;
        String markedUpToken = null;
        for (String lookheadToken : lookAheadTokens) {
            if (this.testCoreKeyword(lookheadToken)) break;
            if (lookheadToken.startsWith("'") && lookheadToken.endsWith("'")) {
                if (lookheadToken.length() > 1) {
                    if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                        tokenMarkedUp = true;
                        markedUpToken = lookheadToken;
                        lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                    } else {
                        tokenMarkedUp = false;
                        markedUpToken = null;
                    }
                    sb.append(lookheadToken.subSequence(1, lookheadToken.length() - 1));
                }
            } else if (lookheadToken.startsWith("'") && !lookheadToken.endsWith("'")) {
                if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                    tokenMarkedUp = true;
                    markedUpToken = lookheadToken;
                    lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                } else {
                    tokenMarkedUp = false;
                    markedUpToken = null;
                }
                sb.append(lookheadToken.subSequence(1, lookheadToken.length()));
            } else if (!lookheadToken.startsWith("'") && lookheadToken.endsWith("'")) {
                if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                    tokenMarkedUp = true;
                    markedUpToken = lookheadToken;
                    lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                } else {
                    tokenMarkedUp = false;
                    markedUpToken = null;
                }
                sb.append(lookheadToken.subSequence(0, lookheadToken.length() - 1));
            } else if (lookheadToken.startsWith("\"") && lookheadToken.endsWith("\"")) {
                if (lookheadToken.length() > 1) {
                    if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                        tokenMarkedUp = true;
                        markedUpToken = lookheadToken;
                        lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                    } else {
                        tokenMarkedUp = false;
                        markedUpToken = null;
                    }
                    sb.append(lookheadToken.subSequence(1, lookheadToken.length() - 1));
                }
            } else if (lookheadToken.startsWith("\"") && !lookheadToken.endsWith("\"")) {
                if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                    tokenMarkedUp = true;
                    markedUpToken = lookheadToken;
                    lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                } else {
                    tokenMarkedUp = false;
                    markedUpToken = null;
                }
                sb.append(lookheadToken.subSequence(1, lookheadToken.length()));
            } else if (!lookheadToken.startsWith("\"") && lookheadToken.endsWith("\"")) {
                if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                    tokenMarkedUp = true;
                    markedUpToken = lookheadToken;
                    lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                } else {
                    tokenMarkedUp = false;
                    markedUpToken = null;
                }
                sb.append(lookheadToken.subSequence(0, lookheadToken.length() - 1));
            } else {
                if (this.hasSubstituitionOraMarkup(lookheadToken)) {
                    tokenMarkedUp = true;
                    markedUpToken = lookheadToken;
                    lookheadToken = " " + this.removeSubstituitionOraMarkup(lookheadToken);
                } else {
                    tokenMarkedUp = false;
                    markedUpToken = null;
                }
                sb.append(lookheadToken);
            }
            truncatedTitleCommand = tokenMarkedUp && markedUpToken != null ? truncatedTitleCommand.substring(markedUpToken.length(), truncatedTitleCommand.length()).trim() : truncatedTitleCommand.substring(lookheadToken.length(), truncatedTitleCommand.length()).trim();
        }
        modifiedStrings[0] = sb.toString();
        modifiedStrings[1] = truncatedTitleCommand;
        return modifiedStrings;
    }

    private void applyPrintSpec(StringBuffer titleStr, LinkedHashMap<String, String> printspec, String text) {
        int lines = titleStr.toString().split(m_lineSeparator).length;
        if (printspec != null) {
            for (Map.Entry<String, String> entry : printspec.entrySet()) {
                String ps_key = entry.getKey();
                String ps_val = entry.getValue();
                String hs_text = this.applyHeadSep(text.trim());
                if (ps_key.equals(JUSTIFY)) {
                    String val = EMPTYSTRING;
                    val = ps_val.matches(LEFTPTRN) ? this.justify_left(hs_text, this.m_linesize - m_lineSeparator.length()) : (ps_val.matches(CENTERPTRN) ? this.justify_center(hs_text, this.m_linesize - m_lineSeparator.length()) : (ps_val.matches(RIGHTPTRN) ? this.justify_right(hs_text, this.m_linesize - m_lineSeparator.length()) : this.justify_left(hs_text, this.m_linesize)));
                    int idx = val.indexOf(hs_text);
                    if (idx < 0 || lines <= 0) continue;
                    int startValIndex = idx;
                    int endValIndex = startValIndex + hs_text.length();
                    if (lines > 1) {
                        if (hs_text.contains(m_lineSeparator)) {
                            String[] sub_hs_texts = hs_text.split(m_lineSeparator);
                            for (int i = 0; i < sub_hs_texts.length; ++i) {
                                if (i > 0) {
                                    titleStr.append(this.addLine());
                                }
                                String sub_hs_text = sub_hs_texts[i].trim();
                                int titleStrLen = titleStr.capacity();
                                int rowId = (lines + i - 1) * this.m_linesize;
                                int startValueIndex4 = rowId + startValIndex;
                                int endValueIndex4 = startValueIndex4 + sub_hs_text.length();
                                titleStr.replace(startValueIndex4, endValueIndex4, sub_hs_texts[i].trim());
                            }
                            continue;
                        }
                        int startValueIndex2 = startValIndex + (lines - 1) * this.m_linesize;
                        int endValueIndex2 = endValIndex + (lines - 1) * this.m_linesize;
                        titleStr.replace(startValueIndex2, endValueIndex2, hs_text);
                        continue;
                    }
                    if (hs_text.contains(m_lineSeparator)) {
                        String[] sub_hs_texts = hs_text.split(m_lineSeparator);
                        for (int i = 0; i < sub_hs_texts.length; ++i) {
                            if (i > 0) {
                                titleStr.append(this.addLine());
                            }
                            String sub_hs_text = sub_hs_texts[i].trim();
                            int rowId = i * this.m_linesize;
                            int startValueIndex4 = rowId + startValIndex;
                            int endValueIndex4 = startValueIndex4 + sub_hs_text.length();
                            titleStr.replace(startValueIndex4, endValueIndex4, sub_hs_texts[i].trim());
                        }
                        continue;
                    }
                    titleStr.replace(startValIndex, endValIndex, hs_text);
                    continue;
                }
                if (ps_key.equals(COL) || ps_key.equals(TAB)) {
                    int idx = new Integer(ps_val);
                    int minIdx = this.m_linesize * (lines - 1);
                    int maxIdx = minIdx + this.m_linesize - (m_lineSeparator.length() + 1);
                    int findIdx = titleStr.indexOf(hs_text);
                    if (findIdx > -1 && findIdx >= minIdx && findIdx <= maxIdx && hs_text != null && !hs_text.equals(EMPTYSTRING)) {
                        String blankStr = String.format("%1$-" + hs_text.length() + "s", EMPTYSTRING);
                        titleStr.replace(findIdx, findIdx + hs_text.length(), blankStr);
                    } else if (ps_key.equals(TAB)) {
                        titleStr.replace(minIdx + idx, minIdx + idx + hs_text.length(), hs_text);
                    } else {
                        int startIndex = minIdx + (idx - 1);
                        int endIndex = minIdx + (idx - 1) + hs_text.length();
                        int titleStrSize = titleStr.capacity();
                        if (idx >= titleStrSize) {
                            int numLines = idx % titleStrSize;
                            for (int i = 0; i < numLines; ++i) {
                                titleStr.append(this.addLine());
                            }
                        }
                        titleStr.replace(startIndex, endIndex, hs_text);
                    }
                    if (idx < minIdx || idx > maxIdx) continue;
                    if (idx + hs_text.length() <= maxIdx) {
                        if (ps_key.equals(TAB)) {
                            titleStr.replace(idx, idx + hs_text.length(), hs_text);
                            continue;
                        }
                        titleStr.replace(idx - 1, idx - 1 + hs_text.length(), hs_text);
                        continue;
                    }
                    int diff = maxIdx - idx;
                    String trnc_txt = hs_text.substring(0, diff);
                    titleStr.replace(idx - 1, idx - 1 + trnc_txt.length(), trnc_txt);
                    continue;
                }
                if (!ps_key.equals(SKIP)) continue;
                int val = new Integer(ps_val);
                if (val < 0) {
                    titleStr.append(this.addLine());
                    String negativeSkipValue = Integer.toString(val);
                    titleStr.replace(0, negativeSkipValue.length(), negativeSkipValue);
                    continue;
                }
                if (val == 0 || val == 1) {
                    titleStr.append(this.addLine());
                    continue;
                }
                int effectiveSkipLines = this.m_pagesize - 3;
                if (val >= effectiveSkipLines) {
                    val = effectiveSkipLines;
                }
                for (int i = 0; i < val; ++i) {
                    titleStr.append(this.addLine());
                }
            }
        }
    }

    protected String extractFirst(String fromStr, String regexp) {
        Matcher m;
        String retval = EMPTYSTRING;
        Pattern ptrn = Pattern.compile(regexp);
        if (ptrn != null && (m = ptrn.matcher(fromStr)) != null && m.find()) {
            retval = m.group();
        }
        return retval;
    }

    private String[] splitStr(String titleCmd) {
        String regex = null;
        String[] results = null;
        String regexWord = "\\\\|/|\\{|\\}|\\[|\\]|<|>|,|\\+|\\^|\\)|\\(|@|&|\\$|!|%|\\?|#|;|:|\\*|\\.|=|-|_|\\w|\\d|(-?\\d+)|\\" + this.m_headsepchar;
        String regexWordSpace = "\\s|" + regexWord;
        String regexDoubleQuote = "\"[" + regexWordSpace + "]*(\"{2})*[" + regexWordSpace + "]*\"|[" + regexWord + "]+";
        String regexSingleQuote = "'[" + regexWordSpace + "]*('{2})*[" + regexWordSpace + "]*'|[" + regexWord + "]+";
        regex = titleCmd.contains("\"") ? regexDoubleQuote : regexSingleQuote;
        ArrayList<String> matches = new ArrayList<String>();
        Pattern ptrn = Pattern.compile(regex);
        if (ptrn != null) {
            Matcher m = ptrn.matcher(titleCmd);
            if (m != null) {
                while (m.find()) {
                    String group = m.group();
                    matches.add(group);
                }
            }
            if (matches.size() > 0) {
                results = matches.toArray(new String[matches.size()]);
            }
        }
        return results;
    }

    private boolean testCoreKeyword(String result) {
        String resultTemp = result.trim();
        return resultTemp.equalsIgnoreCase("LEFT") || resultTemp.equalsIgnoreCase("LE") || resultTemp.equalsIgnoreCase("RIGHT") || resultTemp.equalsIgnoreCase("R") || resultTemp.equalsIgnoreCase("CENTER") || resultTemp.equalsIgnoreCase("CE") || resultTemp.equalsIgnoreCase("SKIP") || resultTemp.equalsIgnoreCase("S") || this.validateSkip(resultTemp) || resultTemp.equalsIgnoreCase("TAB") || resultTemp.equalsIgnoreCase("COL") || resultTemp.equalsIgnoreCase("FORMAT") || resultTemp.equalsIgnoreCase("BOLD") || resultTemp.equalsIgnoreCase(SCAN_ON) || resultTemp.equalsIgnoreCase(SCAN_OFF) || resultTemp.equalsIgnoreCase(SQLPNO) || resultTemp.equalsIgnoreCase(SQLSCAN) || resultTemp.equalsIgnoreCase(SQLLONG) || resultTemp.equalsIgnoreCase(SQLLINESIZE) || resultTemp.equalsIgnoreCase(SQLSQLCODE) || resultTemp.equalsIgnoreCase(SQLOSCODE) || resultTemp.equalsIgnoreCase(SQLNUMWIDTH) || resultTemp.equalsIgnoreCase(SQLNUMFORMAT) || resultTemp.equalsIgnoreCase(SQLLNO) || resultTemp.equalsIgnoreCase(SQLSQLPROMPT) || resultTemp.equalsIgnoreCase(SQLNULL) || resultTemp.equalsIgnoreCase(SQLSUFFIX) || resultTemp.equalsIgnoreCase(SQLPREFIX) || resultTemp.equalsIgnoreCase(SQLSQLPREFIX) || resultTemp.equalsIgnoreCase(SQLLOGSOURCE) || resultTemp.equalsIgnoreCase(SQLFEEDBACK) || resultTemp.equalsIgnoreCase(SQLHEADING) || resultTemp.equalsIgnoreCase(SQLSPACE) || resultTemp.equalsIgnoreCase(SQLVERIFY) || resultTemp.equalsIgnoreCase(SQLTERMOUT) || resultTemp.equalsIgnoreCase(SQLTRIMOUT) || resultTemp.equalsIgnoreCase(SQLTIMING) || resultTemp.equalsIgnoreCase(SQLWRAP) || resultTemp.equalsIgnoreCase(SQLUSER) || resultTemp.equalsIgnoreCase(SQLSQLCASE) || resultTemp.equalsIgnoreCase(SQLPAGESIZE) || resultTemp.equalsIgnoreCase(SQLAUTORECOVERY) || resultTemp.equalsIgnoreCase(SQLDEFINE) || resultTemp.equalsIgnoreCase(SQLESCAPE) || resultTemp.equalsIgnoreCase(SQLECHO) || resultTemp.equalsIgnoreCase(SQLCMDSEP) || resultTemp.equalsIgnoreCase(SQLPAUSE) || resultTemp.equalsIgnoreCase(SQLESCAPE) || resultTemp.equalsIgnoreCase(SQLHEADSEP) || resultTemp.equalsIgnoreCase(SQLSQLPREFIX) || resultTemp.equalsIgnoreCase(SQLAUTOCOMMIT) || resultTemp.equalsIgnoreCase(SQLPAUSE) || resultTemp.equalsIgnoreCase(SQLCMDSEP);
    }

    private boolean CheckForUnsuppottedCmds(String param) {
        return param.equalsIgnoreCase(SQLPREFIX) || param.equalsIgnoreCase(SQLSQLPREFIX) || param.equalsIgnoreCase(SQLCMDSEP) || param.equalsIgnoreCase(SQLSPACE) || param.equalsIgnoreCase(SQLDEFINE) || param.equalsIgnoreCase(SQLCASE) || param.equalsIgnoreCase(SQLSQLCASE) || param.equalsIgnoreCase(SQLUSER) || param.equalsIgnoreCase(SQLSQLCASE) || param.equalsIgnoreCase(SQLTRIMOUT) || param.equalsIgnoreCase(SQLTIMING) || param.equalsIgnoreCase(SQLTERMOUT) || param.equalsIgnoreCase(SQLVERIFY) || param.equalsIgnoreCase(SQLSPOOL) || param.equalsIgnoreCase(SQLLOGSOURCE) || param.equalsIgnoreCase(SQLFEEDBACK) || param.equalsIgnoreCase(SQLOSCODE) || param.equalsIgnoreCase(SQLSQLCODE) || param.equalsIgnoreCase(SQLECHO) || param.equalsIgnoreCase(SQLSQLPROMPT) || param.equalsIgnoreCase(SQLESCAPE) || param.equalsIgnoreCase(SQLRELEASE) || param.equalsIgnoreCase(SQLAUTORECOVERY);
    }

    private boolean validateSkip(String resultTemp) {
        return (resultTemp.startsWith(SKIP) || resultTemp.startsWith("SKIP")) && this.isInteger(resultTemp = resultTemp.substring(4, resultTemp.length()).trim());
    }

    private boolean isInteger(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }

    private String applyHeadSep(String text) {
        String str = EMPTYSTRING;
        StringTokenizer stnzr = new StringTokenizer(text, this.m_headsepchar);
        while (stnzr.hasMoreTokens()) {
            String token = stnzr.nextToken().trim();
            str = token.length() > this.m_linesize ? str + token.substring(0, this.m_linesize) : str + token;
            if (!stnzr.hasMoreTokens()) continue;
            str = str + m_lineSeparator;
        }
        if (str.length() == 0) {
            str = text;
        } else {
            if (str.startsWith("'") || str.startsWith("\"")) {
                str = str.substring(1);
            }
            if (str.endsWith("'") || str.endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    private void skip(StringBuffer titleStr, String cmdPtrn, String stripPtrn) {
        String match = this.getMatch(cmdPtrn);
        if (match != null && !match.isEmpty()) {
            match = match.trim().replaceAll(stripPtrn, EMPTYSTRING).trim();
            match = match.replaceAll("['\"]", EMPTYSTRING);
            boolean isDigit = false;
            boolean bl = isDigit = match.equals(EMPTYSTRING) ? false : Pattern.matches("^\\d*$", match);
            if (isDigit) {
                int val = new Integer(match);
                if (val <= 1) {
                    titleStr.append(this.addLine());
                } else {
                    for (int i = 0; i < val; ++i) {
                        titleStr.append(this.addLine());
                    }
                }
            } else {
                titleStr.append(this.addLine());
            }
        }
    }

    private void justify(StringBuffer titleStr, String cmdPtrn, String stripPtrn, Integer pageNo) {
        String val = EMPTYSTRING;
        String match = this.getMatch(cmdPtrn);
        if (match != null && !match.isEmpty()) {
            match = match.trim().replaceAll(stripPtrn, EMPTYSTRING).trim();
            int sqlpidx = (match = match.replaceAll("['\"]", EMPTYSTRING)).toUpperCase().indexOf(SQLPNO);
            if (sqlpidx > 0) {
                match = match.replaceAll(CURRPAGENO, "     " + pageNo.toString());
            }
            val = cmdPtrn.equals(LEFTCMDPTRN) ? this.justify_left(match, this.m_linesize - m_lineSeparator.length()) : (cmdPtrn.equals(RIGHTCMDPTRN) ? this.justify_right(match, this.m_linesize - m_lineSeparator.length()) : (cmdPtrn.equals(CENTERCMDPTRN) ? this.justify_center(match, this.m_linesize - m_lineSeparator.length()) : this.justify_left(match, this.m_linesize)));
            int idx = val.indexOf(match);
            int lines = titleStr.toString().split(m_lineSeparator).length;
            if (idx >= 0 && lines > 0) {
                int start = idx + this.m_linesize * (lines - 1);
                int end = start + match.length();
                titleStr.replace(start, end, match);
            }
        }
    }

    private void col(StringBuffer titleStr, String cmdPtrn, String stripPtrn, Integer pageNo) {
        int lines = titleStr.toString().split(m_lineSeparator).length;
        int minIdx = this.m_linesize * (lines - 1);
        int maxIdx = minIdx + this.m_linesize - (m_lineSeparator.length() + 1);
        String match = this.getMatch(cmdPtrn);
        if (match != null && !match.isEmpty()) {
            String[] colcmds = match.split("(?:\\s+|['\"].+['\"])");
            if (colcmds.length >= 3) {
                boolean isDigit = false;
                int idx = 0;
                String ttext = EMPTYSTRING;
                String fmtstr = EMPTYSTRING;
                String append_pageno = EMPTYSTRING;
                for (int i = 1; i < colcmds.length; ++i) {
                    isDigit = colcmds[i].matches("^\\d+$");
                    if (isDigit) {
                        idx = new Integer(colcmds[i]) - 1;
                        continue;
                    }
                    if (colcmds[i].equalsIgnoreCase(FORMAT)) {
                        fmtstr = colcmds[++i];
                        continue;
                    }
                    if (colcmds[i].equalsIgnoreCase("sql.pno")) {
                        String temp = this.getFormattedStr(pageNo.toString(), fmtstr);
                        append_pageno = "     ";
                        ttext = ttext + append_pageno + temp;
                        continue;
                    }
                    ttext = ttext + colcmds[i];
                }
                Matcher matcher = Pattern.compile("['\"].+['\"]").matcher(match);
                if (matcher.find()) {
                    String qtd_txt = matcher.group();
                    ttext = qtd_txt + ttext;
                }
                ttext = ttext.replaceAll("['\"]", EMPTYSTRING);
                ttext = this.getFormattedStr(ttext, fmtstr);
                ttext = append_pageno + ttext;
                if (idx >= minIdx && idx <= maxIdx) {
                    if (idx + ttext.length() <= maxIdx) {
                        titleStr.replace(idx, idx + ttext.length(), ttext);
                    } else {
                        int diff = maxIdx - idx;
                        String trnc_txt = ttext.substring(0, diff);
                        titleStr.replace(idx, idx + trnc_txt.length(), trnc_txt);
                    }
                }
            }
        } else {
            return;
        }
    }

    private String getMatch(String cmdPtrn) {
        String match = EMPTYSTRING;
        Pattern ptrn = Pattern.compile(cmdPtrn);
        if (ptrn != null) {
            Matcher matcher = ptrn.matcher(this.m_titleCmd);
            while (matcher.find()) {
                match = matcher.group();
                if (this.m_parsedList.size() == 0) {
                    this.m_parsedList.add(match);
                    break;
                }
                if (this.m_parsedList.contains(match)) continue;
                this.m_parsedList.add(match);
                break;
            }
        }
        return match;
    }

    private String addLine() {
        String retval = EMPTYSTRING;
        retval = this.justify_left(" ", this.m_linesize - m_lineSeparator.length());
        retval = retval + m_lineSeparator;
        return retval;
    }

    private String justify_left(String str, int width) {
        return String.format("%1$-" + width + "s", str);
    }

    private String justify_right(String str, int width) {
        return String.format("%1$" + width + "s", str);
    }

    private String justify_center(String str, int width) {
        String val = str.trim();
        if (width < val.length()) {
            return str;
        }
        int lenR = (width - val.length()) / 2 + val.length();
        String strR = String.format("%1$" + lenR + "s", val);
        String ret = String.format("%1$-" + width + "s", strR);
        return ret;
    }

    private String getFormattedStr(String str, String fmtstr) {
        String ret = str;
        if (fmtstr.startsWith("a") || fmtstr.startsWith("A")) {
            String strlen = fmtstr.replaceAll("^\\D*", EMPTYSTRING).trim();
            ret = this.justify_left(ret, new Integer(strlen));
        } else {
            NUMBER num = new NUMBER(new Integer(ret).intValue());
            try {
                ret = num.toFormattedText(fmtstr, null);
            }
            catch (Exception ex) {
                ret = num.stringValue();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFormattedNumber(Connection conn, NUMBER number, String fmtstr) {
        String retval = EMPTYSTRING;
        ResultSet rset = null;
        String sql = "SELECT TO_CHAR(";
        sql = sql + number.stringValue() + ",";
        sql = sql + "'" + fmtstr + "') from dual";
        if (conn == null || sql.equals(EMPTYSTRING)) return retval;
        try {
            DBUtil dbutil = DBUtil.getInstance(conn);
            rset = dbutil.executeOracleQuery(sql, null);
            while (rset.next()) {
                retval = rset.getString(1);
            }
            if (rset == null) return retval;
        }
        catch (Exception ex) {
            try {
                retval = DataTypesUtil.stringValue(number, conn);
                if (rset == null) return retval;
            }
            catch (Throwable throwable) {
                if (rset == null) throw throwable;
                DBUtil.closeResultSet(rset);
                throw throwable;
            }
            DBUtil.closeResultSet(rset);
            return retval;
        }
        DBUtil.closeResultSet(rset);
        return retval;
    }

    public String getCommand() {
        return this.m_titleCmd;
    }

    public String buildShowTitle(Title title, ScriptRunnerContext ctx) {
        String str = EMPTYSTRING;
        String tCmd = EMPTYSTRING;
        boolean flag = false;
        if (title instanceof TopTitle) {
            str = "ttitle";
            flag = ctx.getTTitleFlag();
            tCmd = ctx.getTTitleCmd();
        } else if (title instanceof BottomTitle) {
            str = "btitle";
            flag = ctx.getBTitleFlag();
            tCmd = ctx.getBTitleCmd();
        } else {
            return str;
        }
        if (flag) {
            if (tCmd.equals(EMPTYSTRING)) {
                str = str + " " + Messages.getString("Title.1") + m_lineSeparator;
            } else {
                str = str + " " + MessageFormat.format(Messages.getString("Title.2"), tCmd.length()) + m_lineSeparator;
                str = str + tCmd + m_lineSeparator;
            }
        } else if (tCmd.equals(EMPTYSTRING)) {
            str = str + " " + Messages.getString("Title.3") + m_lineSeparator;
        } else {
            str = str + " " + MessageFormat.format(Messages.getString("Title.4"), tCmd.length()) + m_lineSeparator;
            str = str + tCmd + m_lineSeparator;
        }
        return str;
    }

    protected String validateTitle(String titleString) {
        String[] tokens;
        for (String token : tokens = titleString.toUpperCase().split("\\s+")) {
            if ((token = token.trim()).contains(SQL_DOT_SQL) && token.matches("SQL.SQL\\d*")) {
                return token;
            }
            if (!token.contains(SQL_DOT_COMMAND) || !token.matches("SQL.COMMAND\\d*")) continue;
            return token;
        }
        return null;
    }

    private String substituteColumnValues(String oldValue, String newValue, String titleCmdString) {
        if (oldValue != null) {
            String temporaryTitleCmd = new String(titleCmdString).toUpperCase();
            if (temporaryTitleCmd.contains("'") || temporaryTitleCmd.contains("\"")) {
                String[] titlePieces;
                for (String titlePiece : titlePieces = this.splitStr(temporaryTitleCmd)) {
                    if (!(!titlePiece.contains(oldValue) || titlePiece.endsWith("'") || titlePiece.endsWith("\"") || titlePiece.startsWith("'") || titlePiece.startsWith("\""))) {
                        int IndexOfTemporaryTitleCmd = temporaryTitleCmd.indexOf(titlePiece);
                        int titlePieceLength = titlePiece.length();
                        int lenTitleCmdString = titleCmdString.length();
                        String F = titleCmdString.substring(0, IndexOfTemporaryTitleCmd);
                        int nextIndex = IndexOfTemporaryTitleCmd + titlePieceLength;
                        String L = titleCmdString.substring(nextIndex, lenTitleCmdString);
                        titleCmdString = F + newValue + ORA_SUBSTITUTION_MARKUP + L;
                        temporaryTitleCmd = temporaryTitleCmd.replaceFirst(titlePiece, newValue + ORA_SUBSTITUTION_MARKUP);
                        continue;
                    }
                    temporaryTitleCmd = temporaryTitleCmd.replaceFirst(titlePiece, this.emptyStringOfSize(titlePiece));
                }
            } else {
                titleCmdString.replaceAll("(?i:" + oldValue + ")", newValue);
            }
        }
        return titleCmdString;
    }

    private String emptyStringOfSize(String anyString) {
        StringBuffer sb = new StringBuffer(anyString.length());
        for (int i = 0; i < anyString.length(); ++i) {
            sb.insert(i, " ");
        }
        return sb.toString();
    }

    private boolean hasSubstituitionOraMarkup(String token) {
        return token.endsWith(ORA_SUBSTITUTION_MARKUP);
    }

    private String removeSubstituitionOraMarkup(String token) {
        if (token.endsWith(ORA_SUBSTITUTION_MARKUP)) {
            token = token.substring(0, token.length() - ORA_SUBSTITUTION_MARKUP.length());
        }
        return token;
    }

    public String getType() {
        return this.titleType;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String command = EMPTYSTRING;
        if (this instanceof BottomTitle) {
            command = command + "btitle ";
            command = ctx.getBTitleFlag() ? command + "on " : command + "off ";
            command = command + "\n";
            if (ctx.getBTitleCmd() != null && ctx.getBTitleCmd().length() > 0) {
                command = command + "btitle " + ctx.getBTitleCmd() + "\n";
            }
        } else if (this instanceof TopTitle) {
            command = command + "ttitle ";
            command = ctx.getTTitleFlag() ? command + "on " : command + "off ";
            command = command + "\n";
            if (ctx.getTTitleCmd() != null && ctx.getTTitleCmd().length() > 0) {
                command = command + "ttitle " + ctx.getTTitleCmd() + "\n";
            }
        }
        return command;
    }
}

