/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SetXQuery
extends CommandListener {
    public static final String XQUERY_BASEURI = "xquery.baseuri";
    public static final String XQUERY_ORDERING = "xquery.ordering";
    public static final String XQUERY_NODE = "xquery.node";
    public static final String XQUERY_CONTEXT = "xquery.context";
    public static final String help = "Usage: SET XQUERY {BASEURI text | CONTEXT text |\nNODE {BYVALUE | BYREFERENCE | DEFAULT} |\nORDERING {UNORDERED | ORDERED | DEFAULT}}\n";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSql().trim().split("\\s+", 4);
        if (parts.length < 2) {
            return false;
        }
        if (parts.length >= 2 && !(parts[0] + parts[1]).trim().toLowerCase().equals("setxquery")) {
            return false;
        }
        if (parts.length % 2 == 0 && parts.length > 2) {
            for (int i = 2; i < parts.length; ++i) {
                if (parts[i].toLowerCase().equals("baseuri")) {
                    ctx.putProperty(XQUERY_BASEURI, parts[i + 1]);
                } else if (parts[i].toLowerCase().equals("ordering")) {
                    ctx.putProperty(XQUERY_ORDERING, parts[i + 1]);
                } else if (parts[i].toLowerCase().equals("node")) {
                    ctx.putProperty(XQUERY_NODE, parts[i + 1]);
                } else if (parts[i].toLowerCase().equals("context")) {
                    ctx.putProperty(XQUERY_CONTEXT, parts[i + 1]);
                }
                ++i;
            }
        } else {
            ctx.write("SP2-0281: xquery missing set option\n");
            ctx.write(help);
        }
        return true;
    }
}

