/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.JSONWrapBufferedOutputStream;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.IOnConnection;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.jdbc.OracleConnection;

public class SetServerOutput
extends AForAllStmtsCommand
implements IOnConnection {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_SERVEROUTPUT;
    private static Hashtable<Connection, Boolean> m_enableHashFlag = new Hashtable();
    private boolean isDbmsOn = false;

    public SetServerOutput() {
        super(m_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean noConn = false;
        super.beginEvent(conn, ctx, cmd);
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            noConn = true;
        }
        if (cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            boolean fromCall;
            Boolean amIOn = Boolean.FALSE;
            boolean bl = fromCall = ctx.getProperty("script.runner.serveroutputnologpending") != null && Boolean.valueOf(ctx.getProperty("script.runner.serveroutputnologpending").equals(Boolean.TRUE)) != false;
            if (!noConn) {
                fromCall = SetServerOutput.isEnabled(ctx.getCurrentConnection());
            }
            if (fromCall) {
                amIOn = Boolean.TRUE;
            }
            ctx.putProperty("script.runner.context.serveroutput", amIOn);
        }
        if (this instanceof IOnConnection && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DISCONNECT)) {
            this.runOnDisconnect(conn, ctx, cmd);
        }
    }

    public static void coreEndWatcher(Connection conn, ScriptRunnerContext ctx) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (conn != null && conn instanceof OracleConnection) {
            String s = "\n";
            Boolean paneRegistered = (Boolean)ctx.getProperty("script.runner.dbmsouputpane");
            if ((SetServerOutput.isEnabled(conn) || paneRegistered != null && paneRegistered.equals(Boolean.TRUE)) && !ScriptUtils.isHttpCon(conn, ctx)) {
                s = SetServerOutput.format(ctx, DBUtil.getInstance(conn).getDBMSOUTPUT());
            }
            if (!s.equals("\n")) {
                try {
                    if (SetServerOutput.isEnabled(conn)) {
                        if (ctx.getOutputStream() instanceof JSONWrapBufferedOutputStream) {
                            ((JSONWrapBufferedOutputStream)ctx.getOutputStream()).addStmtInfo(SetServerOutput.getDBMSOUTPUTJSON(s));
                        }
                        ctx.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(s));
                    }
                    ctx.pushDbmsOutput(s);
                }
                catch (IOException e) {
                    Logger.getLogger(new SetServerOutput().getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
    }

    private static String getDBMSOUTPUTJSON(String s) {
        return "\"dbmsOutput\":" + JSONWrapBufferedOutputStream.quote(s, true);
    }

    @Override
    protected void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        SetServerOutput.coreEndWatcher(conn, ctx);
    }

    private static boolean isEnabled(Connection conn) {
        if (conn != null) {
            if (m_enableHashFlag.get(conn) == null) {
                return false;
            }
            return m_enableHashFlag.get(conn);
        }
        return false;
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean noConn = false;
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            noConn = true;
        }
        int flag = this.getSetServerOnOrOff(cmd);
        boolean retValue = false;
        switch (flag) {
            case 1: {
                retValue = this.setServerOutputOn(conn, ctx, cmd, noConn);
                this.isDbmsOn = true;
                break;
            }
            case 0: {
                if (!noConn) {
                    retValue = this.setServerOutputOff(conn, ctx, cmd);
                } else {
                    ctx.putProperty("script.runner.serveroutputnologpending", Boolean.FALSE);
                    retValue = true;
                }
                this.isDbmsOn = true;
                break;
            }
            default: {
                ctx.write(Messages.getString("SETSERVEROUTPUTONOROFF"));
                return false;
            }
        }
        return retValue;
    }

    private boolean setServerOutputOff(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        DBUtil.getInstance(conn).execute("BEGIN DBMS_OUTPUT.DISABLE(); END;", (List)null);
        m_enableHashFlag.put(conn, false);
        ctx.enableDbmsOutput();
        return true;
    }

    private boolean setServerOutputOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, boolean noConn) {
        FormatStyle toSet;
        block28: {
            String[] split;
            toSet = null;
            String theSql = cmd.getSql();
            String theSqlLower = theSql.toLowerCase(Locale.US);
            if (theSqlLower.indexOf("for") != -1 && (split = theSqlLower.trim().split("\\s+")) != null && split.length > 1 && split[split.length - 2].matches("^fo(?:r|rm|rma|rmat)$")) {
                if (split[split.length - 1].matches("^wr(?:a|ap|app|appe|apped)$")) {
                    toSet = FormatStyle.WRAPPED;
                } else if (split[split.length - 1].matches("^wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped)$")) {
                    toSet = FormatStyle.WORD_WRAPPED;
                } else if (split[split.length - 1].matches("^tr(?:u|un|unc|unca|uncat|uncate|uncated)$")) {
                    toSet = FormatStyle.TRUNCATED;
                } else {
                    ctx.write("Usage: SET SERVEROUTPUT { ON | OFF } [SIZE {n | UNL[IMITED]}] \n      [ FOR[MAT] { WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED] } ]\n");
                    return false;
                }
            }
            if (toSet == null) {
                toSet = FormatStyle.WORD_WRAPPED;
            } else {
                theSql = theSql.substring(0, theSqlLower.lastIndexOf("for")).trim();
            }
            String numberOrUnlimited = theSql.toLowerCase().replace("\n", " ").replace("-", "").replace("\\", " ").replaceAll("\\s+", " ").trim().replace("set serveroutput on size", "").replace("set serveroutpu on size", "").replace("set serveroutp on size", "").replace("set serverout on size", "").trim();
            DBUtil dbinst = null;
            if (!noConn) {
                dbinst = DBUtil.getInstance(conn);
                SetServerOutput.hackExceptionHandler(dbinst);
            }
            if (numberOrUnlimited.equals("unlimited") || numberOrUnlimited.equals("unl") || numberOrUnlimited.equals("unli") || numberOrUnlimited.equals("unlim") || numberOrUnlimited.equals("unlimi") || numberOrUnlimited.equals("unlimit") || numberOrUnlimited.equals("unlimite")) {
                if (!noConn) {
                    dbinst.execute("begin dbms_output.enable(1000000); end;", (List)null);
                }
                SQLException ex = null;
                if (!noConn) {
                    ex = dbinst.getLastException();
                }
                if (ex != null) {
                    System.out.println(ex.getLocalizedMessage());
                    return false;
                }
                ctx.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
                ctx.putProperty("script.runner.serveroutputunlimited", Boolean.TRUE);
                if (!noConn) {
                    this.flushOnSwitchOn(conn, ctx);
                    m_enableHashFlag.put(conn, true);
                }
            } else {
                try {
                    int i = new Integer(numberOrUnlimited);
                    if (i > 1999 && i < 1000001) {
                        if (!noConn) {
                            dbinst.execute("begin dbms_output.enable(" + i + "); end;", (List)null);
                        }
                        SQLException ex = null;
                        if (!noConn) {
                            ex = dbinst.getLastException();
                        }
                        if (ex != null) {
                            System.out.println(ex.getLocalizedMessage());
                            return false;
                        }
                        if (!noConn) {
                            this.flushOnSwitchOn(conn, ctx);
                            m_enableHashFlag.put(conn, true);
                        }
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("SERVEROUTPUT_ERROR"), numberOrUnlimited) + "\n");
                        return false;
                    }
                    ctx.putProperty("script.runner.lastsetserveroutput", new Integer(i));
                    ctx.putProperty("script.runner.serveroutputunlimited", Boolean.FALSE);
                }
                catch (NumberFormatException nfe) {
                    Throwable ex = null;
                    if (!noConn) {
                        SetServerOutput.hackExceptionHandler(dbinst);
                        dbinst.execute("begin dbms_output.enable(1000000); end;", (List)null);
                        ex = dbinst.getLastException();
                    }
                    if (ex != null) {
                        System.out.println(ex.getLocalizedMessage());
                        return false;
                    }
                    ctx.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
                    ctx.putProperty("script.runner.serveroutputunlimited", Boolean.TRUE);
                    if (!(numberOrUnlimited == null || numberOrUnlimited.equals("set serveroutput on") || numberOrUnlimited.equals("set serveroutput on") || numberOrUnlimited.equals("set serveroutpu on") || numberOrUnlimited.equals("set serveroutp on") || numberOrUnlimited.equals("set serverout on"))) {
                        ctx.write("Usage: SET SERVEROUTPUT { ON | OFF } [SIZE {n | UNL[IMITED]}] \n      [ FOR[MAT] { WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED] } ]\n");
                    }
                    if (noConn) break block28;
                    this.flushOnSwitchOn(conn, ctx);
                    m_enableHashFlag.put(conn, true);
                }
            }
        }
        ctx.putProperty("script.runner.serveroutformat", (Object)toSet);
        if (noConn) {
            ctx.putProperty("script.runner.serveroutputnologpending", Boolean.TRUE);
        }
        return true;
    }

    public static void hackExceptionHandler(DBUtil dbinst) {
        SQLException old = dbinst.getLastException();
        if (old != null) {
            System.out.println(old.getLocalizedMessage());
        }
        try {
            Method clearLastException = DBUtil.class.getDeclaredMethod("clearLastException", new Class[0]);
            clearLastException.setAccessible(true);
            clearLastException.invoke((Object)dbinst, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        MessageLogging.setMessageLogger(new MessageLogging(){

            @Override
            public void log(String txt) {
                System.out.println(txt);
            }
        });
    }

    private int getSetServerOnOrOff(ISQLCommand cmd) {
        String[] splitSql = cmd.getSql().toLowerCase().replaceFirst("set", " ").replaceFirst("serverout[a-z]*", " ").trim().split(" ");
        if (splitSql[0].equalsIgnoreCase("on")) {
            return 1;
        }
        if (splitSql[0].equalsIgnoreCase("off")) {
            return 0;
        }
        return -1;
    }

    @Override
    protected boolean isListenerOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.isDbmsOn;
    }

    @Override
    public void setCmdOn(boolean cmdOn) {
        super.setCmdOn(cmdOn);
        this.isDbmsOn = cmdOn;
    }

    protected void flushOnSwitchOn(Connection conn, ScriptRunnerContext ctx) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (conn instanceof OracleConnection && !SetServerOutput.isEnabled(conn)) {
            String s = "\n";
            DBUtil dbinst = DBUtil.getInstance(conn);
            if (!ScriptUtils.isHttpCon(conn, ctx)) {
                s = SetServerOutput.format(ctx, dbinst.getDBMSOUTPUT());
            }
            if (!s.equals("\n")) {
                ctx.pushDbmsOutput(s);
            }
        }
    }

    private static String format(ScriptRunnerContext ctx, String rawInString) {
        Integer linesize;
        boolean wasCRLF = false;
        boolean wasLF = false;
        if (rawInString == null) {
            return "";
        }
        FormatStyle formatStyle = (FormatStyle)((Object)ctx.getProperty("script.runner.serveroutformat"));
        StringBuffer retVal = null;
        StringBuffer rawIn = null;
        if (rawInString != null) {
            rawIn = new StringBuffer(rawInString);
        }
        if (formatStyle == null) {
            formatStyle = FormatStyle.WORD_WRAPPED;
        }
        if (formatStyle.equals((Object)FormatStyle.TRUNCATED)) {
            if (rawInString.endsWith("\r\n")) {
                wasCRLF = true;
                rawInString = rawInString.substring(0, rawInString.lastIndexOf("\r"));
            } else if (rawInString.endsWith("\n")) {
                wasLF = true;
                rawInString = rawInString.substring(0, rawInString.lastIndexOf("\n"));
            }
        }
        if ((linesize = (Integer)ctx.getProperty("script.runner.setlinesize")) == null || linesize == -1) {
            linesize = Integer.MAX_VALUE;
        }
        switch (formatStyle) {
            case WRAPPED: {
                retVal = ScriptUtils.wrap(2005, linesize, rawIn);
                break;
            }
            case WORD_WRAPPED: {
                retVal = ScriptUtils.wordwrap(2005, linesize, rawIn, Integer.MAX_VALUE);
                break;
            }
            case TRUNCATED: {
                retVal = ScriptUtils.truncate(2005, linesize, rawIn);
            }
        }
        String retValString = null;
        if (retVal != null) {
            if (wasCRLF) {
                retVal.append("\r\n");
            }
            if (wasLF) {
                retVal.append("\n");
            }
            retValString = retVal.toString();
        }
        return retValString;
    }

    public static String serverOutputFormatToString(ScriptRunnerContext ctx) {
        FormatStyle formatStyle = (FormatStyle)((Object)ctx.getProperty("script.runner.serveroutformat"));
        if (formatStyle == null) {
            formatStyle = FormatStyle.WORD_WRAPPED;
        }
        return "FORMAT " + formatStyle.toString();
    }

    @Override
    public boolean runOnConnect(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        conn = ctx.getCurrentConnection();
        Boolean wasFirstConnect = ctx.getProperty("script.runner.connectcalled") == null || Boolean.valueOf(ctx.getProperty("script.runner.connectcalled").equals(Boolean.TRUE)) == false;
        if (ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            ctx.putProperty("script.runner.connectcalled", Boolean.TRUE);
        }
        boolean closedOrError = false;
        try {
            closedOrError = conn == null || conn.isClosed() || ctx.getProperty("script.runner.serveroutputnologpending") == null || Boolean.valueOf(ctx.getProperty("script.runner.serveroutputnologpending").equals(Boolean.FALSE)) != false;
        }
        catch (SQLException e) {
            closedOrError = true;
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
        if (wasFirstConnect.booleanValue() && conn != null && conn instanceof OracleConnection && ctx != null && (ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) && !closedOrError) {
            Integer numb;
            DBUtil dbinst = DBUtil.getInstance(conn);
            SQLException e = dbinst.getLastException();
            if (e != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
            }
            if ((numb = (Integer)ctx.getProperty("script.runner.lastsetserveroutput")) == null) {
                numb = 100000;
            }
            ArrayList<Integer> forBinds = new ArrayList<Integer>();
            forBinds.add(numb);
            dbinst.execute("begin dbms_output.enable(:size); end;", forBinds);
            SQLException ex = dbinst.getLastException();
            if (ex != null) {
                ctx.write("SET SETSERVEROUT ON:" + ex.getLocalizedMessage());
                return false;
            }
            ctx.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
            m_enableHashFlag.put(conn, true);
            ctx.putProperty("script.runner.serveroutputnologpending", Boolean.FALSE);
            this.isDbmsOn = true;
        }
        if (ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            ctx.putProperty("script.runner.serveroutputnologpending", Boolean.FALSE);
        }
        return true;
    }

    @Override
    public boolean runOnDisconnect(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return true;
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.endEvent(conn, ctx, cmd);
        if (this instanceof IOnConnection && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT)) {
            this.runOnConnect(conn, ctx, cmd);
        }
    }

    public static enum FormatStyle {
        WRAPPED,
        WORD_WRAPPED,
        TRUNCATED;

    }
}

