/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetPagesize
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_PAGESIZE;

    public SetPagesize() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            str = str.trim().replaceAll("^(?i:set\\s+page)(?i:s|si|siz|size)\\s+", "").trim();
            str = str.replaceAll("['\"]", "");
            try {
                int x = new Integer(str);
                if (x < 0 || x > 50000) {
                    if (ctx.isSQLPlusClassic()) {
                        ctx.write(MessageFormat.format(Messages.getString("SetPagesize.2"), String.valueOf(x)));
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("SetPagesize.2"), x));
                    }
                    return true;
                }
                this.setProperties(cmd, ctx, ctx.getProperty("script.runner.setpagesize").toString(), "pagesize", "script.runner.setpagesize");
                this.writeShowMode(cmd, ctx, new Integer(x).toString());
                ctx.putProperty("script.runner.setpagesize", x);
            }
            catch (NumberFormatException e) {
                ctx.write(Messages.getString("SetPagesize.0"));
            }
        }
        return true;
    }
}

