/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetNumberformat
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NUMBERFORMAT;
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String NUMFMTREGEXP = "^(((?i:b|c|d|g|l|s|u|v)?([09]+((\\.|\\,|\\$)[09]*)?))|([09]+(((\\.|\\,|\\$)[09]*)|(?i:b|c|d|g|l|s|u|v)|(?i:pr|mi))?)|([09]+((?i:b|c|d|g|l|s|u|v)?[09]*)?)|((\\.|\\$)[09]+)|(?i:rn)|(?i:tm(9|e)?)|([09]+((\\.)[09]*)?(?i:e){4})|([09]*(?i:x)+)|((\\$)?[09\\,]+(\\.[09]+)?)|)$";

    public SetNumberformat() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            str = str.trim().replaceAll("^(?i:set\\s+num)(?i:f|fo|for|form|forma|format)\\s+", "").trim();
            if ((str = str.replaceAll("['\"]", "")).length() >= 0 && str.matches(NUMFMTREGEXP)) {
                ctx.putProperty("script.runner.setnumformat", str);
            } else {
                String msg = MessageFormat.format(ScriptRunnerDbArb.getString("NUMFORMAT_ILLEGAL"), "\"" + str + "\"") + m_lineSeparator;
                try {
                    ctx.getOutputStream().write(msg.getBytes());
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().toString()).log(Level.WARNING, "Failed to set the Number width");
                }
            }
        }
        return true;
    }
}

