/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetNewPage
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NEW_PAGE;

    public SetNewPage() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            str = str.trim().replaceAll("^(?i:set\\s+newp)(?i:|a|ag|age)\\s+", "").trim();
            str = str.replaceAll("['\"]", "");
            try {
                int x = new Integer(str);
                if (x < 0 || x > 50000) {
                    ctx.write(MessageFormat.format(Messages.getString("SetNewPagesize.1"), x));
                    return true;
                }
                ctx.putProperty("script.runner.newpage", x);
            }
            catch (NumberFormatException e) {
                ctx.write(Messages.getString("SetNewPage.2"));
            }
        }
        return true;
    }
}

