/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetLong
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_LONG;

    public SetLong() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            if (!str.matches("^(?i:set\\s+long)\\s+.*$")) {
                return false;
            }
            if ((str = str.trim().replaceAll("^(?i:set\\s+long)\\s+", "").trim()).startsWith("\"") && str.endsWith("\"") && str.length() > 1) {
                str = str.substring(1, str.length() - 1);
            } else if (str.startsWith("'") && str.endsWith("'") && str.length() > 1) {
                str = str.substring(1, str.length() - 1);
            }
            try {
                int x = new Integer(str);
                if (x < 1 || x > 2000000000) {
                    ctx.write("SP2-0267: long option -1 out of range (1 through 2000000000)\n");
                    return true;
                }
                ctx.putProperty("script.runner.setlong", new Integer(str));
            }
            catch (NumberFormatException nfe) {
                ctx.write("SP2-0268: long option not a valid number\n");
                return true;
            }
        }
        return true;
    }
}

