/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.query.Bind;

public class SetAutoPrint
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOPRINT;

    public SetAutoPrint() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.beginEvent(conn, ctx, cmd);
        if (cmd.getStmtSubType() != null && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            Boolean amIOn = Boolean.FALSE;
            if (this.isCmdOn()) {
                amIOn = Boolean.TRUE;
            }
            ctx.putProperty("script.runner.context.autoprint", amIOn);
        }
    }

    @Override
    public void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        List<String> al = DBUtil.getBinds(cmd.getSql(), true);
        if (al != null && al.size() > 0) {
            Map<String, Bind> m = ctx.getVarMap();
            for (String key : al) {
                if (!m.containsKey(key = key.toUpperCase())) continue;
                Bind obj = m.get(key);
                String value = "";
                if (obj instanceof String) {
                    value = (String)((Object)obj);
                } else if (obj instanceof Bind) {
                    value = obj.getValue();
                }
                this.printBindValue(ctx, key, value);
            }
        }
    }

    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.showModeForAutoPrint(ctx, cmd);
        return true;
    }

    private void printBindValue(ScriptRunnerContext ctx, String key, String value) {
        WrapListenBufferOutputStream out = ctx.getOutputStream();
        key = key.concat("\n");
        try {
            if (value == null) {
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(key));
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner("------\n"));
            } else {
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(key));
                StringBuffer limit = new StringBuffer();
                for (int j = 0; j < value.length(); ++j) {
                    limit.append("-");
                }
                limit.append("\n");
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(limit.toString()));
                value = value.concat("\n");
                ((FilterOutputStream)out).write(ScriptRunnerContext.stringToByteArrayForScriptRunner(value));
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void showModeForAutoPrint(ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtSubType() != null && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_AUTOPRINT)) {
            StringTokenizer st_tok = new StringTokenizer(cmd.getSql().trim());
            String setp = st_tok.nextToken();
            String autop = st_tok.nextToken();
            if (cmd.getSql().trim().length() > 3 && setp.equalsIgnoreCase("set") && autop.equalsIgnoreCase("autoprint")) {
                this.setProperties(cmd, ctx, this.isCmdOn() ? "ON" : "OFF", "autoprint", "script.runner.context.autoprint");
                String setting = st_tok.nextToken().toLowerCase().trim();
                if (setting.equals("on")) {
                    this.writeShowMode(cmd, ctx, "ON");
                }
                if (setting.equals("off")) {
                    this.writeShowMode(cmd, ctx, "OFF");
                }
            }
        }
    }
}

