/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadAPI;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.Restricted;
import oracle.dbtools.util.LogHandler;

@Restricted(level=Restricted.Level.HIGH)
public class LoadCommand
extends CommandListener
implements IHelp,
IShowCommand,
Connected {
    private String _filename;
    private String _responseName;
    private Connection _conn;
    private ScriptRunnerContext _ctx;
    private String _schema;
    private String _table;
    private File _loadFile;
    private File _responseFile;
    private FileInputStream _input;
    private OutputStream _output;
    private boolean _doCommit;

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public String getCommand() {
        return "LOAD";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean isValid = true;
        this._ctx = ctx;
        String sql = cmd.getSql();
        String[] cmds = sql.split(" ");
        try {
            if (conn != null) {
                this._conn = conn;
                int length = cmds.length;
                if (length > 3) {
                    return false;
                }
                if (length == 3) {
                    String object = cmds[1];
                    this._filename = ctx.prependCD(cmds[2]);
                    if (!this.validateTable(object)) {
                        isValid = false;
                        ctx.write(MessageFormat.format(Messages.getString("LOAD_TABLE_ERR"), this._schema + "." + this._table) + "\n");
                    }
                    if (!this.validateFile(this._filename)) {
                        isValid = false;
                        ctx.write(MessageFormat.format(Messages.getString("LOAD_FILE_ERR"), this._filename) + "\n");
                    }
                    if (isValid) {
                        Long commitSetting = (Long)ctx.getProperty("script.runner.autocommit.setting");
                        this._doCommit = commitSetting.equals(ScriptRunnerContext.AUTOCOMMITON);
                        this.doLoad(null, null);
                    }
                } else if (length == 2) {
                    ctx.write(this.getHelp());
                } else if (length == 1) {
                    ctx.write(this.getHelp());
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
            return true;
        }
    }

    private boolean validateFile(String fileName) {
        this._loadFile = new File(fileName);
        return this._loadFile.exists() && !this._loadFile.isDirectory();
    }

    private boolean validateTable(String table) {
        this._schema = this.getObjectOwner(table);
        if (this._schema != null && !this._schema.startsWith("\"") && !this._schema.endsWith("\"")) {
            this._schema = this._schema.toUpperCase();
        }
        this._table = this.getObjectName(table);
        if (this._table != null && !this._table.startsWith("\"") && !this._table.endsWith("\"")) {
            this._table = this._table.toUpperCase();
        }
        return true;
    }

    private String getObjectName(String object) {
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return names[0];
        }
        if (names.length == 2) {
            return names[1];
        }
        return object;
    }

    private String getObjectOwner(String object) {
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return null;
        }
        if (names.length == 2) {
            return names[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExitCode doLoad(ReadParmsDelimitedAPI readParms, LoadParmsAPI loadParms) {
        LogHandler handler = null;
        this._responseFile = File.createTempFile("sqlcl_load", ".tmp");
        this._responseFile.deleteOnExit();
        this._input = new FileInputStream(new File(this._filename));
        this._output = new FileOutputStream(this._responseFile);
        String msg = MessageFormat.format(Messages.getString("LOAD_START"), this._schema + "." + this._table, this._filename);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, msg);
        LoadParmsAPI loadParms2 = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH).responseFormat(LoadParmsAPI.RESPONSE_FORMAT.RESPONSE_SQL).doCommit(this._doCommit).build();
        LoadAPI loader = new LoadAPI.Builder(this._conn, this._schema, this._table, this._input, this._output).loadParms(loadParms2).readParms(readParms).logger(Logger.getLogger(this.getClass().getName())).build();
        ExitCode exitCode = loader.load();
        BufferedReader tmp = null;
        try {
            if (this._input != null) {
                this._input.close();
            }
        }
        catch (Exception e1) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
        }
        try {
            if (this._output != null) {
                String line;
                this._output.close();
                tmp = new BufferedReader(new FileReader(this._responseFile));
                while ((line = tmp.readLine()) != null) {
                    this._ctx.write(line + "\n");
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
        }
        try {
            String msg2 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, msg2);
            if (handler != null) {
                handler.close();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
        }
        finally {
            try {
                if (tmp != null) {
                    tmp.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        return exitCode;
        catch (IllegalStateException ise) {
            ExitCode exitCode2 = ExitCode.EXIT_SEVERE;
            BufferedReader tmp2 = null;
            try {
                if (this._input != null) {
                    this._input.close();
                }
            }
            catch (Exception e1) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
            }
            try {
                if (this._output != null) {
                    String line;
                    this._output.close();
                    tmp2 = new BufferedReader(new FileReader(this._responseFile));
                    while ((line = tmp2.readLine()) != null) {
                        this._ctx.write(line + "\n");
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
            try {
                String msg3 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, msg3);
                if (handler != null) {
                    handler.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
            finally {
                try {
                    if (tmp2 != null) {
                        tmp2.close();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                }
            }
            return exitCode2;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
            ExitCode exitCode3 = ExitCode.EXIT_SEVERE;
            BufferedReader tmp3 = null;
            try {
                if (this._input != null) {
                    this._input.close();
                }
            }
            catch (Exception e1) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
            }
            try {
                if (this._output != null) {
                    String line;
                    this._output.close();
                    tmp3 = new BufferedReader(new FileReader(this._responseFile));
                    while ((line = tmp3.readLine()) != null) {
                        this._ctx.write(line + "\n");
                    }
                }
            }
            catch (Exception e2) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e2.getLocalizedMessage());
            }
            try {
                String msg4 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, msg4);
                if (handler != null) {
                    handler.close();
                }
            }
            catch (Exception e3) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e3.getLocalizedMessage());
            }
            finally {
                try {
                    if (tmp3 != null) {
                        tmp3.close();
                    }
                }
                catch (Exception e4) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e4.getLocalizedMessage());
                }
            }
            return exitCode3;
            {
                catch (Throwable throwable) {
                    BufferedReader tmp4 = null;
                    try {
                        if (this._input != null) {
                            this._input.close();
                        }
                    }
                    catch (Exception e1) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
                    }
                    try {
                        if (this._output != null) {
                            String line;
                            this._output.close();
                            tmp4 = new BufferedReader(new FileReader(this._responseFile));
                            while ((line = tmp4.readLine()) != null) {
                                this._ctx.write(line + "\n");
                            }
                        }
                    }
                    catch (Exception e5) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e5.getLocalizedMessage());
                    }
                    try {
                        String msg5 = MessageFormat.format(Messages.getString("LOAD_END"), this._schema + "." + this._table, this._filename);
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, msg5);
                        if (handler != null) {
                            handler.close();
                        }
                    }
                    catch (Exception e6) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e6.getLocalizedMessage());
                    }
                    finally {
                        try {
                            if (tmp4 != null) {
                                tmp4.close();
                            }
                        }
                        catch (Exception e7) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e7.getLocalizedMessage());
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{this.getCommand()};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }
}

