/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import oracle.dbtools.raptor.newscriptrunner.ArgumentQuoteException;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.proformatter.CodingStyleSQLOptionsBean;
import oracle.dbtools.raptor.proformatter.FormatHelper;
import oracle.dbtools.util.Logger;

public class FormatSQLPlusCommand
extends CommandListener
implements IHelp {
    public static int CHUNKSIZE = 1000;

    @Override
    public String getCommand() {
        return "FORMAT";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSQLOrig().split("\\s+");
        String toFormat = null;
        try {
            if (ctx.getProperty("script.runner.jline") != null) {
                if (parts.length == 2 && parts[1].toUpperCase().equals("BUFFER")) {
                    toFormat = ctx.getSQLPlusBuffer().getBufferSafe().getBuffer();
                    CodingStyleSQLOptionsBean cb = (CodingStyleSQLOptionsBean)ctx.getProperty("SQLFORMATRULES");
                    String formatted = ctx.getSQLPlusFormatter().format(cb, toFormat);
                    if (formatted != null) {
                        String[] formattedArray = formatted.split("\n");
                        ctx.getSQLPlusBuffer().getBufferSafe().resetBuffer(Arrays.asList(formattedArray));
                        ctx.write(ctx.getSQLPlusBuffer().getBufferSafe().list(false));
                        return true;
                    }
                    ctx.write("Buffer not formatted\n");
                    return true;
                }
                if (parts.length == 3 && parts[1].toUpperCase().equals("RULES")) {
                    String rulesFile = ctx.prependCD(parts[2]);
                    File f = new File(rulesFile);
                    if (f.exists()) {
                        CodingStyleSQLOptionsBean cb = new CodingStyleSQLOptionsBean();
                        boolean fail = FormatHelper.loadFromXML(cb, f.toURI().toURL());
                        ctx.putProperty("SQLFORMATRULES", cb);
                        if (!fail) {
                            ctx.write("Formatter rules loaded\n");
                        } else {
                            ctx.write("Formatter rules failed to load\n");
                        }
                    } else {
                        ctx.write(MessageFormat.format("File {0} cannot be opened.\n", rulesFile));
                    }
                    return true;
                }
            }
            if (cmd.getSql().split("\n")[0].matches("^(?i)format\\s*-\\s+.*$")) {
                toFormat = cmd.getSql().substring(cmd.getSql().indexOf("-") + 1).trim();
            } else {
                String cmdNoNewline = cmd.getSql().replace("\r\n", " ").replace("\n", " ");
                if (cmdNoNewline.matches("^(?i)format\\s*file\\s+.*$")) {
                    toFormat = cmdNoNewline.substring(cmd.getSql().toUpperCase().indexOf("F", 2)).trim();
                }
            }
            if (toFormat != null) {
                if (toFormat.toUpperCase().startsWith("FILE")) {
                    String[] args = ScriptUtils.executeArgs(toFormat);
                    if (args.length == 3) {
                        this.doWork(ctx, args[1], args[2]);
                    } else {
                        ctx.write(this.getHelp());
                    }
                } else {
                    ctx.write(this.getHelp());
                }
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            Logger.severe(this.getClass(), e.getLocalizedMessage(), e);
            return true;
        }
        catch (ArgumentQuoteException e) {
            Logger.severe(this.getClass(), e.getLocalizedMessage(), e);
            ctx.write(this.getHelp());
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ctx.write(this.getHelp());
        return true;
    }

    protected Void doWork(ScriptRunnerContext ctx, String inputFile, String outputFile) {
        if (inputFile != null && outputFile != null) {
            inputFile = this.putInDir(ctx, inputFile);
            outputFile = this.putInDir(ctx, outputFile);
        }
        if (inputFile == null || outputFile == null || !new File(inputFile).exists()) {
            this.usage(ctx);
            return null;
        }
        boolean errorMade = new File(inputFile).isDirectory() && (new File(outputFile).isDirectory() || !new File(outputFile).exists()) ? this.doDirectory(ctx, inputFile, outputFile) : this.inputFileToOutputFile(ctx, inputFile, outputFile);
        if (errorMade) {
            this.usage(ctx);
        }
        return null;
    }

    private void usage(ScriptRunnerContext ctx) {
        ctx.write(this.getHelp());
    }

    private boolean doDirectory(ScriptRunnerContext ctx, String sourceDir, String targetDir) {
        File[] files;
        boolean errorMade = false;
        if (!new File(targetDir).isDirectory()) {
            new File(targetDir).delete();
            if (!new File(targetDir).mkdir()) {
                this.errorOn(ctx, sourceDir, targetDir);
                return true;
            }
        }
        if ((files = new File(sourceDir).listFiles()) != null) {
            for (File f : files) {
                int slash = f.getPath().lastIndexOf(File.separator);
                int cslash = f.getPath().lastIndexOf(":");
                if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1 && cslash > slash && cslash > 0 && cslash < 4) {
                    slash = cslash;
                }
                if (slash == -1 || f.getPath().endsWith(File.separator)) {
                    this.errorOn(ctx, sourceDir, targetDir);
                    errorMade = true;
                    continue;
                }
                String end = f.getPath();
                if (slash != -1) {
                    end = f.getPath().substring(slash + 1);
                }
                if (f.isDirectory()) {
                    if (!this.doDirectory(ctx, f.getPath(), targetDir + File.separator + end)) continue;
                    errorMade = true;
                    continue;
                }
                if (!this.inputFileToOutputFile(ctx, f.getPath(), targetDir + File.separator + end)) continue;
                errorMade = true;
            }
        }
        return errorMade;
    }

    private void errorOn(ScriptRunnerContext ctx, String input, String output) {
        ctx.write(ScriptRunnerDbArb.format("ERRORON", input, output));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputFileToOutputFile(ScriptRunnerContext ctx, String inputFile, String outputFile) {
        block35: {
            boolean bl;
            BufferedWriter bw = null;
            BufferedReader br = null;
            try {
                if (inputFile == null || outputFile == null || !new File(inputFile).exists()) {
                    this.errorOn(ctx, inputFile, outputFile);
                    boolean bl2 = true;
                    return bl2;
                }
                String encoding = ctx.getEncoding();
                br = encoding == null || encoding.equals("") ? new BufferedReader(new InputStreamReader(new FileInputStream(inputFile))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding));
                StringBuffer inputBuffer = new StringBuffer("");
                char[] chunk = new char[CHUNKSIZE];
                int i = 0;
                while ((i = br.read(chunk, 0, CHUNKSIZE)) != -1) {
                    inputBuffer.append(chunk, 0, i);
                }
                String inputBufferSt = inputBuffer.toString();
                CodingStyleSQLOptionsBean cb = (CodingStyleSQLOptionsBean)ctx.getProperty("SQLFORMATRULES");
                String output = ctx.getSQLPlusFormatter().format(cb, inputBufferSt);
                if (output != null) {
                    if (output.endsWith("\n") && !output.endsWith("\n")) {
                        output = output + "\n";
                    }
                    if (inputBufferSt.endsWith(" ") && !output.endsWith(" ")) {
                        output = output + " ";
                    }
                    if (!output.endsWith("\n")) {
                        output = output + "\n";
                    }
                    String newLine = "\n";
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
                        newLine = "\r\n";
                    }
                    output = output.replaceAll("\r{0,1}\n", newLine);
                    new File(outputFile).delete();
                    bw = encoding == null || encoding.equals("") ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFile))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));
                    bw.write(output);
                    break block35;
                }
                ctx.write(ScriptRunnerDbArb.format("OUTPUTNULL", outputFile));
                bl = true;
            }
            catch (Exception ex) {
                Logger.severe(this.getClass(), ex.getStackTrace()[0].toString(), ex);
                this.errorOn(ctx, inputFile, outputFile);
                boolean bl3 = true;
                return bl3;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public String putInDir(ScriptRunnerContext ctx, String input) {
        if (input == null) {
            return null;
        }
        int cslash = input.indexOf(":");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? cslash > 0 && cslash < 4 : input.startsWith("/")) {
            return input;
        }
        String path = (String)ctx.getProperty("script.runner.cd_command");
        if (path == null) {
            return input;
        }
        if (path.endsWith(File.separator)) {
            return path + input;
        }
        return path + File.separator + input;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

