/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class ErrorOut
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_ECHO;

    public ErrorOut() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String errorOut = (String)cmd.getProperty("prop_error_string");
        if (cmd.isSqlPlusSetCmd() && errorOut != null) {
            if (cmd.getSql().trim().equalsIgnoreCase("set")) {
                String prompt = ctx.getPrompt();
                if (prompt.toString().indexOf("@|") >= 0 && prompt.toString().indexOf("|@") > 0) {
                    prompt = prompt.replaceAll("@\\|\\w+\\s?", "");
                    prompt = prompt.replaceAll("\\|@", "");
                }
                if (ctx.isEchoOn()) {
                    ctx.write(prompt + " set\n");
                }
                ctx.write(Messages.getString("ErrorOut.8"));
            } else {
                ctx.write(errorOut + "\n");
            }
            return true;
        }
        return false;
    }
}

