/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.scriptrunner.Restricted;

@Restricted(level=Restricted.Level.REST)
public class ChangeScriptRunnerContextCmd
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_COMMENT_SQL;
    public static final String SQLDEVSRC = "SQLDEV:SRC:";
    public static final String SQLERROR = "sqlError";

    public ChangeScriptRunnerContextCmd() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (this.isScriptCmd(conn, ctx, cmd)) {
            String[] commands;
            String command = null;
            if (cmd.getStmtClass() == SQLCommand.StmtType.G_C_MULTILINECOMMENT) {
                command = cmd.getSql().trim().substring(2, cmd.getSql().trim().length() - 2);
            } else if (cmd.getStmtClass() == SQLCommand.StmtType.G_C_COMMENT) {
                command = cmd.getSql().trim().substring(2);
            }
            command = command.substring(SQLDEVSRC.length()).trim();
            for (String com : commands = command.split(",")) {
                String[] keyValue = com.split("=");
                if (!keyValue[0].equalsIgnoreCase(SQLERROR)) continue;
                int value = Integer.parseInt(keyValue[1]);
                ctx.setSqlError(value);
            }
            return true;
        }
        return false;
    }

    public boolean isScriptCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtClass() == SQLCommand.StmtType.G_C_MULTILINECOMMENT) {
            String sql = cmd.getSql().trim().substring(2, cmd.getSql().trim().length() - 2);
            return this.isSQLDevSRC(sql);
        }
        if (cmd.getStmtClass() == SQLCommand.StmtType.G_C_COMMENT) {
            String sql = cmd.getSql().trim().substring(2);
            return this.isSQLDevSRC(sql);
        }
        return false;
    }

    private boolean isSQLDevSRC(String sql) {
        return sql.startsWith(SQLDEVSRC);
    }
}

