/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.Restricted;

@Restricted(level=Restricted.Level.HIGH)
public class CdCommand
extends CommandListener
implements IHelp,
IShowCommand {
    @Override
    public String getCommand() {
        return "CD";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] tokens = cmd.getSql().trim().split("[ \t\n]+");
        if (tokens.length > 0) {
            Object query = null;
            if (tokens[0].toLowerCase().equals(this.getCommandName().toLowerCase())) {
                if (tokens.length == 1) {
                    ctx.getProperties().remove("script.runner.cd_command");
                    ctx.getMap().remove(ScriptRunnerContext.SqlplusVariable._PWD.toString());
                    return this.handleReturn(true);
                }
                if (tokens.length > 1) {
                    String cdPath = cmd.getSql().trim().substring(2).trim();
                    if ((cdPath.startsWith("'") && cdPath.endsWith("'") || cdPath.startsWith("\"") && cdPath.endsWith("\"")) && cdPath.length() > 2) {
                        cdPath = cdPath.substring(1, cdPath.length() - 1);
                    }
                    if (System.getProperty("os.name").startsWith("Windows") && cdPath.startsWith("/") && cdPath.length() > 3 && cdPath.substring(2, 3).equals(":")) {
                        cdPath = cdPath.substring(1);
                    }
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        cdPath = cdPath.replace("/", "\\");
                    }
                    if (!System.getProperty("os.name").startsWith("Windows") && cdPath.startsWith("~")) {
                        cdPath = cdPath.replaceFirst("~", System.getProperty("user.home"));
                    }
                    File f = new File(cdPath);
                    if (cdPath != null && new File(f.getAbsolutePath()).isDirectory()) {
                        String cPath = null;
                        try {
                            cPath = new File(cdPath).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ctx.putProperty("script.runner.cd_command", cPath != null ? cPath : cdPath);
                        ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), cPath != null ? cPath : cdPath);
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("CDNOTFOUND"), cdPath) + "\n");
                    }
                }
                return this.handleReturn(true);
            }
        }
        return false;
    }

    public String getCommandName() {
        return "CD";
    }

    boolean handleReturn(boolean b) {
        if (!b) {
            // empty if block
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String format = null;
        format = ctx.getProperties().containsKey("script.runner.cd_command") && ctx.getProperties().get("script.runner.cd_command") != null ? (String)ctx.getProperties().get("script.runner.cd_command") : "Default";
        ctx.write("");
        ctx.write(MessageFormat.format(Messages.getString("CD"), format) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"cd"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

