/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;

public class ArchiveLogList
extends CommandListener {
    private static final String CMD = "archive log list";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection myconn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return false;
        }
        if (cmd.getSql().trim().toLowerCase().replaceAll("\\s+", " ").startsWith(CMD)) {
            block39: {
                Connection conn = ctx.getCurrentConnection();
                boolean amILocked = false;
                Connection lockedConn = null;
                String writeOrError = "";
                try {
                    Properties p;
                    lockedConn = ctx.getCurrentConnection();
                    if (lockedConn == null || !(amILocked = LockManager.lock(lockedConn))) break block39;
                    String logMode = DBUtil.getInstance(conn).executeReturnOneCol("select LOG_MODE from v$database");
                    String role = null;
                    if (conn instanceof OracleConnection && (p = ((OracleConnection)conn).getProperties()) != null) {
                        role = p.getProperty("internal_logon");
                    }
                    if (role != null && (role.equalsIgnoreCase("sysdba") || role.equalsIgnoreCase("sysoper"))) {
                        if (logMode != null) {
                            if (logMode.equals("NOARCHIVELOG")) {
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("DATABASE_LOG_MODE")) + Messages.getString("NO_ARCHIVE_MODE") + "\n";
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("AUTOMATIC_ARCHIVAL")) + Messages.getString("DISABLED") + "\n";
                            } else if (logMode.equals("ARCHIVELOG")) {
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("DATABASE_LOG_MODE")) + Messages.getString("ARCHIVE_LOG_MODE") + "\n";
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("AUTOMATIC_ARCHIVAL")) + Messages.getString("ENABLED") + "\n";
                            } else if (logMode.equals("MANUAL")) {
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("DATABASE_LOG_MODE")) + Messages.getString("ARCHIVE_LOG_MODE") + "\n";
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("AUTOMATIC_ARCHIVAL")) + Messages.getString("DISABLED") + "\n";
                            }
                        }
                        Statement s = null;
                        ResultSet rs = null;
                        HashMap<Integer, String> locations = new HashMap<Integer, String>();
                        HashMap<Integer, String> locationsFlag = new HashMap<Integer, String>();
                        String logFileDest = null;
                        try {
                            String current;
                            String nextLog;
                            int maxLocation = 0;
                            s = conn.createStatement();
                            rs = s.executeQuery("select value, to_number(substr(name,18)) num from v$parameter where name like 'log_archive_dest_%' and name not like 'log_archive_dest_state%' order by num");
                            while (rs.next()) {
                                int location = rs.getInt(2);
                                if (location > maxLocation) {
                                    maxLocation = location;
                                }
                                locations.put(location, rs.getString(1));
                            }
                            rs.close();
                            s.close();
                            s = conn.createStatement();
                            rs = s.executeQuery("select value, to_number(substr(name,24)) num from v$parameter where name like 'log_archive_dest_state_%' order by num");
                            while (rs.next()) {
                                locationsFlag.put(rs.getInt(2), rs.getString(1));
                            }
                            for (int i = 1; i < maxLocation + 1; ++i) {
                                String[] locationString = (String[])locations.get(i);
                                String locationFlag = (String)locationsFlag.get(i);
                                if (locationString == null || locationString.trim().equals("") || locationFlag == null || !locationFlag.equalsIgnoreCase("enabled")) continue;
                                logFileDest = locationString;
                                break;
                            }
                            if (logFileDest == null) {
                                String logArchiveDest = DBUtil.getInstance(conn).executeReturnOneCol("select value from v$parameter where name = 'log_archive_dest' and value != null");
                                logFileDest = logArchiveDest != null && !logArchiveDest.equals("") ? logArchiveDest : "USE_DB_RECOVERY_FILE_DEST";
                            }
                            if (logFileDest != null && !logFileDest.equals("USE_DB_RECOVERY_FILE_DEST")) {
                                String[] rip;
                                logFileDest = logFileDest.trim();
                                for (String regexp : rip = new String[]{"[lL][oO][cC][aA][tT][iI][oO][nN]\\s*=\\s*'([^']*)'.*", "[lL][oO][cC][aA][tT][iI][oO][nN]\\s*=\\s*\"([^']*)\".*", "[lL][oO][cC][aA][tT][iI][oO][nN]\\s*=\\s*([^\\s]*).*", "[sS][eE][rR][vV][iI][cC][eE]\\s*=\\s*'([^']*)'.*", "[sS][eE][rR][vV][iI][cC][eE]\\s*=\\s*\"([^']*)\".*", "[sS][eE][rR][vV][iI][cC][eE]\\s*=\\s*([^\\s]*).*", "'([^']*)'.*", "\"([^']*)\".*", "([^\\s]*).*"}) {
                                    if (!logFileDest.matches(regexp)) continue;
                                    logFileDest = logFileDest.replaceAll(regexp, "$1");
                                    break;
                                }
                            }
                            writeOrError = writeOrError + this.cutTo40(Messages.getString("ARCHIVE_DESTINATION")) + logFileDest + "\n";
                            String oldestOnline = DBUtil.getInstance(conn).executeReturnOneCol("select min(sequence#) from v$log");
                            if (oldestOnline != null) {
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("OLDEST_ONLINE_LOG_SEQUENCE")) + oldestOnline + "\n";
                            }
                            if (logMode != null && !logMode.equals("NOARCHIVELOG") && (nextLog = DBUtil.getInstance(conn).executeReturnOneCol("select max(sequence#) from v$log where ARCHIVED='NO'")) != null) {
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("NEXT_LOG_SEQUENCE_TO_ARCHIVE")) + nextLog + "\n";
                            }
                            if ((current = DBUtil.getInstance(conn).executeReturnOneCol("select max(sequence#) from v$log where status='CURRENT'")) != null) {
                                writeOrError = writeOrError + this.cutTo40(Messages.getString("CURRENT_LOG_SEQUENCE")) + current + "\n";
                            }
                            ctx.write(writeOrError);
                            break block39;
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    ctx.write(Messages.getString("INSUFFICIENT_PRIVILEGES") + "\n");
                }
                catch (Exception e) {
                    ctx.write(e.getLocalizedMessage() + "\n");
                }
                finally {
                    if (amILocked) {
                        LockManager.unlock(lockedConn);
                    }
                }
            }
            return true;
        }
        ctx.write(Messages.getString("ONLY_ARCHIVE_LOG_LIST_HANDLED") + "\n");
        return false;
    }

    String cutTo40(String in) {
        String longSpaces = "                                                                       ";
        if (in == null) {
            in = "";
        }
        in = in + longSpaces;
        return in.substring(0, 39) + " ";
    }

    public void beginScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

