/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrapBufferOutputStreamToWriter
extends BufferedOutputStream {
    private PipedOutputStream m_out = null;
    OutputRedirectorForSpool outputRedirectorForSpool = null;
    private String m_terminator = System.getProperty("line.separator");

    public WrapBufferOutputStreamToWriter(OutputStream out) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()));
    }

    public WrapBufferOutputStreamToWriter(OutputStream out, int size) {
        super(new BufferedOutputStream(new ByteArrayOutputStream()), size);
    }

    public void setOut(BufferedWriter newB) throws IOException {
        PipedOutputStream outs;
        this.flush();
        this.close();
        PipedInputStream in = new PipedInputStream();
        this.m_out = outs = new PipedOutputStream(in);
        this.outputRedirectorForSpool = new OutputRedirectorForSpool(in, newB);
        this.outputRedirectorForSpool.start();
    }

    @Override
    public void flush() throws IOException {
        if (this.m_out != null) {
            this.m_out.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_out != null) {
            this.flush();
            this.m_out.close();
            this.m_out = null;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(b);
        }
    }

    public void setTerminator(String terminator) {
        this.m_terminator = terminator;
    }

    public String getTerminator() {
        return this.m_terminator;
    }

    class OutputRedirectorForSpool
    extends Thread {
        private BufferedWriter m_bw = null;
        private PipedInputStream m_in = null;
        private BufferedReader m_reader;
        private String m_term = null;
        private String m_stringTerminator = System.getProperty("line.separator");

        public OutputRedirectorForSpool(PipedInputStream in, BufferedWriter bw) {
            this.m_bw = bw;
            this.m_in = in;
            this.m_term = this.getLineTerminator();
            try {
                this.m_reader = new BufferedReader(new InputStreamReader((InputStream)this.m_in, "UTF8"));
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }

        @Override
        public void run() {
            try {
                String _line;
                while ((_line = this.m_reader.readLine()) != null) {
                    this.m_bw.write(_line + this.m_term);
                }
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            finally {
                try {
                    if (this.m_reader != null) {
                        this.m_reader.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (this.m_bw != null) {
                        this.m_bw.flush();
                        this.m_bw.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public void setLineTerminator(String terminator) {
            this.m_stringTerminator = terminator;
        }

        String getLineTerminator() {
            return this.m_stringTerminator;
        }
    }
}

