/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.BufferedReaderStack;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCompoundCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;

public class ScriptParser {
    private static final Logger s_logger = Logger.getLogger(ScriptParser.class.getName());
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    public static final String TERMINATOR = "terminator";
    static final String FORWARDSLASH = "/";
    private static String[][] m_startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private List<ISQLCommand> m_sqlArray = new ArrayList<ISQLCommand>();
    private String m_rawSQL;
    private BufferedReaderStack m_reader = null;
    private int m_readerLineCnt = -1;
    private int m_readerLineStartCnt = 0;
    private int m_state = 0;
    private boolean m_firstLine = true;
    private String m_quoteString = "";
    private String m_leftOver = null;
    private String m_setLeftOver = null;
    private int _numOfEmptyLineAbove = 0;
    public static final String NUMEMPTYLINESABOVE = "NUMEMPTYLIENSABOVE";
    private ScriptRunnerContext _scriptRunnerContext = null;
    private boolean m_isCompoundSetStmt = false;
    private boolean m_isFirstPartOfCompoundSetStmt = false;
    private int m_setSubCommandCount = 0;
    private SQLCommand createRefine = null;
    private boolean createRefineReturnOnSemicolon = false;
    private boolean createRefineSemiColonTerminates = false;
    private StringBuffer createRefineLineSoFar = null;

    public ScriptParser(InputStream stream) {
        this(stream, null);
    }

    public ScriptParser(Reader rdr) {
        this(rdr, null);
    }

    public ScriptParser(InputStream in, Connection conn) {
        this(new InputStreamReader(in), conn);
    }

    public ScriptParser(Reader rdr, Connection conn) {
        this.scriptParserInit(rdr, conn);
    }

    private void scriptParserInit(Reader rdr, Connection c) {
        this.m_reader = new BufferedReaderStack(new BufferedReader(rdr));
    }

    public ScriptParser(String s) {
        this(s, null);
    }

    public ScriptParser(String s, Connection conn) {
        this(new StringReader(s), conn);
        this.m_rawSQL = s;
    }

    public static void main(String[] args) throws Exception {
        File f = new File(args[0]);
        FileInputStream in = new FileInputStream(f);
        ScriptParser s = new ScriptParser(in);
        s.parse();
        ISQLCommand[] stmts = s.getSqlStatements();
        for (int i = 0; i < stmts.length; ++i) {
            System.out.print("Command " + i + ":" + (Object)((Object)stmts[i].getStmtType()) + ":" + (Object)((Object)stmts[i].getStmtSubType()) + "\n" + stmts[i].getSql() + "\n");
            if (stmts[i].isSqlPlusSetCmd()) {
                System.out.println(" SQLPLUS");
                continue;
            }
            if (stmts[i].isCreateCmd()) {
                System.out.println(" Create");
                continue;
            }
            if (stmts[i].isCreatePLSQLCmd()) {
                System.out.println(" PLSQL");
                continue;
            }
            if (!stmts[i].isCreateSQLCmd()) continue;
            System.out.println(" SQL");
        }
    }

    public void parse() {
        this.m_leftOver = null;
        this.m_setLeftOver = null;
        this.m_readerLineCnt = -1;
        try {
            ISQLCommand cmd = this.next();
            while (cmd != null) {
                this.m_sqlArray.add(cmd);
                cmd = this.next();
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void parseinit() {
        this.m_leftOver = null;
        this.m_setLeftOver = null;
        this.m_readerLineCnt = -1;
    }

    public ISQLCommand next() throws IOException {
        SQLCommand incompleteCmd;
        this.m_reader.setContext(this._scriptRunnerContext);
        if (this._scriptRunnerContext != null && this.isInFile() && (incompleteCmd = (SQLCommand)this._scriptRunnerContext.getProperty("incomplete")) != null && incompleteCmd.getOrigSQL() != null) {
            this.m_leftOver = this.m_leftOver == null ? incompleteCmd.getOrigSQL() : this.m_leftOver + " " + incompleteCmd.getOrigSQL();
            this._scriptRunnerContext.removeProperty("incomplete");
        }
        String line = this.getTop(this.m_leftOver);
        this.m_leftOver = null;
        if (line == null) {
            if (this._numOfEmptyLineAbove > 0 && this._scriptRunnerContext != null && this._scriptRunnerContext.isCommandLine()) {
                return this.makeCommentWithEmptyLines(this._numOfEmptyLineAbove);
            }
            return null;
        }
        SQLCommand stmtProperties = this.getPropertiesForParserHint(line);
        if (stmtProperties == null) {
            stmtProperties = this.getPropertiesWhenNoSpaceRequired(line);
        }
        if (stmtProperties == null) {
            stmtProperties = this.getPropertiesWhenTokensKnown(line);
            if (stmtProperties != null && stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_ALIAS) && line.indexOf(61) != -1) {
                String[] whiteSplit;
                stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQL);
                String[] equalsSplit = line.split("=");
                if (equalsSplit != null && equalsSplit.length > 1 && equalsSplit[1] != null && (whiteSplit = equalsSplit[1].trim().split("\\s")) != null && whiteSplit.length > 0 && whiteSplit[0] != null && (whiteSplit[0].equalsIgnoreCase("begin") || whiteSplit[0].equalsIgnoreCase("declare") || equalsSplit[1].startsWith("q'") || equalsSplit[1].startsWith("Q'"))) {
                    stmtProperties.setStmtType(SQLCommand.StmtType.G_C_PLSQL);
                }
            }
            if (stmtProperties != null && stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_NET) && line.indexOf(61) != -1) {
                stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQL);
            }
        }
        if (stmtProperties == null && (stmtProperties = this.getPropertiesWhenMulitpleTokensKnown(line)) != null && (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN) || stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && stmtProperties.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL))) {
            stmtProperties.setProperty("CREATEREFINE", Boolean.TRUE);
        }
        if (stmtProperties == null && (stmtProperties = this.getHalfRecognizedMultiToken(line)) != null && (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN) || stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && stmtProperties.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL))) {
            stmtProperties.setProperty("CREATEREFINE", Boolean.TRUE);
        }
        if (stmtProperties == null) {
            stmtProperties = this.createUnknownStatementProperties();
        }
        stmtProperties = this.refineScriptRecognition(stmtProperties, line);
        stmtProperties = this.refineStmtRecognition(stmtProperties, line);
        String processLine = line.replaceAll("--.*|/\\*((.|\\n)(?!=*/))+\\*/", "");
        processLine = processLine.replaceAll("'(.)*'", "");
        if ((processLine = processLine.replaceAll("\\s+", "").toUpperCase()).indexOf("/*+WITH_PLSQL") != -1) {
            stmtProperties.setProperty(TERMINATOR, FORWARDSLASH);
        }
        if (processLine.indexOf("WITHFUNCTION") != -1 || processLine.indexOf("WITHPROCEDURE") != -1) {
            stmtProperties.setProperty(TERMINATOR, FORWARDSLASH);
        }
        if ((stmtProperties = this.identifyEndOfStatement(line, this.m_reader, stmtProperties)).getStmtResultType() != null && stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH) {
            stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQL);
        }
        stmtProperties = this.refineConnectOnFirstLine(stmtProperties, line);
        stmtProperties.setProperty(NUMEMPTYLINESABOVE, this._numOfEmptyLineAbove);
        return stmtProperties;
    }

    private ISQLCommand makeCommentWithEmptyLines(int _numOfEmptyLineAbove2) {
        SQLCommand stmtProperties = this.createUnknownStatementProperties();
        stmtProperties.setStmtId(SQLCommand.StmtSubType.G_S_COMMENT_SQL);
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= this._numOfEmptyLineAbove; ++i) {
            sb.append("\n");
        }
        stmtProperties.setSQLOrig(sb.toString());
        stmtProperties.setSql(sb.toString());
        stmtProperties.setModifiedSQL(sb.toString());
        stmtProperties.setProperty(NUMEMPTYLINESABOVE, this._numOfEmptyLineAbove);
        this._numOfEmptyLineAbove = 0;
        return stmtProperties;
    }

    private SQLCommand refineConnectOnFirstLine(SQLCommand stmtProperties, String line) {
        String patterns;
        Pattern pattern;
        Matcher matcher;
        if (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_UNKNOWN) && this.m_readerLineCnt < 1 && (matcher = (pattern = Pattern.compile(patterns = "(\\w+\\/\\w+@\\w+(\\s+as\\s+(sysdba)|(sysoper))?)|\\w+\\/\\w+@\\w+\\s+as\\s+sysdba|\\w+\\/\\w+@\\w+\\s+as\\s+sysoper|\\w+\\/\\w+\\s+as\\s+sysdba|\\w+\\/\\w+\\s+as\\s+sysoper|\\w+\\/\\w+", 2)).matcher(line.trim())).matches()) {
            stmtProperties.setRunnable(false);
        }
        return stmtProperties;
    }

    private SQLCommand refineScriptRecognition(SQLCommand stmtProperties, String line) {
        if (stmtProperties.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SCRIPT) && line.split("\\s+").length > 1) {
            stmtProperties.setStmtType(SQLCommand.StmtType.G_C_SQLPLUS);
        }
        return stmtProperties;
    }

    private SQLCommand getPropertiesForParserHint(String line) {
        SQLCommand prop = null;
        if (line.startsWith("/*")) {
            line = line.toLowerCase();
            for (String key : SQLStatementTypes.hintTokens.keySet()) {
                if (!line.startsWith(key)) continue;
                prop = SQLStatementTypes.hintTokens.get(key);
            }
        }
        return prop;
    }

    private SQLCommand getHalfRecognizedMultiToken(String line) {
        line = line.trim();
        Set<String> keys = SQLStatementTypes.halfRecognizedMultiToken.keySet();
        for (String key : keys) {
            if (!line.toLowerCase().startsWith(key)) continue;
            return SQLStatementTypes.halfRecognizedMultiToken.get(key);
        }
        return null;
    }

    private void setError(SQLCommand stmtProperties) {
        stmtProperties.setProperty("prop_error_string", ScriptRunnerDbArb.getString("SQLPLUS_COMMAND_USAGE"));
    }

    private void resolveCompoundSetCommands(SQLCommand stmtProperties, String line) {
        if (this.m_isCompoundSetStmt && this.m_setSubCommandCount > 0 && !this.m_isFirstPartOfCompoundSetStmt) {
            stmtProperties.setIsSetCompoundCmd(true);
            stmtProperties.setCompoundSetcmd(null);
            --this.m_setSubCommandCount;
            if (this.m_setSubCommandCount == 0) {
                this.m_isCompoundSetStmt = false;
            }
        }
        if (this.m_isCompoundSetStmt && this.m_isFirstPartOfCompoundSetStmt) {
            stmtProperties.setIsSetCompoundCmd(true);
            stmtProperties.setCompoundSetcmd(line);
            this.m_isFirstPartOfCompoundSetStmt = false;
            --this.m_setSubCommandCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLCommand refineStmtRecognition(SQLCommand stmtProperties, String line) {
        String property = null;
        String propertyNotLowered = null;
        if (stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET) {
            String[] tokens = this.getTokens(line);
            if (tokens.length < 2) {
                stmtProperties.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_ECHO);
                this.setError(stmtProperties);
                stmtProperties.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
                return stmtProperties;
            }
            if (tokens[1].equalsIgnoreCase("constraint") || tokens[1].equalsIgnoreCase("constraints") || tokens[1].equalsIgnoreCase("role") || tokens[1].equalsIgnoreCase("transaction")) {
                SQLCommand subCmd = this.getSetCommand(tokens[1]);
                subCmd.setOrigSQL(line);
                subCmd.setModifiedSQL(line);
                subCmd.setStartLine(stmtProperties.getStartLine());
                subCmd.setEndLine(stmtProperties.getEndLine());
                subCmd.setLines(stmtProperties.getLines());
                subCmd.setOrigEndLine(stmtProperties.getOrigEndLine());
                subCmd.setOrigStartLine(stmtProperties.getOrigStartLine());
                subCmd.setStmtType(SQLCommand.StmtType.G_C_SQL);
                return subCmd;
            }
            if (tokens[1].equalsIgnoreCase("worksheetname")) {
                SQLCommand subCmd = this.getSetCommand(tokens[1]);
                subCmd.setOrigSQL(line);
                subCmd.setModifiedSQL(line);
                subCmd.setStartLine(stmtProperties.getStartLine());
                subCmd.setEndLine(stmtProperties.getEndLine());
                subCmd.setLines(stmtProperties.getLines());
                subCmd.setOrigEndLine(stmtProperties.getOrigEndLine());
                subCmd.setOrigStartLine(stmtProperties.getOrigStartLine());
                subCmd.setStmtType(SQLCommand.StmtType.G_C_USERDEFINED);
                stmtProperties = subCmd;
                if (tokens.length <= 2) {
                    this.setError(stmtProperties);
                    return stmtProperties;
                }
                propertyNotLowered = tokens[2];
                property = tokens[2].toLowerCase();
                if (property.equals("on")) {
                    stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
                } else if (property.equals("off")) {
                    stmtProperties.setProperty("prop_status_boolean", new Boolean(false));
                }
                if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
                    stmtProperties.setProperty("prop_file_string", propertyNotLowered);
                } else {
                    stmtProperties.setProperty("prop_file_string", property);
                }
                if (stmtProperties.getProperty("prop_status_boolean") != null) return stmtProperties;
                stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
                return stmtProperties;
            }
            if (tokens[1].equalsIgnoreCase("history")) {
                SQLCommand subCmd = this.getSetCommand(tokens[1]);
                subCmd.setOrigSQL(line);
                subCmd.setModifiedSQL(line);
                subCmd.setStartLine(stmtProperties.getStartLine());
                subCmd.setEndLine(stmtProperties.getEndLine());
                subCmd.setLines(stmtProperties.getLines());
                subCmd.setOrigEndLine(stmtProperties.getOrigEndLine());
                subCmd.setOrigStartLine(stmtProperties.getOrigStartLine());
                subCmd.setStmtType(SQLCommand.StmtType.G_C_USERDEFINED);
                return subCmd;
            }
            stmtProperties.setProperty("SET_TOKENS", tokens);
            stmtProperties.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
            return stmtProperties;
        }
        if (stmtProperties.isSqlPlusSetCmd() || stmtProperties.isCreateCmd() || stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME) {
            String[] tokens = this.getTokens(line);
            if (tokens.length <= 2) {
                this.setError(stmtProperties);
                return stmtProperties;
            }
            propertyNotLowered = tokens[2];
            property = tokens[2].toLowerCase();
            if (property.equals("replace") || property.equals("temporary")) {
                if (tokens.length <= 4) {
                    this.setError(stmtProperties);
                    return stmtProperties;
                }
                propertyNotLowered = tokens[4];
                property = tokens[4];
            }
        } else {
            String[] tokens;
            if (stmtProperties.getStmtSubType() != SQLCommand.StmtSubType.G_S_SPOOL) {
                if (stmtProperties.getStmtSubType() != SQLCommand.StmtSubType.G_S_DEFINE) return stmtProperties;
            }
            if ((tokens = this.getTokens(line)).length <= 1) return stmtProperties;
            propertyNotLowered = tokens[1];
            property = tokens[1].toLowerCase();
        }
        if (property.equals("on")) {
            stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
        } else if (property.equals("off")) {
            stmtProperties.setProperty("prop_status_boolean", new Boolean(false));
        }
        if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
            stmtProperties.setProperty("prop_file_string", propertyNotLowered);
        } else {
            stmtProperties.setProperty("prop_file_string", property);
        }
        if (stmtProperties.getProperty("prop_status_boolean") != null) return stmtProperties;
        stmtProperties.setProperty("prop_status_boolean", new Boolean(true));
        return stmtProperties;
    }

    private void lateEvaluateInitCompoundSetCommand(SQLCompoundCommand cmd, boolean newlineRemoved) {
        SQLCompoundCommand compCmd = cmd;
        Boolean parsed = (Boolean)compCmd.getProperty("SET_PARSED");
        if (parsed == null || !parsed.booleanValue()) {
            String[] tokens = null;
            tokens = !newlineRemoved ? this.getTokens(SQLPLUS.removeDashNewline(cmd, cmd.getOrigSQL())) : this.getTokens(cmd.getOrigSQL());
            cmd.setProperty("SET_PARSED", Boolean.TRUE);
            if (tokens != null) {
                int lastCommandEnd = 0;
                for (int i = 1; i < tokens.length; ++i) {
                    SQLCommand subCmd = null;
                    boolean allTokens = false;
                    if (i != lastCommandEnd + 1) {
                        int peekBack;
                        String tokenLower = tokens[i].toLowerCase(Locale.US);
                        subCmd = this.getSetCommand(tokenLower);
                        if (subCmd != null && (tokenLower.startsWith("wra") || tokenLower.startsWith("tru")) && i > 2 && tokens[i - 1].toLowerCase(Locale.US).startsWith("for")) {
                            for (peekBack = lastCommandEnd + 1; peekBack < i; ++peekBack) {
                                if (!tokens[peekBack].toLowerCase(Locale.US).startsWith("serverout")) continue;
                                subCmd = null;
                                break;
                            }
                        }
                        if (subCmd != null && (tokenLower.equals("table") || tokenLower.equals("worksheetname") || tokenLower.equals("spool"))) {
                            subCmd = null;
                        } else if (subCmd == null) {
                            allTokens = this.checkAllTokens(tokenLower);
                            if (allTokens && (tokenLower.startsWith("wra") || tokenLower.startsWith("tru")) && i > 2 && tokens[i - 1].toLowerCase(Locale.US).startsWith("for")) {
                                for (peekBack = lastCommandEnd + 1; peekBack < i; ++peekBack) {
                                    if (!tokens[peekBack].toLowerCase(Locale.US).startsWith("serverout")) continue;
                                    allTokens = false;
                                    break;
                                }
                            }
                            if (allTokens && tokenLower.equals("context")) {
                                allTokens = false;
                            }
                            if (allTokens && (tokenLower.equals("table") || tokenLower.equals("worksheetname") || tokenLower.equals("spool"))) {
                                allTokens = false;
                            }
                        }
                        if (tokenLower.equals("head") && tokens[lastCommandEnd + 1].toLowerCase(Locale.US).startsWith("mark") && i + 1 != tokens.length - 1 && !tokens[i + 1].toLowerCase(Locale.US).equals("on") && !tokens[i + 1].toLowerCase(Locale.US).equals("off")) {
                            subCmd = null;
                            allTokens = false;
                        }
                    }
                    String lastLower = "";
                    String secondLastLower = "";
                    if (subCmd != null || allTokens) {
                        lastLower = tokens[i - 1].toLowerCase(Locale.US);
                        if (i > lastCommandEnd + 1) {
                            secondLastLower = tokens[i - 2].toLowerCase(Locale.US);
                        }
                        if (i > lastCommandEnd + 1 && (tokens[lastCommandEnd + 1].toLowerCase(Locale.US).startsWith("errorl") && (lastLower.equals("table") || lastLower.equals("identifier")) && !secondLastLower.equals("table") && !secondLastLower.equals("identifier") || tokens[lastCommandEnd + 1].toLowerCase(Locale.US).startsWith("mark") && (lastLower.equals("table") || lastLower.equals("body") || lastLower.equals("head")) && !secondLastLower.equals("table") && !secondLastLower.equals("body") && !secondLastLower.equals("head"))) {
                            subCmd = null;
                        } else if (i == lastCommandEnd + 2 && (lastLower.startsWith("appi") || lastLower.startsWith("editf") || lastLower.startsWith("colsep") || lastLower.equals("null") || lastLower.startsWith("pau") || lastLower.startsWith("worksheetname") || lastLower.startsWith("numf") || lastLower.startsWith("sqlco") || lastLower.startsWith("sqlp") || lastLower.equals("instance") || lastLower.equals("logsource") || lastLower.startsWith("suf"))) {
                            subCmd = null;
                        } else if (i == lastCommandEnd + 3 && tokens[i - 2].toLowerCase().equals("xquery") && (lastLower.equals("context") || lastLower.equals("baseuri"))) {
                            subCmd = null;
                        }
                    }
                    if (subCmd == null && !allTokens) continue;
                    this.fillSubCmd(cmd, tokens, lastCommandEnd, i - 1);
                    lastCommandEnd = i - 1;
                }
                if (lastCommandEnd != tokens.length - 1) {
                    this.fillSubCmd(cmd, tokens, lastCommandEnd, tokens.length - 1);
                }
            }
        }
    }

    private void checkIfCompoundSetCommand(SQLCommand stmtProperties, String line) {
        Boolean parsed = (Boolean)stmtProperties.getProperty("SET_PARSED");
        if (!(parsed != null && parsed.booleanValue() || line == null)) {
            String[] tokens = null;
            String theSet = "set";
            if (line.trim().substring(0, 3).equalsIgnoreCase(theSet) && (tokens = this.getTokens(line)).length > 3) {
                this.m_isCompoundSetStmt = true;
                this.m_isFirstPartOfCompoundSetStmt = true;
            }
        }
    }

    private SQLCommand fillSubCmd(SQLCompoundCommand compCmd, String[] tokens, int lastEnd, int thisEnd) {
        SQLCommand subCmd = this.getSetCommand(tokens[lastEnd + 1]);
        if (subCmd == null) {
            subCmd = new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_SET_UNKNOWN, SQLCommand.StmtResultType.G_R_NONE, false);
            compCmd.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_UNKNOWN);
            return subCmd;
        }
        if (subCmd != null || tokens[lastEnd + 1].equalsIgnoreCase("worksheetname")) {
            int i;
            compCmd.addCommand(subCmd);
            String theSet = "set";
            if (compCmd.getOrigSQL().trim().length() > 3 && compCmd.getOrigSQL().trim().substring(0, 3).equalsIgnoreCase(theSet)) {
                theSet = compCmd.getOrigSQL().trim().substring(0, 3);
            }
            StringBuffer setStringBuffer = new StringBuffer(theSet);
            for (int j = lastEnd + 1; j <= thisEnd && j < tokens.length; ++j) {
                if (tokens[j] == null) continue;
                setStringBuffer.append(" " + tokens[j]);
            }
            subCmd.setOrigStartLine(compCmd.getOrigStartLine());
            subCmd.setOrigEndLine(compCmd.getOrigEndLine());
            subCmd.setStartLine(compCmd.getStartLine());
            subCmd.setEndLine(compCmd.getEndLine());
            subCmd.setOrigSQL(setStringBuffer.toString());
            subCmd.setModifiedSQL(subCmd.getOrigSQL());
            if (this.m_isCompoundSetStmt && this.m_setSubCommandCount > 0 && !this.m_isFirstPartOfCompoundSetStmt) {
                subCmd.setIsSetCompoundCmd(true);
                subCmd.setCompoundSetcmd(null);
            }
            if (thisEnd >= (i = lastEnd + 1) + 1) {
                String propertyNotLowered = tokens[i + 1];
                String property = propertyNotLowered.toLowerCase();
                if (property.equals("on")) {
                    subCmd.setProperty("prop_status_boolean", Boolean.TRUE);
                } else if (property.equals("off")) {
                    subCmd.setProperty("prop_status_boolean", Boolean.FALSE);
                }
                if (propertyNotLowered != null && !propertyNotLowered.equals("")) {
                    subCmd.setProperty("prop_file_string", propertyNotLowered);
                } else {
                    subCmd.setProperty("prop_file_string", property);
                }
                if (subCmd.getProperty("prop_status_boolean") == null) {
                    subCmd.setProperty("prop_status_boolean", Boolean.TRUE);
                }
                if (subCmd.getProperty("prop_status_boolean") == null) {
                    subCmd.setProperty("prop_status_boolean", new Boolean(true));
                }
            } else {
                this.setError(subCmd);
            }
        } else {
            compCmd.setStmtSubType(SQLCommand.StmtSubType.G_S_SET_UNKNOWN);
        }
        return subCmd;
    }

    private boolean checkAllTokens(String token) {
        String[] cutOn;
        for (String key : cutOn = new String[]{"appi", "array", "auto", "blo", "cmds", "colsep", "con", "copyc", "copytypecheck", "def", "describe", "echo", "editf", "emb", "errorl", "esc", "exitc", "feed", "flagger", "flu", "hea", "instrance", "lin", "lobof", "logsource", "long", "mark", "newp", "null", "num", "pages", "prompt", "pau", "recsep", "serverout", "shift", "show", "sqlbl", "sqlc", "sqln", "sqlpluscompat", "sqlpre", "sqlp", "sqlt", "suf", "tab", "term", "ti", "trim", "und", "ver", "wra", "xmlopt", "xquery"}) {
            if (!token.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    private SQLCommand getSetCommand(String token) {
        String tokenLower = token.toLowerCase(Locale.US);
        Set<String> keys = SQLStatementTypes.setCommandsExact.keySet();
        for (String key : keys) {
            if (!tokenLower.equals(key)) continue;
            return SQLStatementTypes.setCommandsExact.get(key);
        }
        keys = SQLStatementTypes.setCommands.keySet();
        for (String key : keys) {
            if (!tokenLower.startsWith(key)) continue;
            return SQLStatementTypes.setCommands.get(key);
        }
        return null;
    }

    private String[] getTokens(String line) {
        line = line.replaceAll("\r\n|[\r\n\u2028\u2029\u0085]|\t", " ");
        line = line.replace("  ", " ");
        if ((line = line.trim()).endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        State currentState = State.NORM;
        ArrayList<String> myTokens = new ArrayList<String>();
        int lastFlush = 0;
        block5: for (int i = 0; i < line.length(); ++i) {
            switch (currentState) {
                case INQUOTE: {
                    if (line.charAt(i) != '\'') continue block5;
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\'') {
                        currentState = State.NORM;
                        myTokens.add(line.substring(lastFlush, i + 1));
                        while (i + 1 != line.length() && line.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        lastFlush = i + 1;
                        continue block5;
                    }
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\'') continue block5;
                    ++i;
                    continue block5;
                }
                case INDOUBLEQUOTE: {
                    if (line.charAt(i) != '\"') continue block5;
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\"') {
                        currentState = State.NORM;
                        myTokens.add(line.substring(lastFlush, i + 1));
                        while (i + 1 != line.length() && line.charAt(i + 1) == ' ') {
                            ++i;
                        }
                        lastFlush = i + 1;
                        continue block5;
                    }
                    if (i == line.length() - 1 || line.charAt(i + 1) != '\"') continue block5;
                    ++i;
                    continue block5;
                }
                case NORM: {
                    if (line.charAt(i) == '\'') {
                        if (i != 0 && line.charAt(i - 1) != ' ') continue block5;
                        currentState = State.INQUOTE;
                        continue block5;
                    }
                    if (line.charAt(i) == '\"') {
                        if (i != 0 && line.charAt(i - 1) != ' ') continue block5;
                        currentState = State.INDOUBLEQUOTE;
                        continue block5;
                    }
                    if (line.charAt(i) != ' ') continue block5;
                    myTokens.add(line.substring(lastFlush, i));
                    while (i + 1 != line.length() && line.charAt(i + 1) == ' ') {
                        ++i;
                    }
                    lastFlush = i + 1;
                }
            }
        }
        if (lastFlush != line.length()) {
            myTokens.add(line.substring(lastFlush));
        }
        return myTokens.toArray(new String[myTokens.size()]);
    }

    private SQLCommand getPropertiesWhenMulitpleTokensKnown(String line) {
        String strippedLine = this.stripLine(line.trim());
        Set<String> keys = SQLStatementTypes.multiToken.keySet();
        for (String key : keys) {
            if (!strippedLine.startsWith(key)) continue;
            return SQLStatementTypes.multiToken.get(key);
        }
        return null;
    }

    private SQLCommand createUnknownStatementProperties() {
        return new SQLCommand(SQLCommand.StmtType.G_C_SQLPLUS, SQLCommand.StmtSubType.G_S_UNKNOWN, SQLCommand.StmtResultType.G_R_UNKNOWN, true);
    }

    private SQLCommand getPropertiesWhenNoSpaceRequired(String line) {
        SQLCommand prop = null;
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        String input = null;
        if ((line = line.trim()).length() >= 2) {
            input = line.trim().substring(0, 2);
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
            } else {
                input = line.trim().substring(0, 1);
                if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                    prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
                }
            }
        } else {
            input = line;
            if (SQLStatementTypes.noSpaceRequiredTokens.containsKey(input)) {
                prop = SQLStatementTypes.noSpaceRequiredTokens.get(input);
            }
        }
        return prop;
    }

    private SQLCommand getPropertiesWhenTokensKnown(String line) {
        String[] tokens = line.trim().split("[ \n\r\t*=\\-]");
        if (tokens[0] != null) {
            if (tokens[0].length() > 0 && tokens[0].charAt(tokens[0].length() - 1) == ';') {
                tokens[0] = tokens[0].replaceAll(";", "");
            }
            return SQLStatementTypes.spaceRequiredTokens.get(tokens[0].toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    private boolean isWrapped(String currentStatement, SQLCommand stmtProperties) {
        Boolean declaredWrapped = (Boolean)stmtProperties.getProperty("prop_is_wrapped");
        if (declaredWrapped != null && declaredWrapped.equals(Boolean.TRUE)) {
            return declaredWrapped;
        }
        String lowercaseStmt = currentStatement.toLowerCase();
        if (lowercaseStmt.indexOf("wrapped") == -1) {
            return false;
        }
        boolean result = false;
        String commentLessLowerCase = this.checkInLineComments(lowercaseStmt);
        int wrappedStart = commentLessLowerCase.indexOf("wrapped");
        if (wrappedStart > 2 && commentLessLowerCase.length() > wrappedStart + 8) {
            char charBefore = commentLessLowerCase.charAt(wrappedStart - 1);
            char charAfter = commentLessLowerCase.charAt(wrappedStart + 7);
            if (Character.isWhitespace(charBefore) && Character.isWhitespace(charAfter)) {
                result = true;
                stmtProperties.setProperty("prop_is_wrapped", true);
            }
        }
        return result;
    }

    private void createRefineRecalculate() {
        if (this.createRefine.getProperty("CREATEREFINE") == null || this.createRefine.getProperty("CREATEREFINE").equals(Boolean.FALSE)) {
            return;
        }
        if (!(this.createRefine.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN) || this.createRefine.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && this.createRefine.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL))) {
            return;
        }
        String stripSoFar = ScriptUtils.stripFirstN(this.createRefineLineSoFar.toString(), 400, true, false);
        SQLCommand command = this.getPropertiesWhenMulitpleTokensKnown(stripSoFar);
        if (command != null && (command.isCreatePLSQLCmd() || command.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && command.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL))) {
            this.createRefineReturnOnSemicolon = false;
            this.createRefineSemiColonTerminates = false;
            this.createRefine.setStmtType(command.getStmtType());
            this.createRefine.setStmtClass(command.getStmtClass());
            this.createRefine.setStmtSubType(command.getStmtSubType());
            this.createRefine.setResultsType(command.getResultsType());
            this.createRefine.setExecutable(command.getExecutable());
            this.createRefine.setRunnable(command.getRunnable());
        }
        this.createRefine.setProperty("CREATEREFINE", Boolean.FALSE);
    }

    private StringBuffer findEndOfSQLAndPLSQL(String line, BufferedReaderStack reader, SQLCommand stmtProperties, boolean semiColonTerminatesIn) throws IOException {
        this.createRefine = stmtProperties;
        this.createRefineSemiColonTerminates = semiColonTerminatesIn;
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        boolean enquote = false;
        int embeddedSemicolon = 0;
        String stmtTerminator = null;
        while (searching) {
            int quotes;
            int initialSemicolon = -1;
            if (line == null) {
                quotes = 0;
            } else {
                boolean returnOnSemiColon = true;
                if (stmtProperties.getStmtType() == SQLCommand.StmtType.G_C_PLSQL || stmtProperties.getProperty(TERMINATOR) != null && stmtProperties.getProperty(TERMINATOR) == FORWARDSLASH) {
                    returnOnSemiColon = false;
                }
                this.createRefineReturnOnSemicolon = returnOnSemiColon;
                if (this.createRefine.getProperty("CREATEREFINE") != null && this.createRefine.getProperty("CREATEREFINE").equals(Boolean.TRUE)) {
                    this.createRefineLineSoFar = new StringBuffer(currentStatement);
                    if (line != null) {
                        this.createRefineLineSoFar.append("\n").append(line);
                    }
                }
                int[] retval = this.numberOfQuotes(line, true);
                quotes = retval[0];
                embeddedSemicolon = retval[1];
                initialSemicolon = retval[2];
            }
            if (quotes % 2 != 0) {
                boolean bl = enquote = !enquote;
            }
            if (this.createRefineReturnOnSemicolon && line.trim().endsWith(";")) {
                enquote = false;
                embeddedSemicolon = 0;
            }
            if (line != null && !this.createRefineSemiColonTerminates && enquote && (line.trim().endsWith("\n/") || line.trim().equals(FORWARDSLASH)) && this.isWrapped(currentStatement.toString(), stmtProperties)) {
                quotes = 0;
                enquote = false;
            }
            if (line != null && !enquote) {
                if (initialSemicolon != -1 && this.createRefineSemiColonTerminates) {
                    if (line.length() != initialSemicolon + 1) {
                        this.m_leftOver = line.substring(initialSemicolon + 1);
                        if (this.m_leftOver.trim().equals("")) {
                            this.m_leftOver = null;
                        }
                    } else {
                        this.m_leftOver = null;
                    }
                    line = line.substring(0, initialSemicolon);
                    stmtTerminator = ";";
                    searching = false;
                } else if (line.trim().endsWith(";") && embeddedSemicolon == 0 && this.createRefineSemiColonTerminates) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf(";"));
                    stmtTerminator = ";";
                } else if (this.hasForwardSlashOnLastLine(line)) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf(FORWARDSLASH));
                    stmtTerminator = FORWARDSLASH;
                    if (stmtProperties.getProperty(TERMINATOR) != null && stmtProperties.getProperty(TERMINATOR) == FORWARDSLASH && currentStatement.toString().trim().endsWith(";")) {
                        int i = currentStatement.length() - 1;
                        while (currentStatement.charAt(i) != ';') {
                            currentStatement.deleteCharAt(i);
                            --i;
                        }
                        currentStatement.deleteCharAt(i);
                        stmtTerminator = ";\n/";
                    }
                } else if (line.trim().equals(".")) {
                    searching = false;
                    line = line.substring(0, line.lastIndexOf("."));
                    stmtTerminator = ".";
                    stmtProperties.setExecutable(false);
                    stmtProperties.setRunnable(false);
                }
                if (!line.trim().equals("")) {
                    currentStatement.append(line);
                }
                if (searching) {
                    line = reader.readLine();
                    if (line != null) {
                        currentStatement.append("\n");
                    }
                    ++this.m_readerLineCnt;
                }
            } else {
                if (!line.trim().equals("")) {
                    currentStatement.append(line);
                }
                if ((line = reader.readLine()) != null) {
                    currentStatement.append("\n");
                }
                ++this.m_readerLineCnt;
            }
            if (searching && (line == null && (stmtProperties.getStmtType() != SQLCommand.StmtType.G_C_SQL || stmtProperties.getStmtType() == SQLCommand.StmtType.G_C_SQL && !this.isSQLBlankLines()) || line != null && line.trim().equals("") && stmtProperties.getStmtType() == SQLCommand.StmtType.G_C_SQL && !this.isSQLBlankLines())) {
                searching = false;
                if (!this.isInFile()) continue;
                stmtProperties.setIsComplete(false);
                stmtProperties.setExecutable(false);
                stmtProperties.setRunnable(false);
                continue;
            }
            if (!searching || line != null) continue;
            searching = false;
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        stmtProperties.setStatementTerminator(stmtTerminator);
        return currentStatement;
    }

    private boolean hasForwardSlashOnLastLine(String line) {
        try {
            if (line == null) {
                return false;
            }
            if (line.trim().endsWith(System.getProperty("line.separator") + FORWARDSLASH) || line.trim().equals(FORWARDSLASH)) {
                return true;
            }
            int lastLineIndex = line.lastIndexOf("\n");
            if (lastLineIndex == -1) break block6;
            String lastLine = line.substring(lastLineIndex + 1);
            if (lastLine.trim().equals(FORWARDSLASH)) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block6: {
            }
        }
    }

    private boolean isBareConnect(SQLCommand stmtProperties, String soFar) {
        return stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT) && soFar.trim().indexOf(" ") == -1 && soFar.indexOf("\n") == -1;
    }

    private StringBuffer findEndOfSQLPLUS(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        while (searching) {
            boolean isBareConnect = this.isBareConnect(stmtProperties, currentStatement + line);
            if (isBareConnect || line.trim().endsWith("-") && !line.trim().startsWith("--")) {
                searching = true;
                currentStatement.append(line + "\n");
                line = reader.readLine();
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                continue;
            }
            searching = false;
            currentStatement.append(line + "\n");
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        if (currentStatement.toString().trim().endsWith(";") && currentStatement.length() > 1) {
            String s = currentStatement.substring(0, currentStatement.lastIndexOf(";"));
            currentStatement = new StringBuffer(s);
            stmtProperties.setStatementTerminator(";");
        }
        return currentStatement;
    }

    private StringBuffer findEndOfMultiLineComment(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        while (searching) {
            int nearEndOfComment = line.indexOf("*/");
            if (nearEndOfComment >= 0) {
                searching = false;
                if (nearEndOfComment + 2 == line.length()) {
                    this.m_leftOver = null;
                } else {
                    this.m_leftOver = line.substring(nearEndOfComment + 2);
                    if (this.m_leftOver.trim().equals("")) {
                        this.m_leftOver = null;
                    }
                    line = line.substring(0, nearEndOfComment + 2);
                }
                currentStatement.append(line + "\n");
                continue;
            }
            currentStatement.append(line + "\n");
            line = reader.readLine(false);
            ++this.m_readerLineCnt;
            if (line != null) continue;
            searching = false;
            currentStatement.append("*/");
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private StringBuffer findEndOfOldComment(String line, BufferedReaderStack reader, SQLCommand stmtProperties) throws IOException {
        StringBuffer currentStatement = new StringBuffer();
        boolean searching = true;
        while (searching) {
            if (!line.trim().equals("#")) {
                currentStatement.append(line + "\n");
                line = reader.readLine(false);
                ++this.m_readerLineCnt;
                if (line != null) continue;
                searching = false;
                currentStatement.append("\n#\n");
                continue;
            }
            currentStatement.append(line + "\n");
            searching = false;
        }
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private SQLCommand identifyEndOfStatement(String line, BufferedReaderStack reader, SQLCommand stmtProperties) {
        StringBuffer currentStatement = new StringBuffer();
        try {
            switch (stmtProperties.getStmtType()) {
                case G_C_SQL: {
                    boolean semiColonTerminator = true;
                    if (stmtProperties.getProperty(TERMINATOR) != null && stmtProperties.getProperty(TERMINATOR) == FORWARDSLASH) {
                        semiColonTerminator = false;
                    }
                    currentStatement = this.findEndOfSQLAndPLSQL(line, reader, stmtProperties, semiColonTerminator);
                    break;
                }
                case G_C_SCRIPT: 
                case G_C_PLSQL: {
                    currentStatement = this.findEndOfSQLAndPLSQL(line, reader, stmtProperties, false);
                    break;
                }
                case G_C_SQLPLUS: {
                    currentStatement = this.findEndOfSQLPLUS(line, reader, stmtProperties);
                    break;
                }
                case G_C_USERDEFINED: 
                case G_C_COMMENT: {
                    currentStatement = this.findEndOfLine(line, stmtProperties);
                    break;
                }
                case G_C_UNKNOWN: {
                    s_logger.severe(ScriptRunnerDbArb.format("UNSUPPORTED_COMMAND_ARG", line));
                }
                case G_C_MULTILINECOMMENT: {
                    currentStatement = this.findEndOfMultiLineComment(line, reader, stmtProperties);
                    break;
                }
                case G_C_OLDCOMMENT: {
                    currentStatement = this.findEndOfOldComment(line, reader, stmtProperties);
                    break;
                }
            }
        }
        catch (IOException e) {
            s_logger.severe(e.getLocalizedMessage());
        }
        this.m_state = 0;
        if (currentStatement.length() > 0) {
            String currstmt = currentStatement.toString();
            if (!(stmtProperties.getStmtResultType() == null || stmtProperties.getStmtResultType() != SQLCommand.StmtResultType.G_R_QUERY && stmtProperties.getStmtResultType() != SQLCommand.StmtResultType.G_R_DML || this.isWrapped(currentStatement.toString(), stmtProperties))) {
                currstmt = this.checkInLineComments(currentStatement.toString());
                stmtProperties.setProperty("STRIPPED_CONTINUATION", Boolean.TRUE);
            }
            if (stmtProperties.getStmtResultType() != null && stmtProperties.getStmtSubType() == SQLCommand.StmtSubType.G_S_WITH && currstmt.trim().endsWith(";")) {
                currstmt = currstmt.trim().substring(0, currstmt.trim().length() - 1);
            }
            stmtProperties.setOrigSQL(currentStatement.toString());
            stmtProperties.setModifiedSQL(currstmt);
        } else {
            stmtProperties.setOrigSQL(currentStatement.toString());
            stmtProperties.setModifiedSQL(currentStatement.toString());
        }
        if (stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET) && stmtProperties instanceof SQLCompoundCommand) {
            SQLCompoundCommand localCompound = (SQLCompoundCommand)stmtProperties;
            String stmt_terminator = null;
            if (stmtProperties.getStatementTerminator() != null) {
                stmt_terminator = stmtProperties.getStatementTerminator();
            }
            if (this.m_setSubCommandCount == 0) {
                this.checkIfCompoundSetCommand(localCompound, line);
            }
            this.lateEvaluateInitCompoundSetCommand(localCompound, this.m_setLeftOver != null);
            if (!stmtProperties.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SET_UNKNOWN)) {
                if (this.m_setLeftOver == null) {
                    this.m_setLeftOver = this.m_leftOver == null ? "" : this.m_leftOver;
                }
                List<SQLCommand> theCommands = localCompound.getCommands();
                if (this.m_isCompoundSetStmt && this.m_isFirstPartOfCompoundSetStmt) {
                    this.m_setSubCommandCount = theCommands.size();
                }
                String unusedTokens = "set ";
                boolean setMade = false;
                for (SQLCommand aCommand : theCommands) {
                    if (!setMade) {
                        stmtProperties = aCommand;
                        if (stmt_terminator != null) {
                            stmtProperties.setStatementTerminator(stmt_terminator);
                        }
                        setMade = true;
                        continue;
                    }
                    unusedTokens = unusedTokens + aCommand.getSql().trim().substring(3).trim() + " ";
                }
                if (theCommands.size() == 1) {
                    if (!this.m_setLeftOver.trim().equals("")) {
                        this.m_leftOver = this.m_setLeftOver;
                    }
                    this.m_setLeftOver = null;
                } else {
                    this.m_leftOver = unusedTokens;
                }
            }
            if (this.m_isCompoundSetStmt) {
                this.resolveCompoundSetCommands(stmtProperties, line);
            }
        } else if (this.m_setLeftOver != null) {
            this.m_leftOver = this.m_setLeftOver;
            this.m_setLeftOver = null;
        }
        return stmtProperties;
    }

    private StringBuffer findEndOfLine(String line, SQLCommand stmtProperties) {
        StringBuffer currentStatement = new StringBuffer();
        currentStatement.append(line + "\n");
        stmtProperties.setOrigStartLine(this.m_readerLineStartCnt);
        stmtProperties.setOrigEndLine(this.m_readerLineCnt);
        return currentStatement;
    }

    private String checkInLineComments(String currstmt) {
        currstmt = ScriptUtils.checkforContinuationChars(currstmt);
        return currstmt;
    }

    public String stripLine(String line) {
        String comp = line;
        comp = comp.replaceAll("/\\*.*\\*/", "");
        comp = comp.replaceAll("--.*?\n", "");
        comp = comp.replaceAll(" ", "");
        comp = comp.replaceAll("\n", "");
        comp = comp.replaceAll("\r", "");
        comp = comp.replaceAll("\t", "");
        comp = comp.toLowerCase();
        return comp;
    }

    private String getTop(String inString) {
        String top = null;
        this._numOfEmptyLineAbove = 0;
        try {
            if (inString == null) {
                top = this.m_reader.readTopLine();
                ++this.m_readerLineCnt;
            } else {
                top = inString;
            }
            if (top == null) {
                return null;
            }
            while (this.isWhitespaceLTrim(top).equals("")) {
                ++this._numOfEmptyLineAbove;
                top = this.m_reader.readTopLine();
                ++this.m_readerLineCnt;
                if (top != null) continue;
                return null;
            }
            if (top != null) {
                top = this.isWhitespaceLTrim(top);
            }
            this.m_readerLineStartCnt = this.m_readerLineCnt;
            String topTrimLowerCase = top.trim().toLowerCase();
            if (topTrimLowerCase.startsWith("create") || topTrimLowerCase.startsWith("drop") || topTrimLowerCase.startsWith("alter") || topTrimLowerCase.startsWith("with")) {
                String currLine = top;
                String currLineLowerCase = null;
                while (currLine != null && currLine.indexOf(";") == -1 && currLine.indexOf(FORWARDSLASH) == -1 && (currLineLowerCase = currLine.toLowerCase()).indexOf("begin") == -1 && currLineLowerCase.indexOf("wrapped") == -1) {
                    currLine = this.m_reader.readLine(true);
                    if (currLine != null) {
                        top = top + "\n" + currLine;
                    }
                    ++this.m_readerLineCnt;
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return top;
    }

    private String isWhitespaceLTrim(String top) {
        if (top == null || top.equals("")) {
            return top;
        }
        int firstNonWhitespace = -1;
        int lastNewLine = -1;
        for (int i = 0; i < top.length(); ++i) {
            if (!Character.isWhitespace(top.charAt(i))) {
                firstNonWhitespace = i;
                break;
            }
            if (top.charAt(i) != '\n') continue;
            lastNewLine = i;
        }
        if (firstNonWhitespace == -1) {
            top = "";
        } else if (firstNonWhitespace != 0) {
            if (0 < lastNewLine + 1 && lastNewLine + 1 <= firstNonWhitespace) {
                top = top.substring(lastNewLine + 1);
            } else if (lastNewLine == -1) {
                // empty if block
            }
        }
        return top;
    }

    public String getRawSQL() {
        return this.m_rawSQL;
    }

    public void setRawSQL(String rawSQL) {
        this.m_rawSQL = rawSQL;
    }

    public ISQLCommand[] getSqlStatements() {
        return this.m_sqlArray.toArray(new SQLCommand[this.m_sqlArray.size()]);
    }

    private boolean amIInitial(String inString, boolean concat) {
        int state = 0;
        int position = 0;
        while (true) {
            int newPos;
            if (state == 0) {
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < m_startAndEnd.length; ++i) {
                    nextMatch = inString.indexOf(m_startAndEnd[i][0], position);
                    if (nextMatch == -1 || nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                nextMatch = inString.indexOf("Q'", position);
                if (nextMatch != -1 && nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                if (matchVal == 5) {
                    this.m_quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    this.m_quoteString = ScriptParser.getEndQuoteString(this.m_quoteString);
                }
                if (matchVal == 5) {
                    state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    return state == 0;
                }
                state = matchVal;
                position = lowestMatch + m_startAndEnd[matchVal][0].length();
                continue;
            }
            String endString = m_startAndEnd[state][1];
            if (state == 5) {
                endString = this.m_quoteString + endString;
            }
            if ((newPos = inString.indexOf(endString, position)) == -1) {
                return state == 0;
            }
            position = newPos + endString.length();
            if (state == 4 || state == 5) {
                this.m_quoteString = "";
            }
            state = 0;
        }
    }

    private int[] numberOfQuotes(String inString, boolean concat) {
        int noOfQuotes = 0;
        int position = 0;
        int embeddedSemicolon = 0;
        int initialSemicolon = -1;
        if ((inString = inString.replaceAll("\r", "")).indexOf(10) != -1) {
            int[] retVal = null;
            int lengthSoFar = 0;
            for (String s : inString.split("\n")) {
                retVal = this.numberOfQuotes(s, concat);
                noOfQuotes += retVal[0];
                if (this.createRefineReturnOnSemicolon && retVal[2] != -1) {
                    return new int[]{noOfQuotes, retVal[1], retVal[2] + lengthSoFar};
                }
                lengthSoFar = lengthSoFar + s.length() + "\n".length();
            }
            return new int[]{noOfQuotes, retVal[1], retVal[2]};
        }
        while (true) {
            if (this.m_state == 0) {
                int nextSemi;
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < m_startAndEnd.length; ++i) {
                    nextMatch = inString.indexOf(m_startAndEnd[i][0], position);
                    if (nextMatch == -1 || nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                nextMatch = inString.indexOf("Q'", position);
                if (nextMatch != -1 && nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                if (this.createRefine.getProperty("CREATEREFINE") != null && this.createRefine.getProperty("CREATEREFINE").equals(Boolean.TRUE) && this.createRefineReturnOnSemicolon && (nextSemi = inString.indexOf(";", position)) != -1 && nextSemi < lowestMatch) {
                    this.createRefineRecalculate();
                }
                if (this.createRefineReturnOnSemicolon && (nextMatch = inString.indexOf(";", position)) != -1 && nextMatch < lowestMatch) {
                    this.setFirstLine(inString);
                    initialSemicolon = nextMatch;
                    int[] retval = new int[]{noOfQuotes, 0, initialSemicolon};
                    return retval;
                }
                if (matchVal == 5) {
                    this.m_quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    this.m_quoteString = ScriptParser.getEndQuoteString(this.m_quoteString);
                }
                if (matchVal == 5) {
                    ++noOfQuotes;
                    this.m_state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    ++noOfQuotes;
                    this.m_state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 1 && this.m_firstLine && inString.substring(lowestMatch).replaceAll("\\s+$", "").equals("--") && !inString.replaceAll("\\s+$", "").replaceAll("^\\s+", "").equals("--")) {
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    this.setFirstLine(inString);
                    int[] retval = new int[]{noOfQuotes, 0, initialSemicolon};
                    return retval;
                }
                this.m_state = matchVal;
                position = lowestMatch + m_startAndEnd[matchVal][0].length();
                continue;
            }
            String endString = m_startAndEnd[this.m_state][1];
            if (this.m_state == 5) {
                endString = this.m_quoteString + endString;
            }
            boolean stillGrabbing = false;
            int newPos = inString.indexOf(endString, position);
            if (concat && this.m_firstLine && this.m_state == 1 && newPos == -1 && inString.replaceAll("\\s+$", "").endsWith("-") && !inString.replaceAll("^\\s+", "").startsWith("--")) {
                stillGrabbing = true;
            }
            if (concat && this.m_firstLine && this.m_state == 1) {
                while (newPos != -1) {
                    boolean grabAgain;
                    boolean bl = grabAgain = inString.substring(position, newPos).replaceAll("\\s+$", "").endsWith("-") && !inString.replaceAll("^\\s+", "").startsWith("--");
                    if (!grabAgain) break;
                    if (newPos + 1 <= inString.length()) {
                        newPos = inString.indexOf(endString, newPos + 1);
                        continue;
                    }
                    stillGrabbing = true;
                    newPos = -1;
                }
            }
            if (newPos == -1) {
                if (this.m_state == 1) {
                    if (!stillGrabbing) {
                        this.m_state = 0;
                    }
                    if (inString.trim().endsWith(";")) {
                        embeddedSemicolon = 1;
                    }
                } else if (this.m_state != 0 && inString.trim().endsWith(";")) {
                    embeddedSemicolon = 1;
                }
                this.setFirstLine(inString);
                int[] retval = new int[]{noOfQuotes, embeddedSemicolon, initialSemicolon};
                return retval;
            }
            position = newPos + endString.length();
            if (this.m_state == 4 || this.m_state == 5) {
                ++noOfQuotes;
                this.m_quoteString = "";
            }
            this.m_state = 0;
        }
    }

    void setFirstLine(String inString) {
        if (this.m_firstLine && (!inString.replaceAll("\\s+$", "").endsWith("-") || inString.replaceAll("^\\s+", "").startsWith("--"))) {
            this.m_firstLine = false;
        }
    }

    boolean isQuoteStringValid(String quoteString) {
        boolean retVal = true;
        if (quoteString.equals("\t") || quoteString.equals("\r") || quoteString.equals("\n") || quoteString.equals(" ")) {
            retVal = false;
        }
        return retVal;
    }

    public static String getEndQuoteString(String inQuote) {
        String retVal = inQuote;
        if (retVal.equals("[")) {
            retVal = "]";
        } else if (retVal.equals("{")) {
            retVal = "}";
        } else if (retVal.equals("<")) {
            retVal = ">";
        } else if (retVal.equals("(")) {
            retVal = ")";
        }
        return retVal;
    }

    private boolean isInFile() {
        if (this._scriptRunnerContext == null) {
            return false;
        }
        return this._scriptRunnerContext.getProperty("script.runner.appinfo.arraylist") != null && ((ArrayList)this._scriptRunnerContext.getProperty("script.runner.appinfo.arraylist")).size() > 0;
    }

    private boolean isSQLBlankLines() {
        if (this._scriptRunnerContext == null) {
            return true;
        }
        String sqlbl = (String)this._scriptRunnerContext.getProperty("SQLBLANKLINES");
        boolean on = false;
        on = sqlbl == null ? false : sqlbl.equals("on");
        return on;
    }

    public void setScriptRunnerContext(ScriptRunnerContext runCtx) {
        this._scriptRunnerContext = runCtx;
    }

    static enum State {
        NORM,
        INQUOTE,
        INDOUBLEQUOTE;

    }
}

