/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.metadata.AbstractDisplayModel;
import oracle.dbtools.raptor.metadata.AbstractObjectAction;
import oracle.dbtools.raptor.metadata.AbstractObjectActionPrompt;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLFactory<DM extends AbstractDisplayModel<DM, OA>, OA extends AbstractObjectAction<OAP>, OAP extends AbstractObjectActionPrompt> {
    public static final String RENAME_ACTION_NAME = "Rename...";
    private static Map<String, String[]> s_nodeTypeMap = new HashMap<String, String[]>();

    protected abstract DM newDisplayModel(Node var1, ClassLoader var2, XLIFFHelper var3);

    protected abstract OA newObjectAction(Node var1, ClassLoader var2, XLIFFHelper var3);

    protected abstract OAP newObjectActionPrompt(Node var1, ClassLoader var2, XLIFFHelper var3);

    public DM createDisplayModel(Node domNode, ClassLoader cl, XLIFFHelper xliffhelper) {
        DM dm = this.newDisplayModel(domNode, cl, xliffhelper);
        this.initDisplayModel(domNode, cl, xliffhelper, dm);
        this.initDisplayModelPost(domNode, cl, xliffhelper, dm);
        return dm;
    }

    public OA createObjectAction(Node domNode, ClassLoader cl, XLIFFHelper xliffhelper) {
        OA objAction = this.newObjectAction(domNode, cl, xliffhelper);
        this.initObjectAction(domNode, cl, xliffhelper, objAction);
        this.initObjectActionPost(domNode, cl, xliffhelper, objAction);
        return objAction;
    }

    public OAP createObjectActionPrompt(Node domNode, ClassLoader cl, XLIFFHelper xliffhelper) {
        OAP objAction = this.newObjectActionPrompt(domNode, cl, xliffhelper);
        this.initObjectActionPrompt(domNode, cl, xliffhelper, objAction);
        this.initObjectActionPromptPost(domNode, cl, xliffhelper, objAction);
        return objAction;
    }

    protected void initDisplayModelPost(Node node, ClassLoader cl, XLIFFHelper xliffHelper, DM dm) {
    }

    protected final void initDisplayModel(Node node, ClassLoader cl, XLIFFHelper xliffHelper, DM dm) {
        ((AbstractDisplayModel)dm).setCl(cl);
        ((AbstractDisplayModel)dm).setName(XMLFactory.notNull(XMLHelper.getNodeValue(node, "name")));
        ((AbstractDisplayModel)dm).setDescription(XMLFactory.notNull(XMLHelper.getNodeValue(node, "description")));
        ((AbstractDisplayModel)dm).setToolTip(XMLFactory.notNull(XMLHelper.getNodeValue(node, "tooltip")));
        ((AbstractDisplayModel)dm).setDrillClass(XMLFactory.notNull(XMLHelper.getNodeValue(node, "drillClass")));
        ((AbstractDisplayModel)dm).setIconName(XMLFactory.notNull(XMLHelper.getNodeValue(node, "iconName")));
        ((AbstractDisplayModel)dm).setActions(this.getActions(node, cl, xliffHelper));
        if (xliffHelper != null) {
            ((AbstractDisplayModel)dm).setName(xliffHelper.getTranslation(((AbstractDisplayModel)dm).getName()));
            ((AbstractDisplayModel)dm).setDescription(xliffHelper.getTranslation(((AbstractDisplayModel)dm).getDescription()));
            ((AbstractDisplayModel)dm).setToolTip(xliffHelper.getTranslation(((AbstractDisplayModel)dm).getToolTip()));
        }
        NamedNodeMap attrs = node.getAttributes();
        Node n = null;
        HashMap<String, String> extAttrs = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            n = attrs.item(i);
            if (n.getNodeName().equals("type")) {
                ((AbstractDisplayModel)dm).setType(XMLFactory.notNull(XMLHelper.getAttributeNode(node, "type")));
                continue;
            }
            if (n.getNodeName().equals("style")) {
                ((AbstractDisplayModel)dm).setStyle(XMLFactory.notNull(XMLHelper.getAttributeNode(node, "style")));
                continue;
            }
            if (n.getNodeName().equals("id")) {
                ((AbstractDisplayModel)dm).setID(XMLFactory.notNull(XMLHelper.getAttributeNode(node, "id")));
                continue;
            }
            if (n.getNodeName().equals("enable")) {
                ((AbstractDisplayModel)dm).setEnable(Boolean.parseBoolean(XMLFactory.notNullBoolean(XMLHelper.getAttributeNode(node, "enable"))));
                continue;
            }
            if (n.getNodeName().equals("noRefresh")) {
                ((AbstractDisplayModel)dm).setNoRefresh(Boolean.parseBoolean(XMLFactory.notNullBoolean(XMLHelper.getAttributeNode(node, "noRefresh"))));
                continue;
            }
            if (n.getNodeName().equals("connType")) {
                ((AbstractDisplayModel)dm).setConnType(XMLHelper.getAttributeNode(node, "connType"));
                continue;
            }
            if (n.getNodeName().equals("objectType")) {
                ((AbstractDisplayModel)dm).setObjectType(XMLHelper.getAttributeNode(node, "objectType"));
                continue;
            }
            if (extAttrs == null) {
                extAttrs = new HashMap<String, String>();
            }
            extAttrs.put(n.getNodeName(), n.getNodeValue().intern());
        }
        ((AbstractDisplayModel)dm).setExtAttributes(extAttrs);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equalsIgnoreCase("CustomValues")) {
                NodeList custom = children.item(i).getChildNodes();
                HashMap<String, String> extValues = null;
                for (int zz = 0; zz < custom.getLength(); ++zz) {
                    String nn = custom.item(zz).getNodeName();
                    String value = custom.item(zz).getTextContent();
                    if (extValues == null) {
                        extValues = new HashMap<String, String>();
                    }
                    if (nn.equals("#text")) continue;
                    extValues.put(nn, value.intern());
                }
                ((AbstractDisplayModel)dm).setExtValues(extValues);
                continue;
            }
            if (name.equalsIgnoreCase("query")) {
                ((AbstractDisplayModel)dm).addQuery(Query.getQuery(child, xliffHelper, cl));
                continue;
            }
            if (name.equalsIgnoreCase("display")) {
                DM childDM = this.createDisplayModel(child, cl, xliffHelper);
                ((AbstractDisplayModel)dm).addChild(childDM);
                continue;
            }
            if (!name.equalsIgnoreCase("queries")) continue;
            ((AbstractDisplayModel)dm).setQueries(Query.getQueries(child, cl));
        }
        if (((AbstractDisplayModel)dm).getType() != null && ((AbstractDisplayModel)dm).getType().equals("editor")) {
            if (((AbstractDisplayModel)dm).getName() == null) {
                ((AbstractDisplayModel)dm).setName(XMLHelper.getNodeValue(node, "title"));
            }
            if (((AbstractDisplayModel)dm).getType() == null) {
                ((AbstractDisplayModel)dm).setType(XMLHelper.getAttributeNode(node, "vertical"));
            }
            if (((AbstractDisplayModel)dm).getStyle() == null) {
                ((AbstractDisplayModel)dm).setStyle(XMLHelper.getAttributeNode(node, "display"));
            }
            if (((AbstractDisplayModel)dm).getQueries() == null || ((AbstractDisplayModel)dm).getQueries().size() == 0) {
                DM model;
                String queryID = XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "query"), "id");
                if (queryID != null && !queryID.equals("")) {
                    ((AbstractDisplayModel)dm).setQueries(QueryCache.getQueries(queryID));
                } else {
                    ((AbstractDisplayModel)dm).setQueries(Query.getQueries(node));
                }
                if (XMLHelper.getChildNode(node, "bottomquery") != null) {
                    Node bottomQueryNode = XMLHelper.getChildNode(node, "bottomquery");
                    model = this.newDisplayModel(null, cl, xliffHelper);
                    ((AbstractDisplayModel)model).setName(XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "bottomquery"), "title"));
                    queryID = XMLHelper.getAttributeNode(XMLHelper.getChildNode(XMLHelper.getChildNode(node, "bottomquery"), "query"), "id");
                    if (queryID != null && !queryID.equals("")) {
                        ((AbstractDisplayModel)model).setQueries(QueryCache.getQueries(queryID));
                    } else {
                        ((AbstractDisplayModel)model).setQueries(Query.getQueries(XMLHelper.getChildNode(node, "bottomquery")));
                    }
                    ((AbstractDisplayModel)dm).addChild(model);
                }
                if (XMLHelper.getChildNode(node, "subquery") != null) {
                    Node subqueryNode = XMLHelper.getChildNode(node, "subquery");
                    model = this.newDisplayModel(null, cl, xliffHelper);
                    ((AbstractDisplayModel)model).setQueries(Query.getQueries(XMLHelper.getChildNode(node, "subquery")));
                    ((AbstractDisplayModel)model).setStyle(XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "subquery"), "type"));
                    ((AbstractDisplayModel)dm).addChild(model);
                }
            }
        }
    }

    protected void initObjectActionPost(Node node, ClassLoader cl, XLIFFHelper xliff, OA oa) {
    }

    protected final void initObjectAction(Node node, ClassLoader cl, XLIFFHelper xliff, OA oa) {
        String section;
        ((AbstractObjectAction)oa).setTitle(XMLHelper.getNodeValue(node, "title"));
        ((AbstractObjectAction)oa).setIsRenameAction(RENAME_ACTION_NAME.equals(((AbstractObjectAction)oa).getTitle()));
        ((AbstractObjectAction)oa).setSql(XMLHelper.getNodeValue(node, "sql"));
        ((AbstractObjectAction)oa).setScript(XMLHelper.getNodeValue(node, "script"));
        ((AbstractObjectAction)oa).setScriptLang(XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "script"), "language"));
        ((AbstractObjectAction)oa).setSqlType(XMLHelper.getAttributeNode(XMLHelper.getChildNode(node, "sql"), "type"));
        String iconName = XMLHelper.getNodeValue(node, "iconName");
        if (ModelUtil.hasLength(iconName)) {
            ((AbstractObjectAction)oa).setIconRef(new MetaResource(cl, iconName));
        }
        ((AbstractObjectAction)oa).setSqldevOnly(XMLFactory.isTrue(XMLHelper.getAttributeNode(node, "sqldevonly")));
        ((AbstractObjectAction)oa).setReloadParent(XMLFactory.isTrue(XMLHelper.getAttributeNode(node, "reloadparent")));
        ((AbstractObjectAction)oa).setReload(XMLFactory.isTrue(XMLHelper.getAttributeNode(node, "reload")));
        ((AbstractObjectAction)oa).setRemoveFromParent(XMLFactory.isTrue(XMLHelper.getAttributeNode(node, "removeFromParent")));
        ((AbstractObjectAction)oa).setType(XMLHelper.getAttributeNode(node, "type"));
        ((AbstractObjectAction)oa).setConnType(XMLHelper.getAttributeNode(node, "connType"));
        ((AbstractObjectAction)oa).setClassArgs(XMLHelper.getAttributeNode(node, "classArgs"));
        ((AbstractObjectAction)oa).setSelectionMode(XMLHelper.getAttributeNode(node, "selectionMode"));
        ((AbstractObjectAction)oa).setConnRequired(XMLHelper.getAttributeNode(node, "connectionRequired") != null ? Boolean.valueOf(XMLHelper.getAttributeNode(node, "connectionRequired")) : true);
        ((AbstractObjectAction)oa).setToolbar(Boolean.parseBoolean(XMLHelper.getAttributeNode(node, "toolbar")));
        ((AbstractObjectAction)oa).setCommandName(XMLHelper.getAttributeNode(node, "commandName"));
        String weight = XMLHelper.getAttributeNode(node, "weight");
        if (weight != null) {
            try {
                ((AbstractObjectAction)oa).setWeight(XMLFactory.resolveFloatValue(weight, cl).floatValue());
            }
            catch (Exception e) {
                Logger.severe(this.getClass(), "Menu Weight", e);
            }
        }
        if ((section = XMLHelper.getAttributeNode(node, "section")) != null) {
            try {
                ((AbstractObjectAction)oa).setSection(XMLFactory.resolveFloatValue(section, cl).floatValue());
            }
            catch (NumberFormatException nfe) {
                Logger.severe(this.getClass(), "Menu Section", nfe);
            }
        }
        ((AbstractObjectAction)oa).setConfirm(XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "confirmation"), "prompt"));
        ((AbstractObjectAction)oa).setConfirmTitle(XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "confirmation"), "title"));
        ((AbstractObjectAction)oa).setConfirmSql(XMLHelper.getNodeValue(XMLHelper.getChildNode(node, "confirmation"), "sql"));
        ((AbstractObjectAction)oa).setHelp(XMLHelper.getNodeValue(node, "help"));
        ((AbstractObjectAction)oa).setPrompts(this.getPrompts(node, cl, xliff));
        ((AbstractObjectAction)oa).setMaxVersion(XMLHelper.getAttributeNode(node, "maxversion"));
        ((AbstractObjectAction)oa).setMinVersion(XMLHelper.getAttributeNode(node, "minversion"));
        String reqFeatures = XMLHelper.getAttributeNode(node, "requiredFeatures");
        ((AbstractObjectAction)oa).setReqFeatures(reqFeatures != null ? reqFeatures.split(",") : null);
        if (xliff != null) {
            ((AbstractObjectAction)oa).setTitle(xliff.getTranslation(((AbstractObjectAction)oa).getTitle()));
            ((AbstractObjectAction)oa).setConfirm(xliff.getTranslation(((AbstractObjectAction)oa).getConfirm()));
            ((AbstractObjectAction)oa).setConfirmTitle(xliff.getTranslation(((AbstractObjectAction)oa).getConfirmTitle()));
            ((AbstractObjectAction)oa).setHelp(xliff.getTranslation(((AbstractObjectAction)oa).getHelp()));
        }
    }

    protected void initObjectActionPromptPost(Node node, ClassLoader cl, XLIFFHelper xliff, OAP oap) {
    }

    protected final void initObjectActionPrompt(Node node, ClassLoader cl, XLIFFHelper xliff, OAP oap) {
        ((AbstractObjectActionPrompt)oap).setPrompt(XMLHelper.getNodeValue(node, "label"));
        ((AbstractObjectActionPrompt)oap).setValue(XMLHelper.getNodeValue(node, "value"));
        ((AbstractObjectActionPrompt)oap).setDefault(XMLHelper.getNodeValue(node, "default"));
        ((AbstractObjectActionPrompt)oap).setType(XMLHelper.getAttributeNode(node, "type"));
        ((AbstractObjectActionPrompt)oap).setRequired(XMLHelper.getAttributeNode(node, "required"));
        ((AbstractObjectActionPrompt)oap).setReadOnly(Boolean.parseBoolean(XMLHelper.getAttributeNode(node, "readonly")));
        ((AbstractObjectActionPrompt)oap).setValidator(XMLHelper.getAttributeNode(node, "validator"));
        ((AbstractObjectActionPrompt)oap).setReload(XMLHelper.getAttributeNode(node, "reload"));
        ((AbstractObjectActionPrompt)oap).setDataType(XMLHelper.getAttributeNode(node, "datatype"));
        ((AbstractObjectActionPrompt)oap).setTypeAttribute(XMLHelper.getAttributeNode(node, "type_attrib"));
        if (xliff != null) {
            ((AbstractObjectActionPrompt)oap).setPrompt(xliff.getTranslation(((AbstractObjectActionPrompt)oap).getPrompt()));
        }
    }

    protected List<OA> getActions(Node node, ClassLoader cl, XLIFFHelper xliffHelper) {
        ArrayList<OA> ret = new ArrayList<OA>();
        NodeList nodes = ((Element)node).getElementsByTagName("item");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            OA oa = this.createObjectAction(child, cl, xliffHelper);
            ret.add(oa);
        }
        return ret;
    }

    protected List<OAP> getPrompts(Node node, ClassLoader cl, XLIFFHelper xliffhelper) {
        ArrayList<OAP> ret = new ArrayList<OAP>();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (!item.getNodeName().equals("prompt")) continue;
            OAP oap = this.createObjectActionPrompt(item, cl, xliffhelper);
            ret.add(oap);
        }
        return ret;
    }

    protected static boolean isTrue(String s) {
        return s != null && s.equalsIgnoreCase("true");
    }

    protected static Float resolveFloatValue(String value, ClassLoader cl) throws NumberFormatException {
        if (null == value) {
            return null;
        }
        Float floatValue = Float.valueOf(Float.MAX_VALUE);
        try {
            floatValue = Float.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            String className = value.substring(0, value.lastIndexOf("."));
            String fieldName = value.substring(value.lastIndexOf(".") + 1);
            try {
                Field field = Class.forName(className, true, cl).getDeclaredField(fieldName);
                Object val = field.get(null);
                if (val instanceof Float) {
                    floatValue = (Float)val;
                }
            }
            catch (Exception e) {
                Logger.warn(XMLFactory.class, e);
                throw nfe;
            }
        }
        return floatValue;
    }

    protected static String notNull(String value) {
        if (value == null || value.equals("null")) {
            return "";
        }
        return value;
    }

    protected static String notNullBoolean(String value) {
        if (value == null || value.equals("null")) {
            return "false";
        }
        return "true";
    }

    public static String[] getTypesForNode(String nodeType) {
        return s_nodeTypeMap.get(nodeType);
    }

    static {
        s_nodeTypeMap.put("TableNode", new String[]{"TABLE"});
        s_nodeTypeMap.put("ViewNode", new String[]{"VIEW"});
        s_nodeTypeMap.put("MViewNode", new String[]{"MATERIALIZED_VIEW"});
        s_nodeTypeMap.put("PlSqlBaseNode", new String[]{"PROCEDURE", "FUNCTION", "PACKAGE", "PACKAGE BODY", "TYPE", "TYPE BODY"});
        s_nodeTypeMap.put("DatabaseLinkNode", new String[]{"DATABASE LINK"});
        s_nodeTypeMap.put("MViewLogNode", new String[]{"MATERIALIZED VIEW LOG"});
        s_nodeTypeMap.put("TriggerNode", new String[]{"TRIGGER"});
        s_nodeTypeMap.put("IndexNode", new String[]{"INDEX"});
        s_nodeTypeMap.put("RecycledObjectNode", new String[]{"RECYCLEBIN"});
        s_nodeTypeMap.put("DirectoryNode", new String[]{"DIRECTORY"});
        s_nodeTypeMap.put("QueueNode", new String[]{"QUEUE"});
        s_nodeTypeMap.put("QueueTableNode", new String[]{"QUEUE TABLE"});
        s_nodeTypeMap.put("JavaNode", new String[]{"JAVA"});
        s_nodeTypeMap.put("XmlSchemaNode", new String[]{"XML SCHEMA"});
        s_nodeTypeMap.put("FunctionNode", new String[]{"FUNCTION"});
    }
}

