/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class XMLFormatter
extends ResultsFormatter {
    public static final String TYPE = "XML";
    public static final String EXT = "xml";
    public static final String KEY_REC_TERM = "EXPORT_XML_REC_TERM";
    private boolean _result = true;

    public XMLFormatter() {
        super(TYPE, Messages.getString("XMLFormatter.0"), EXT);
    }

    public void setResult(boolean result) {
        this._result = result;
    }

    @Override
    public void start() throws IOException {
        this.write("<?xml version='1.0'  encoding='" + this.getEncode() + "' ?>" + this.getLineTerminator());
        this.write("<RESULTS>" + this.getLineTerminator());
    }

    @Override
    public void startRow() throws IOException {
        this.write("\t<ROW>" + this.getLineTerminator());
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        String name = this.getColumnName(viewIndex);
        this.write("\t\t<COLUMN NAME=\"" + name.replace(' ', '_').replace('/', '_') + "\">");
        this.write("<![CDATA[");
        String val = this.getValue(col);
        if (val != null) {
            this.write(val);
        }
        this.write("]]>");
        this.write("</COLUMN>" + this.getLineTerminator());
    }

    @Override
    public void endRow() throws IOException {
        this.write("\t</ROW>" + this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
        this.write("</RESULTS>");
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    protected String getValue(Object col) {
        try {
            if (col instanceof Clob) {
                Clob clob = (Clob)col;
                Long remaining = clob.length();
                int length = 4000;
                String chunk = "";
                long pos = 1L;
                while (remaining > 0L) {
                    chunk = clob.getSubString(pos, length);
                    this.write(chunk);
                    remaining = remaining - (long)chunk.length();
                    pos += (long)chunk.length();
                }
                return null;
            }
            Object val = super.getValue(col);
            return val != null ? val.toString() : null;
        }
        catch (Exception e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }
}

